/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zzup;
import com.google.android.gms.internal.firebase-auth-api.zzvw;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.GenericIdpActivity;
import com.google.firebase.auth.zzab;
import com.google.firebase.auth.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OAuthProvider
extends FederatedAuthProvider {
    private final Bundle zza;

    @NonNull
    public static Builder newBuilder(@RecentlyNonNull String providerId) {
        return OAuthProvider.newBuilder(providerId, FirebaseAuth.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Builder newBuilder(@RecentlyNonNull String providerId, @RecentlyNonNull FirebaseAuth firebaseAuth) {
        Object object;
        void var1_1;
        Preconditions.checkNotEmpty((String)providerId);
        Preconditions.checkNotNull((Object)var1_1);
        if ("facebook.com".equals(object) && !zzvw.zzb(var1_1.getApp())) {
            object = new IllegalArgumentException("Sign in with Facebook is not supported via this method; the Facebook TOS dictate that you must use the Facebook Android SDK for Facebook login.");
            throw object;
        }
        Builder builder = new Builder((String)object, (FirebaseAuth)var1_1, null);
        return builder;
    }

    @RecentlyNullable
    public String getProviderId() {
        return this.zza.getString("com.google.firebase.auth.KEY_PROVIDER_ID");
    }

    @NonNull
    public static CredentialBuilder newCredentialBuilder(@RecentlyNonNull String providerId) {
        String string;
        CredentialBuilder credentialBuilder = new CredentialBuilder(Preconditions.checkNotEmpty((String)string), null);
        return credentialBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public static AuthCredential getCredential(@RecentlyNonNull String providerId, @RecentlyNonNull String idToken, @RecentlyNonNull String accessToken) {
        void var2_2;
        void var1_1;
        return zze.zzb(providerId, (String)var1_1, (String)var2_2, null, null);
    }

    @Override
    public final void zza(@RecentlyNonNull Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    @Override
    public final void zzb(@RecentlyNonNull Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_LINK");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    @Override
    public final void zzc(@RecentlyNonNull Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE");
        intent.setClass((Context)activity, GenericIdpActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    /* synthetic */ OAuthProvider(Bundle bundle, zzab zzab2) {
        this.zza = bundle;
    }

    public static class CredentialBuilder {
        private final String zza;
        @Nullable
        private String zzb;
        @Nullable
        private String zzc;
        @Nullable
        private String zzd;

        @KeepForSdk
        @RecentlyNullable
        public String getIdToken() {
            return this.zzb;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public CredentialBuilder setIdToken(@RecentlyNonNull String idToken) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public CredentialBuilder setIdTokenWithRawNonce(@RecentlyNonNull String idToken, @Nullable String rawNonce) {
            void var2_2;
            void var1_1;
            this.zzb = var1_1;
            this.zzd = var2_2;
            return this;
        }

        @KeepForSdk
        @RecentlyNullable
        public String getAccessToken() {
            return this.zzc;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public CredentialBuilder setAccessToken(@RecentlyNonNull String accessToken) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        @NonNull
        public AuthCredential build() {
            String string = ((CredentialBuilder)this_).zza;
            String string2 = ((CredentialBuilder)this_).zzb;
            String string3 = ((CredentialBuilder)this_).zzc;
            Object this_ = ((CredentialBuilder)this_).zzd;
            Preconditions.checkNotEmpty((String)string, (Object)"Must specify a non-empty providerId");
            if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
                this_ = new IllegalArgumentException("Must specify an idToken or an accessToken.");
                throw this_;
            }
            zze zze2 = new zze(string, string2, string3, null, null, null, (String)this_);
            return zze2;
        }

        /* synthetic */ CredentialBuilder(String string, zzab zzab2) {
            this.zza = string;
        }
    }

    public static class Builder {
        private final FirebaseAuth zzb;
        @VisibleForTesting
        final Bundle zza;
        private final Bundle zzc;

        @KeepForSdk
        @NonNull
        public List<String> getScopes() {
            ArrayList this_ = ((Builder)((Object)this_)).zza.getStringArrayList("com.google.firebase.auth.KEY_PROVIDER_SCOPES");
            if (this_ != null) {
                return this_;
            }
            return Collections.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setScopes(@RecentlyNonNull List<String> scopes) {
            void var1_1;
            Bundle bundle = this.zza;
            ArrayList arrayList = new ArrayList(var1_1);
            bundle.putStringArrayList("com.google.firebase.auth.KEY_PROVIDER_SCOPES", arrayList);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addCustomParameter(@RecentlyNonNull String paramKey, @RecentlyNonNull String paramValue) {
            void var2_2;
            void var1_1;
            this.zzc.putString((String)var1_1, (String)var2_2);
            return this;
        }

        @NonNull
        public Builder addCustomParameters(@RecentlyNonNull Map<String, String> customParameters) {
            for (Map.Entry<String, String> entry : customParameters.entrySet()) {
                this.zzc.putString(entry.getKey(), entry.getValue());
            }
            return this;
        }

        @NonNull
        public OAuthProvider build() {
            OAuthProvider oAuthProvider = new OAuthProvider(this.zza, null);
            return oAuthProvider;
        }

        /* synthetic */ Builder(String string, FirebaseAuth firebaseAuth, zzab zzab2) {
            this.zza = zzab2;
            super();
            this.zzc = zzab2;
            this.zzb = firebaseAuth;
            this.zza.putString("com.google.firebase.auth.KEY_API_KEY", this.zzb.getApp().getOptions().getApiKey());
            this.zza.putString("com.google.firebase.auth.KEY_PROVIDER_ID", string);
            this.zza.putBundle("com.google.firebase.auth.KEY_PROVIDER_CUSTOM_PARAMS", this.zzc);
            this.zza.putString("com.google.firebase.auth.internal.CLIENT_VERSION", zzup.zzb().zza());
            this.zza.putString("com.google.firebase.auth.KEY_TENANT_ID", this.zzb.getTenantId());
            this.zza.putString("com.google.firebase.auth.KEY_FIREBASE_APP_NAME", this.zzb.getApp().getName());
        }
    }
}

