/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.internal.firebase-auth-api.zzh;
import com.google.android.gms.internal.firebase-auth-api.zztw;
import com.google.android.gms.internal.firebase-auth-api.zztx;
import com.google.android.gms.internal.firebase-auth-api.zzty;
import com.google.android.gms.internal.firebase-auth-api.zzvw;
import com.google.android.gms.internal.firebase-auth-api.zzxv;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.internal.zzai;
import com.google.firebase.auth.internal.zzbl;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzi;
import com.google.firebase.auth.internal.zzj;
import com.google.firebase.auth.internal.zzk;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

@KeepName
public class GenericIdpActivity
extends FragmentActivity
implements zzty {
    private final Executor zzb = zzh.zza().zza(1);
    private static long zzc = 0L;
    private boolean zzd = false;
    private static final zzbm zze = zzbm.zza();

    /*
     * Enabled aggressive block sorting
     */
    protected final void onCreate(@RecentlyNonNull Bundle object) {
        super.onCreate((Bundle)object);
        String string = this.getIntent().getAction();
        if (!("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN".equals(string) || "com.google.firebase.auth.internal.NONGMSCORE_LINK".equals(string) || "com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE".equals(string) || "android.intent.action.VIEW".equals(string))) {
            object = String.valueOf(string);
            string = "Could not do operation - unknown action: ";
            object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
            Log.e((String)"GenericIdpActivity", (String)object);
            this.zzh();
            return;
        }
        long l = DefaultClock.getInstance().currentTimeMillis();
        if (l - zzc < 30000L) {
            Log.e((String)"GenericIdpActivity", (String)"Could not start operation - already in progress");
            return;
        }
        zzc = l;
        if (object != null) {
            this.zzd = object.getBoolean("com.google.firebase.auth.internal.KEY_STARTED_SIGN_IN");
            return;
        }
    }

    protected final void onSaveInstanceState(@RecentlyNonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("com.google.firebase.auth.internal.KEY_STARTED_SIGN_IN", this.zzd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void onResume() {
        block12: {
            String string;
            super.onResume();
            if ("android.intent.action.VIEW".equals(this.getIntent().getAction())) {
                Intent intent = this.getIntent();
                if (intent.hasExtra("firebaseError")) {
                    this.zzi(zzbl.zzd(intent.getStringExtra("firebaseError")));
                    return;
                }
                if (intent.hasExtra("link") && intent.hasExtra("eventId")) {
                    String string2;
                    String string3 = intent.getStringExtra("link");
                    String string4 = intent.getStringExtra("eventId");
                    String string5 = this.getPackageName();
                    boolean bl = intent.getBooleanExtra("encryptionEnabled", true);
                    zzi zzi2 = zzj.zza().zzd((Context)this, string5, string4);
                    if (zzi2 == null) {
                        this.zzh();
                    }
                    String string6 = bl ? zzk.zza(this.getApplicationContext(), FirebaseApp.getInstance((String)zzi2.zze()).getPersistenceKey()).zzc(string3) : string3;
                    zzxv zzxv2 = new zzxv(zzi2, string6);
                    string6 = zzi2.zzd();
                    String string7 = zzi2.zzb();
                    zzxv2.zzd(string6);
                    if ("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN".equals(string7) || "com.google.firebase.auth.internal.NONGMSCORE_LINK".equals(string7) || "com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE".equals(string7)) {
                        zzc = 0L;
                        this.zzd = false;
                        string5 = new Intent();
                        SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)zzxv2, (Intent)string5, (String)"com.google.firebase.auth.internal.VERIFY_ASSERTION_REQUEST");
                        string5.putExtra("com.google.firebase.auth.internal.OPERATION", string7);
                        string5.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
                        if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast((Intent)string5)) {
                            string5 = this.getApplicationContext().getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
                            string5.putString("verifyAssertionRequest", SafeParcelableSerializer.serializeToString((SafeParcelable)zzxv2));
                            string5.putString("operation", string7);
                            string5.putString("tenantId", string6);
                            string5.putLong("timestamp", DefaultClock.getInstance().currentTimeMillis());
                            string5.commit();
                        } else {
                            zze.zzh((Context)this);
                        }
                        this.finish();
                        return;
                    }
                    string6 = "unsupported operation: ";
                    string6 = string7.length() != 0 ? string6.concat(string7) : (string2 = new String(string6));
                    Log.e((String)"GenericIdpActivity", (String)string6);
                    this.zzh();
                    return;
                }
                this.zzh();
                return;
            }
            if (this.zzd) {
                this.zzh();
                return;
            }
            String string8 = this.getPackageName();
            try {
                byte[] byArray = AndroidUtilsLight.getPackageCertificateHashBytes((Context)this, (String)string8);
                string = Hex.bytesToStringUppercase((byte[])byArray).toLowerCase(Locale.US);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                String string9 = String.valueOf((Object)nameNotFoundException);
                String string10 = String.valueOf(string8);
                int n = string10.length();
                String string11 = String.valueOf(string9);
                int n2 = string11.length();
                StringBuilder stringBuilder = new StringBuilder(n + 34 + n2);
                stringBuilder.append("Could not get package signature: ");
                stringBuilder.append(string8);
                stringBuilder.append(" ");
                stringBuilder.append(string9);
                Log.e((String)"GenericIdpActivity", (String)stringBuilder.toString());
                this.zze(string8, null);
                break block12;
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)this.getIntent().getStringExtra("com.google.firebase.auth.KEY_FIREBASE_APP_NAME"));
            if (!zzvw.zzb(firebaseApp)) {
                zztw zztw2 = new zztw(string8, string, this.getIntent(), this);
                zztw2.executeOnExecutor(this.zzb, new Void[0]);
            } else {
                this.zza(this.zzg(Uri.parse((String)zzvw.zzg(firebaseApp.getOptions().getApiKey())).buildUpon(), this.getIntent(), string8, string).build(), string8);
            }
        }
        this.zzd = true;
    }

    public final void onNewIntent(@RecentlyNonNull Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    @Override
    public final void zza(@RecentlyNonNull Uri uri, @RecentlyNonNull String string) {
        Object object = new Intent("android.intent.action.VIEW");
        if (this.getPackageManager().resolveActivity((Intent)object, 0) != null) {
            object = this.getPackageManager();
            Intent intent = new Intent("android.support.customtabs.action.CustomTabsService");
            if ((object = object.queryIntentServices(intent, 0)) != null && !object.isEmpty()) {
                string = new CustomTabsIntent.Builder();
                string = string.build();
                ((CustomTabsIntent)string).intent.addFlags(0x40000000);
                ((CustomTabsIntent)string).intent.addFlags(0x10000000);
                string.launchUrl((Context)this, uri);
                return;
            }
            object = new Intent("android.intent.action.VIEW", uri);
            object.putExtra("com.android.browser.application_id", string);
            object.addFlags(0x40000000);
            object.addFlags(0x10000000);
            this.startActivity((Intent)object);
            return;
        }
        Log.e((String)"GenericIdpActivity", (String)"Device cannot resolve intent for: android.intent.action.VIEW");
        this.zze(string, null);
    }

    @Override
    @RecentlyNullable
    public final HttpURLConnection zzb(@RecentlyNonNull URL uRL) {
        try {
            Object object = uRL.openConnection();
            object = (HttpURLConnection)object;
            return object;
        }
        catch (IOException iOException) {
            Log.e((String)"GenericIdpActivity", (String)"Error generating URL connection");
            return null;
        }
    }

    @Override
    @RecentlyNonNull
    public final String zzc(@RecentlyNonNull String string) {
        return zzvw.zze(string);
    }

    @Override
    @RecentlyNullable
    public final Uri.Builder zzd(@RecentlyNonNull Intent intent, @RecentlyNonNull String string, @RecentlyNonNull String string2) {
        Uri.Builder builder = new Uri.Builder();
        return this.zzg(builder.scheme("https").appendPath("__").appendPath("auth").appendPath("handler"), intent, string, string2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RecentlyNullable
    public final Uri.Builder zzg(@RecentlyNonNull Uri.Builder builder, @RecentlyNonNull Intent object, @RecentlyNonNull String string, @RecentlyNonNull String string2) {
        void var6_12;
        Object object2;
        String string3 = object.getStringExtra("com.google.firebase.auth.KEY_API_KEY");
        String string4 = object.getStringExtra("com.google.firebase.auth.KEY_PROVIDER_ID");
        String string5 = object.getStringExtra("com.google.firebase.auth.KEY_TENANT_ID");
        String string6 = object.getStringExtra("com.google.firebase.auth.KEY_FIREBASE_APP_NAME");
        Object object3 = object.getStringArrayListExtra("com.google.firebase.auth.KEY_PROVIDER_SCOPES");
        object3 = object3 != null ? (!((ArrayList)object3).isEmpty() ? TextUtils.join((CharSequence)",", (Iterable)object3) : null) : null;
        Bundle bundle = object.getBundleExtra("com.google.firebase.auth.KEY_PROVIDER_CUSTOM_PARAMS");
        if (bundle == null) {
            Object var6_11 = null;
        } else {
            JSONObject jSONObject = new JSONObject();
            try {
                boolean bl;
                object2 = bundle.keySet().iterator();
                while (bl = object2.hasNext()) {
                    String string7 = (String)object2.next();
                    String string8 = bundle.getString(string7);
                    boolean bl2 = TextUtils.isEmpty((CharSequence)string8);
                    if (bl2) continue;
                    jSONObject.put(string7, (Object)string8);
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)"GenericIdpActivity", (String)"Unexpected JSON exception when serializing developer specified custom params");
            }
            String string9 = jSONObject.toString();
        }
        String string10 = UUID.randomUUID().toString();
        object2 = zztx.zza((zzty)object4, UUID.randomUUID().toString());
        String string11 = object.getAction();
        object = object.getStringExtra("com.google.firebase.auth.internal.CLIENT_VERSION");
        zzj.zza().zzb(object4.getApplicationContext(), string, string10, (String)object2, string11, string4, string5, string6);
        string6 = FirebaseApp.getInstance((String)string6);
        string6 = zzk.zza(object4.getApplicationContext(), string6.getPersistenceKey()).zzb();
        if (TextUtils.isEmpty((CharSequence)string6)) {
            Log.e((String)"GenericIdpActivity", (String)"Could not generate an encryption key for Generic IDP - cancelling flow.");
            ((GenericIdpActivity)object4).zzi(zzai.zza("Failed to generate/retrieve public encryption key for Generic IDP flow."));
            return null;
        }
        if (object2 == null) {
            return null;
        }
        string11 = builder.appendQueryParameter("eid", "p");
        Object object4 = String.valueOf(object);
        object = "X";
        object4 = ((String)object4).length() != 0 ? ((String)object).concat((String)object4) : new String((String)object);
        string11.appendQueryParameter("v", (String)object4).appendQueryParameter("authType", "signInWithRedirect").appendQueryParameter("apiKey", string3).appendQueryParameter("providerId", string4).appendQueryParameter("sessionId", (String)object2).appendQueryParameter("eventId", string10).appendQueryParameter("apn", string).appendQueryParameter("sha1Cert", string2).appendQueryParameter("publicKey", string6);
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            builder.appendQueryParameter("scopes", (String)object3);
        }
        if (!TextUtils.isEmpty((CharSequence)var6_12)) {
            builder.appendQueryParameter("customParameters", (String)var6_12);
        }
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            builder.appendQueryParameter("tid", string5);
        }
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzh() {
        zzc = 0L;
        this.zzd = false;
        Intent intent = new Intent();
        intent.putExtra("com.google.firebase.auth.internal.EXTRA_CANCELED", true);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent)) {
            zze.zzg((Context)this, zzai.zza("WEB_CONTEXT_CANCELED"));
        } else {
            zze.zzh((Context)this);
        }
        this.finish();
    }

    @Override
    public final void zze(@RecentlyNonNull String string, @Nullable Status status) {
        if (status == null) {
            this.zzh();
            return;
        }
        this.zzi(status);
    }

    @Override
    @RecentlyNonNull
    public final Context zzf() {
        return this.getApplicationContext();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzi(Status status) {
        zzc = 0L;
        this.zzd = false;
        Intent intent = new Intent();
        zzbl.zza(intent, status);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent)) {
            zze.zzg(this.getApplicationContext(), status);
        } else {
            zze.zzh((Context)this);
        }
        this.finish();
    }
}

