/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-auth-api.zzoa;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseException;
import com.google.firebase.FirebaseNetworkException;
import com.google.firebase.FirebaseTooManyRequestsException;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthActionCodeException;
import com.google.firebase.auth.FirebaseAuthEmailException;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseAuthInvalidCredentialsException;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;
import com.google.firebase.auth.FirebaseAuthMultiFactorException;
import com.google.firebase.auth.FirebaseAuthRecentLoginRequiredException;
import com.google.firebase.auth.FirebaseAuthUserCollisionException;
import com.google.firebase.auth.FirebaseAuthWeakPasswordException;
import com.google.firebase.auth.FirebaseAuthWebException;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.internal.zzae;
import com.google.firebase.auth.internal.zzag;
import com.google.firebase.auth.internal.zzx;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import java.util.ArrayList;
import java.util.List;

public final class zzto {
    @VisibleForTesting
    static final SparseArray<Pair<String, String>> zza;

    public static FirebaseException zza(Status object) {
        int n = object.getStatusCode();
        String string = zzto.zze(zzto.zzf(n), object);
        switch (n) {
            default: {
                object = new FirebaseException("An internal error has occurred.");
                return object;
            }
            case 17499: {
                object = zzto.zze("An internal error has occurred.", object);
                FirebaseException firebaseException = new FirebaseException((String)object);
                return firebaseException;
            }
            case 17495: {
                object = zzto.zze("Please sign in before trying to get a token.", object);
                FirebaseNoSignedInUserException firebaseNoSignedInUserException = new FirebaseNoSignedInUserException((String)object);
                return firebaseNoSignedInUserException;
            }
            case 17063: 
            case 17080: {
                object = new FirebaseApiNotAvailableException(string);
                return object;
            }
            case 17061: {
                object = zzto.zze("There was a failure in the connection between the web widget and the Firebase Auth backend.", object);
                FirebaseNetworkException firebaseNetworkException = new FirebaseNetworkException((String)object);
                return firebaseNetworkException;
            }
            case 17057: 
            case 17058: 
            case 17062: 
            case 17065: {
                object = new FirebaseAuthWebException(zzto.zzd(n), string);
                return object;
            }
            case 17052: {
                object = new FirebaseTooManyRequestsException(string);
                return object;
            }
            case 17031: 
            case 17032: 
            case 17033: {
                object = new FirebaseAuthEmailException(zzto.zzd(n), string);
                return object;
            }
            case 17029: 
            case 17030: {
                object = new FirebaseAuthActionCodeException(zzto.zzd(n), string);
                return object;
            }
            case 17026: {
                FirebaseAuthWeakPasswordException firebaseAuthWeakPasswordException = new FirebaseAuthWeakPasswordException(zzto.zzd(n), string, object.getStatusMessage());
                return firebaseAuthWeakPasswordException;
            }
            case 17020: {
                object = zzto.zze("A network error (such as timeout, interrupted connection or unreachable host) has occurred.", object);
                FirebaseNetworkException firebaseNetworkException = new FirebaseNetworkException((String)object);
                return firebaseNetworkException;
            }
            case 17016: {
                object = zzto.zze("User was not linked to an account with the given provider.", object);
                FirebaseException firebaseException = new FirebaseException((String)object);
                return firebaseException;
            }
            case 17015: {
                object = zzto.zze("User has already been linked to the given provider.", object);
                FirebaseException firebaseException = new FirebaseException((String)object);
                return firebaseException;
            }
            case 17014: {
                object = new FirebaseAuthRecentLoginRequiredException(zzto.zzd(n), string);
                return object;
            }
            case 17010: {
                object = zzto.zze("We have blocked all requests from this device due to unusual activity. Try again later.", object);
                FirebaseTooManyRequestsException firebaseTooManyRequestsException = new FirebaseTooManyRequestsException((String)object);
                return firebaseTooManyRequestsException;
            }
            case 17007: 
            case 17012: 
            case 17025: {
                object = new FirebaseAuthUserCollisionException(zzto.zzd(n), string);
                return object;
            }
            case 17006: 
            case 17028: 
            case 17040: 
            case 17064: 
            case 17068: 
            case 17071: 
            case 17072: 
            case 17073: 
            case 17074: 
            case 17079: 
            case 17085: 
            case 17086: 
            case 17087: 
            case 17088: 
            case 17089: 
            case 17090: 
            case 17091: 
            case 17093: 
            case 18001: {
                object = new FirebaseAuthException(zzto.zzd(n), string);
                return object;
            }
            case 17005: 
            case 17011: 
            case 17017: 
            case 17021: {
                object = new FirebaseAuthInvalidUserException(zzto.zzd(n), string);
                return object;
            }
            case 17000: 
            case 17002: 
            case 17004: 
            case 17008: 
            case 17009: 
            case 17024: 
            case 17034: 
            case 17035: 
            case 17041: 
            case 17042: 
            case 17043: 
            case 17044: 
            case 17045: 
            case 17046: 
            case 17049: 
            case 17051: 
            case 17075: 
            case 17077: 
            case 17081: 
            case 17082: 
            case 17083: 
            case 17084: 
            case 17094: 
        }
        object = new FirebaseAuthInvalidCredentialsException(zzto.zzd(n), string);
        return object;
    }

    public static FirebaseException zzb(Status object, AuthCredential authCredential, @Nullable String string, @Nullable String string2) {
        int n = object.getStatusCode();
        if (n == 17012 || n == 17007 || n == 17025) {
            Object object2 = zzto.zzf(n);
            object = zzto.zze((String)object2, object);
            object2 = new FirebaseAuthUserCollisionException(zzto.zzd(n), (String)object);
            ((FirebaseAuthUserCollisionException)((Object)object2)).zza(authCredential);
            ((FirebaseAuthUserCollisionException)((Object)object2)).zzb(string);
            ((FirebaseAuthUserCollisionException)((Object)object2)).zzc(string2);
            return object2;
        }
        return zzto.zza(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirebaseAuthMultiFactorException zzc(FirebaseAuth firebaseAuth, zzoa zzoa2, @Nullable FirebaseUser firebaseUser) {
        if (firebaseAuth == null) throw null;
        if (zzoa2 == null) throw null;
        Pair pair = (Pair)zza.get(17078);
        String string = (String)pair.first;
        String string2 = (String)pair.second;
        List<MultiFactorInfo> list = zzoa2.zzc();
        ArrayList<PhoneMultiFactorInfo> arrayList = new ArrayList<PhoneMultiFactorInfo>();
        for (MultiFactorInfo multiFactorInfo : list) {
            if (!(multiFactorInfo instanceof PhoneMultiFactorInfo)) continue;
            arrayList.add((PhoneMultiFactorInfo)multiFactorInfo);
        }
        List<MultiFactorInfo> list2 = zzoa2.zzc();
        String string3 = zzoa2.zzb();
        zzag zzag2 = zzag.zzb(list2, string3);
        zzae zzae2 = new zzae(arrayList, zzag2, firebaseAuth.getApp().getName(), zzoa2.zza(), (zzx)firebaseUser);
        return new FirebaseAuthMultiFactorException(string, string2, zzae2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String zzd(int n) {
        void var0_3;
        Pair pair = (Pair)zza.get(n);
        if (pair == null) return var0_3;
        String string = (String)pair.first;
        return var0_3;
    }

    private static String zze(String string, Status status) {
        if (TextUtils.isEmpty((CharSequence)status.getStatusMessage())) {
            return string;
        }
        string = String.valueOf(string);
        string = string.concat(" [ %s ]");
        Object[] objectArray = new Object[]{status.getStatusMessage()};
        return String.format(string, objectArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String zzf(int n) {
        void var0_3;
        Pair pair = (Pair)zza.get(n);
        if (pair == null) return var0_3;
        String string = (String)pair.second;
        return var0_3;
    }

    static {
        SparseArray<Pair<String, String>> sparseArray;
        sparseArray = zza = (sparseArray = new SparseArray<Pair<String, String>>());
        Pair pair = new Pair((Object)"ERROR_INVALID_CUSTOM_TOKEN", (Object)"The custom token format is incorrect. Please check the documentation.");
        sparseArray.put(17000, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_CUSTOM_TOKEN_MISMATCH", (Object)"The custom token corresponds to a different audience.");
        sparseArray.put(17002, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_CREDENTIAL", (Object)"The supplied auth credential is malformed or has expired.");
        sparseArray.put(17004, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_EMAIL", (Object)"The email address is badly formatted.");
        sparseArray.put(17008, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_WRONG_PASSWORD", (Object)"The password is invalid or the user does not have a password.");
        sparseArray.put(17009, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_USER_MISMATCH", (Object)"The supplied credentials do not correspond to the previously signed in user.");
        sparseArray.put(17024, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_REQUIRES_RECENT_LOGIN", (Object)"This operation is sensitive and requires recent authentication. Log in again before retrying this request.");
        sparseArray.put(17014, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_ACCOUNT_EXISTS_WITH_DIFFERENT_CREDENTIAL", (Object)"An account already exists with the same email address but different sign-in credentials. Sign in using a provider associated with this email address.");
        sparseArray.put(17012, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_EMAIL_ALREADY_IN_USE", (Object)"The email address is already in use by another account.");
        sparseArray.put(17007, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_CREDENTIAL_ALREADY_IN_USE", (Object)"This credential is already associated with a different user account.");
        sparseArray.put(17025, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_USER_DISABLED", (Object)"The user account has been disabled by an administrator.");
        sparseArray.put(17005, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_USER_TOKEN_EXPIRED", (Object)"The user's credential is no longer valid. The user must sign in again.");
        sparseArray.put(17021, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_USER_NOT_FOUND", (Object)"There is no user record corresponding to this identifier. The user may have been deleted.");
        sparseArray.put(17011, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_USER_TOKEN", (Object)"This user's credential isn't valid for this project. This can happen if the user's token has been tampered with, or if the user isn't for the project associated with this API key.");
        sparseArray.put(17017, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_OPERATION_NOT_ALLOWED", (Object)"The given sign-in provider is disabled for this Firebase project. Enable it in the Firebase console, under the sign-in method tab of the Auth section.");
        sparseArray.put(17006, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_WEAK_PASSWORD", (Object)"The given password is invalid.");
        sparseArray.put(17026, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_EXPIRED_ACTION_CODE", (Object)"The out of band code has expired.");
        sparseArray.put(17029, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_ACTION_CODE", (Object)"The out of band code is invalid. This can happen if the code is malformed, expired, or has already been used.");
        sparseArray.put(17030, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_MESSAGE_PAYLOAD", (Object)"The email template corresponding to this action contains invalid characters in its message. Please fix by going to the Auth email templates section in the Firebase Console.");
        sparseArray.put(17031, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_RECIPIENT_EMAIL", (Object)"The email corresponding to this action failed to send as the provided recipient email address is invalid.");
        sparseArray.put(17033, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_SENDER", (Object)"The email template corresponding to this action contains an invalid sender email or name. Please fix by going to the Auth email templates section in the Firebase Console.");
        sparseArray.put(17032, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MISSING_EMAIL", (Object)"An email address must be provided.");
        sparseArray.put(17034, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MISSING_PASSWORD", (Object)"A password must be provided.");
        sparseArray.put(17035, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MISSING_PHONE_NUMBER", (Object)"To send verification codes, provide a phone number for the recipient.");
        sparseArray.put(17041, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_PHONE_NUMBER", (Object)"The format of the phone number provided is incorrect. Please enter the phone number in a format that can be parsed into E.164 format. E.164 phone numbers are written in the format [+][country code][subscriber number including area code].");
        sparseArray.put(17042, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MISSING_VERIFICATION_CODE", (Object)"The Phone Auth Credential was created with an empty sms verification Code");
        sparseArray.put(17043, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_VERIFICATION_CODE", (Object)"The sms verification code used to create the phone auth credential is invalid. Please resend the verification code sms and be sure use the verification code provided by the user.");
        sparseArray.put(17044, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MISSING_VERIFICATION_ID", (Object)"The Phone Auth Credential was created with an empty verification ID");
        sparseArray.put(17045, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_VERIFICATION_ID", (Object)"The verification ID used to create the phone auth credential is invalid.");
        sparseArray.put(17046, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_RETRY_PHONE_AUTH", (Object)"An error occurred during authentication using the PhoneAuthCredential. Please retry authentication.");
        sparseArray.put(17049, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_SESSION_EXPIRED", (Object)"The sms code has expired. Please re-send the verification code to try again.");
        sparseArray.put(17051, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_QUOTA_EXCEEDED", (Object)"This project's quota for this operation has been exceeded.");
        sparseArray.put(17052, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_APP_NOT_AUTHORIZED", (Object)"This app is not authorized to use Firebase Authentication. Please verify that the correct package name and SHA-1 are configured in the Firebase Console.");
        sparseArray.put(17028, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_API_NOT_AVAILABLE_WITHOUT_GOOGLE_PLAY", (Object)"The API that you are calling is not available on devices without Google Play services.");
        sparseArray.put(17063, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_WEB_INTERNAL_ERROR", (Object)"There was an internal error in the web widget.");
        sparseArray.put(17062, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_CERT_HASH", (Object)"There was an error while trying to get your package certificate hash.");
        sparseArray.put(17064, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_WEB_STORAGE_UNSUPPORTED", (Object)"This browser is not supported or 3rd party cookies and data may be disabled.");
        sparseArray.put(17065, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MISSING_CONTINUE_URI", (Object)"A continue URL must be provided in the request.");
        sparseArray.put(17040, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_DYNAMIC_LINK_NOT_ACTIVATED", (Object)"Please activate Dynamic Links in the Firebase Console and agree to the terms and conditions.");
        sparseArray.put(17068, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_PROVIDER_ID", (Object)"The provider ID provided for the attempted web operation is invalid.");
        sparseArray.put(17071, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_WEB_CONTEXT_ALREADY_PRESENTED", (Object)"A headful operation is already in progress. Please wait for that to finish.");
        sparseArray.put(17057, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_WEB_CONTEXT_CANCELED", (Object)"The web operation was canceled by the user.");
        sparseArray.put(17058, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_TENANT_ID_MISMATCH", (Object)"The provided tenant ID does not match the Auth instance's tenant ID.");
        sparseArray.put(17072, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_UNSUPPORTED_TENANT_OPERATION", (Object)"This operation is not supported in a multi-tenant context.");
        sparseArray.put(17073, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_DYNAMIC_LINK_DOMAIN", (Object)"The provided dynamic link domain is not configured or authorized for the current project.");
        sparseArray.put(17074, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_REJECTED_CREDENTIAL", (Object)"The request contains malformed or mismatching credentials");
        sparseArray.put(17075, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_PHONE_NUMBER_NOT_FOUND", (Object)"The provided phone number does not match any of the second factor phone numbers associated with this user.");
        sparseArray.put(17077, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_TENANT_ID", (Object)"The Auth instance's tenant ID is invalid.");
        sparseArray.put(17079, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_SECOND_FACTOR_REQUIRED", (Object)"Please complete a second factor challenge to finish signing into this account.");
        sparseArray.put(17078, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_API_NOT_AVAILABLE", (Object)"The API that you are calling is not available.");
        sparseArray.put(17080, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MISSING_MULTI_FACTOR_SESSION", (Object)"The request is missing proof of first factor successful sign-in.");
        sparseArray.put(17081, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MISSING_MULTI_FACTOR_INFO", (Object)"No second factor identifier is provided.");
        sparseArray.put(17082, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INVALID_MULTI_FACTOR_SESSION", (Object)"The request does not contain a valid proof of first factor successful sign-in.");
        sparseArray.put(17083, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MULTI_FACTOR_INFO_NOT_FOUND", (Object)"The user does not have a second factor matching the identifier provided.");
        sparseArray.put(17084, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_ADMIN_RESTRICTED_OPERATION", (Object)"This operation is restricted to administrators only.");
        sparseArray.put(17085, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_UNVERIFIED_EMAIL", (Object)"This operation requires a verified email.");
        sparseArray.put(17086, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_SECOND_FACTOR_ALREADY_ENROLLED", (Object)"The second factor is already enrolled on this account.");
        sparseArray.put(17087, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MAXIMUM_SECOND_FACTOR_COUNT_EXCEEDED", (Object)"The maximum allowed number of second factors on a user has been exceeded.");
        sparseArray.put(17088, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_UNSUPPORTED_FIRST_FACTOR", (Object)"Enrolling a second factor or signing in with a multi-factor account requires sign-in with a supported first factor.");
        sparseArray.put(17089, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_EMAIL_CHANGE_NEEDS_VERIFICATION", (Object)"Multi-factor users must always have a verified email.");
        sparseArray.put(17090, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_INTERNAL_SUCCESS_SIGN_OUT", (Object)"This is an internal error code indicating that the operation was successful but the user needs to be signed out.");
        sparseArray.put(17091, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MISSING_CLIENT_IDENTIFIER", (Object)"This request is missing a valid app identifier, meaning that neither SafetyNet checks nor reCAPTCHA checks succeeded. Please try again, or check the logcat for more details.");
        sparseArray.put(17093, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_MISSING_OR_INVALID_NONCE", (Object)"The request does not contain a valid nonce. This can occur if the SHA-256 hash of the provided raw nonce does not match the hashed nonce in the ID token payload.");
        sparseArray.put(17094, (Object)pair);
        sparseArray = zza;
        pair = new Pair((Object)"ERROR_USER_CANCELLED", (Object)"The user did not grant your application the permissions it requested.");
        sparseArray.put(18001, (Object)pair);
    }
}

