/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.firebase-auth-api.zzaf;
import com.google.android.gms.internal.firebase-auth-api.zzh;
import com.google.android.gms.internal.firebase-auth-api.zzq;
import com.google.android.gms.internal.firebase-auth-api.zztl;
import com.google.android.gms.internal.firebase-auth-api.zzvi;
import com.google.android.gms.internal.firebase-auth-api.zzvj;
import com.google.android.gms.internal.firebase-auth-api.zzvl;
import com.google.android.gms.internal.firebase-auth-api.zzvm;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.firebase.auth.PhoneAuthCredential;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzvn {
    private static final Logger zza;
    private final Context zzb;
    private final ScheduledExecutorService zzc;
    private final HashMap<String, zzvm> zzd;

    static /* synthetic */ Logger zza() {
        return zza;
    }

    @VisibleForTesting
    static String zzb(String object) {
        object = Pattern.compile("(?<!\\d)\\d{6}(?!\\d)").matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String zzc() {
        try {
            void var0_2;
            String string;
            String string2 = this.zzb.getPackageName();
            int n = Build.VERSION.SDK_INT;
            if (n < 28) {
                Signature[] signatureArray = Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string2, (int)64).signatures;
            } else {
                Signature[] signatureArray = Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string2, (int)0x8000000).signingInfo.getApkContentsSigners();
            }
            if ((string = zzvn.zzm(string2, var0_2[0].toCharsString())) != null) {
                return string;
            }
            zza.e("Hash generation failed.", new Object[0]);
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zza.e("Unable to find package to obtain hash.", new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String zzm(String string, String string2) {
        MessageDigest messageDigest;
        String string3 = String.valueOf(string);
        int n = string3.length();
        String string4 = String.valueOf(string2);
        int n2 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n + 1 + n2);
        stringBuilder.append(string);
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string2.getBytes(zzq.zzc));
            string2 = Base64.encodeToString((byte[])Arrays.copyOf(messageDigest.digest(), 9), (int)3).substring(0, 11);
            messageDigest = zza;
            n2 = String.valueOf(string).length();
            n2 += 19;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string2 = zza;
            String string5 = String.valueOf(noSuchAlgorithmException.getMessage());
            String string6 = "NoSuchAlgorithm: ";
            string5 = string5.length() != 0 ? string6.concat(string5) : new String(string6);
            string2.e(string5, new Object[0]);
            return null;
        }
        {
            int n3 = String.valueOf(string2).length();
            StringBuilder stringBuilder2 = new StringBuilder(n2 += n3);
            stringBuilder2.append("Package: ");
            stringBuilder2.append(string);
            stringBuilder2.append(" -- Hash: ");
            stringBuilder2.append(string2);
            messageDigest.d(stringBuilder2.toString(), new Object[0]);
            return string2;
        }
    }

    static /* synthetic */ HashMap zzd(zzvn zzvn2) {
        return zzvn2.zzd;
    }

    static {
        Logger logger;
        String[] stringArray = new String[]{"SmsRetrieverHelper"};
        zza = logger = new Logger("FirebaseAuth", stringArray);
    }

    zzvn(@NonNull Context context) {
        HashMap hashMap = new HashMap();
        this.zzd = hashMap;
        this.zzb = (Context)Preconditions.checkNotNull((Object)context);
        zzh.zza();
        this.zzc = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
    }

    static /* synthetic */ void zze(zzvn object, String object2) {
        object = ((zzvn)object).zzd.get(object2);
        if (object == null || zzaf.zzd(((zzvm)object).zzd) || zzaf.zzd(((zzvm)object).zze) || ((zzvm)object).zzb.isEmpty()) {
            return;
        }
        object2 = ((zzvm)object).zzb.iterator();
        while (object2.hasNext()) {
            ((zztl)object2.next()).zzo(PhoneAuthCredential.zzc(((zzvm)object).zzd, ((zzvm)object).zze));
        }
        ((zzvm)object).zzh = true;
    }

    static /* synthetic */ void zzf(zzvn zzvn2, String string) {
        zzvn2.zzo(string);
    }

    static /* synthetic */ void zzg(zzvn zzvn2, String string) {
        zzvn2.zzn(string);
    }

    public final /* synthetic */ void zzh(String string) {
        this.zzo(string);
    }

    private final void zzn(String object) {
        zzvm zzvm2 = ((zzvn)((Object)zzvm2)).zzd.get(object);
        if (zzvm2 == null) {
            return;
        }
        if (!zzvm2.zzh && !zzaf.zzd(zzvm2.zzd)) {
            zza.w("Timed out waiting for SMS.", new Object[0]);
            object = zzvm2.zzb.iterator();
            while (object.hasNext()) {
                ((zztl)object.next()).zza(zzvm2.zzd);
            }
            zzvm2.zzi = true;
            return;
        }
    }

    private final void zzo(String string) {
        zzvm zzvm2 = this.zzd.get(string);
        if (zzvm2 == null) {
            return;
        }
        if (!zzvm2.zzi) {
            this.zzn(string);
        }
        this.zzj(string);
    }

    final void zzi(zztl zztl2, String string) {
        zzvm zzvm2 = ((zzvn)((Object)zzvm2)).zzd.get(string);
        if (zzvm2 == null) {
            return;
        }
        zzvm2.zzb.add(zztl2);
        if (zzvm2.zzg) {
            zztl2.zzb(zzvm2.zzd);
        }
        if (zzvm2.zzh) {
            zztl2.zzo(PhoneAuthCredential.zzc(zzvm2.zzd, zzvm2.zze));
        }
        if (zzvm2.zzi) {
            zztl2.zza(zzvm2.zzd);
            return;
        }
    }

    final void zzj(String string) {
        zzvm zzvm2 = this.zzd.get(string);
        if (zzvm2 == null) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = zzvm2.zzf;
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            zzvm2.zzf.cancel(false);
        }
        zzvm2.zzb.clear();
        this.zzd.remove(string);
    }

    final void zzk(String string, zztl object, long l, boolean bl) {
        Object object2 = this.zzd;
        zzvm zzvm2 = new zzvm(l, bl);
        ((HashMap)object2).put((String)string, (zzvm)zzvm2);
        this.zzi((zztl)object, string);
        object = this.zzd.get(string);
        if (((zzvm)object).zza <= 0L) {
            zza.w("Timeout of 0 specified; SmsRetriever will not start.", new Object[0]);
            return;
        }
        ScheduledExecutorService scheduledExecutorService = this.zzc;
        object2 = new zzvi(this, string);
        ((zzvm)object).zzf = scheduledExecutorService.schedule((Runnable)object2, ((zzvm)object).zza, TimeUnit.SECONDS);
        if (!((zzvm)object).zzc) {
            zza.w("SMS auto-retrieval unavailable; SmsRetriever will not start.", new Object[0]);
            return;
        }
        object = new zzvl(this, string);
        string = new IntentFilter();
        string.addAction("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
        this.zzb.getApplicationContext().registerReceiver((BroadcastReceiver)object, (IntentFilter)string);
        string = this.zzb;
        string = SmsRetriever.getClient((Context)string);
        string = string.startSmsRetriever();
        object = new zzvj(this);
        string.addOnFailureListener((OnFailureListener)object);
    }

    final boolean zzl(String string) {
        return this.zzd.get(string) != null;
    }
}

