/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzmj;
import com.google.android.gms.internal.firebase-auth-api.zzmr;
import com.google.android.gms.internal.firebase-auth-api.zzmt;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class zzmp {
    private final ECPrivateKey zza;

    public zzmp(ECPrivateKey eCPrivateKey) {
        this.zza = eCPrivateKey;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] zza(byte[] object, String object2, byte[] byArray, byte[] byArray2, int n, int n2) throws GeneralSecurityException {
        Object object3;
        block22: {
            int n3;
            int n4;
            Object object4;
            ECParameterSpec eCParameterSpec;
            block23: {
                BigInteger bigInteger;
                int n5;
                EllipticCurve ellipticCurve;
                block24: {
                    eCParameterSpec = ((zzmp)object3).zza.getParams();
                    ellipticCurve = eCParameterSpec.getCurve();
                    n5 = zzmr.zza(ellipticCurve);
                    switch (n2 + -1) {
                        default: {
                            Object object5 = zzmr.zzb(ellipticCurve);
                            int n6 = ((byte[])object).length;
                            if (n6 != n5 + 1) {
                                object3 = new GeneralSecurityException("compressed point has wrong length");
                                throw object3;
                            }
                            n5 = object[0];
                            if (n5 == 2) {
                                n5 = 0;
                            } else {
                                if (n5 != 3) break;
                                n5 = 1;
                            }
                            if ((bigInteger = new BigInteger(1, Arrays.copyOfRange(object, 1, n6))).signum() == -1 || bigInteger.compareTo((BigInteger)object5) >= 0) {
                                object3 = new GeneralSecurityException("x is out of range");
                                throw object3;
                            }
                            object4 = zzmr.zzc(bigInteger, n5 != 0, ellipticCurve);
                            object4 = object5 = new ECPoint(bigInteger, (BigInteger)object4);
                            break block23;
                        }
                        case 2: {
                            n2 = ((byte[])object).length;
                            if (n2 != n5 + n5) {
                                object3 = new GeneralSecurityException("invalid point size");
                                throw object3;
                            }
                            BigInteger bigInteger2 = new BigInteger(1, Arrays.copyOfRange(object, 0, n5));
                            bigInteger = new BigInteger(1, Arrays.copyOfRange(object, n5, n2));
                            object4 = new ECPoint(bigInteger2, bigInteger);
                            zzmr.zzd((ECPoint)object4, ellipticCurve);
                            break block23;
                        }
                        case 0: {
                            n2 = ((byte[])object).length;
                            if (n2 != n5 + n5 + 1) {
                                object3 = new GeneralSecurityException("invalid point size");
                                throw object3;
                            }
                            if (object[0] != 4) {
                                object3 = new GeneralSecurityException("invalid point format");
                                throw object3;
                            }
                            break block24;
                        }
                    }
                    object3 = new GeneralSecurityException("invalid format");
                    throw object3;
                }
                BigInteger bigInteger3 = new BigInteger(1, Arrays.copyOfRange(object, 1, ++n5));
                bigInteger = new BigInteger(1, Arrays.copyOfRange(object, n5, n2));
                object4 = new ECPoint(bigInteger3, bigInteger);
                zzmr.zzd((ECPoint)object4, ellipticCurve);
            }
            Object object6 = new ECPublicKeySpec((ECPoint)object4, eCParameterSpec);
            object4 = (ECPublicKey)((KeyFactory)zzmt.zzg.zza("EC")).generatePublic((KeySpec)object6);
            object3 = ((zzmp)object3).zza;
            object6 = object4.getParams();
            eCParameterSpec = object3.getParams();
            boolean bl = ((ECParameterSpec)object6).getCurve().equals(eCParameterSpec.getCurve());
            if (!bl || !(bl = ((ECParameterSpec)object6).getGenerator().equals(eCParameterSpec.getGenerator())) || !(bl = ((ECParameterSpec)object6).getOrder().equals(eCParameterSpec.getOrder())) || (n4 = ((ECParameterSpec)object6).getCofactor()) != (n3 = eCParameterSpec.getCofactor())) break block22;
            object4 = object4.getW();
            zzmr.zzd((ECPoint)object4, object3.getParams().getCurve());
            Object object7 = object3.getParams();
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec((ECPoint)object4, (ECParameterSpec)object7);
            object4 = ((KeyFactory)zzmt.zzg.zza("EC")).generatePublic(eCPublicKeySpec);
            object7 = (KeyAgreement)zzmt.zze.zza("ECDH");
            ((KeyAgreement)object7).init((Key)object3);
            ((KeyAgreement)object7).doPhase((Key)object4, true);
            object4 = ((KeyAgreement)object7).generateSecret();
            object3 = object3.getParams().getCurve();
            object7 = new BigInteger(1, (byte[])object4);
            int n7 = ((BigInteger)object7).signum();
            if (n7 == -1 || (n7 = ((BigInteger)object7).compareTo(zzmr.zzb((EllipticCurve)object3))) >= 0) {
                object3 = new GeneralSecurityException("shared secret is out of range");
                throw object3;
            }
            zzmr.zzc((BigInteger)object7, true, (EllipticCurve)object3);
            object3 = new byte[2][];
            object3[0] = object;
            object3[1] = object4;
            object3 = zzmj.zzc((byte[][])object3);
            object4 = (Mac)zzmt.zzb.zza((String)object2);
            if (n > ((Mac)object4).getMacLength() * 255) {
                object3 = new GeneralSecurityException("size too large");
                throw object3;
            }
            if (byArray == null || byArray.length == 0) {
                object = new SecretKeySpec;
                object(new byte[((Mac)object4).getMacLength()], (String)object2);
                ((Mac)object4).init((Key)object);
            } else {
                object = new SecretKeySpec;
                object(byArray, (String)object2);
                ((Mac)object4).init((Key)object);
            }
            object3 = ((Mac)object4).doFinal((byte[])object3);
            byArray = new byte[n];
            object = new SecretKeySpec;
            object((byte[])object3, (String)object2);
            ((Mac)object4).init((Key)object);
            object2 = new byte[0];
            int n8 = 1;
            int n9 = 0;
            while (true) {
                ((Mac)object4).update((byte[])object2);
                ((Mac)object4).update((byte[])null);
                ((Mac)object4).update((byte)n8);
                object2 = ((Mac)object4).doFinal();
                int n10 = ((Object)object2).length;
                n7 = n9 + n10;
                if (n7 >= n) {
                    System.arraycopy(object2, 0, byArray, n9, n - n9);
                    return byArray;
                }
                System.arraycopy(object2, 0, byArray, n9, n10);
                ++n8;
                n9 = n7;
            }
        }
        try {
            object3 = new GeneralSecurityException("invalid public key spec");
            throw object3;
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            object = new GeneralSecurityException;
            object(runtimeException);
            throw object;
        }
        catch (IllegalStateException illegalStateException) {
            object = new GeneralSecurityException;
            object(illegalStateException);
            throw object;
        }
    }
}

