/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.firebase-auth-api.zzag;
import com.google.android.gms.internal.firebase-auth-api.zzb;
import com.google.android.gms.internal.firebase-auth-api.zzf;
import com.google.android.gms.internal.firebase-auth-api.zzo;
import com.google.android.gms.internal.firebase-auth-api.zzts;
import com.google.android.gms.internal.firebase-auth-api.zzvi;
import com.google.android.gms.internal.firebase-auth-api.zzvj;
import com.google.android.gms.internal.firebase-auth-api.zzvl;
import com.google.android.gms.internal.firebase-auth-api.zzvm;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.firebase.auth.PhoneAuthCredential;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzvn {
    private static final Logger zza;
    private final Context zzb;
    private final ScheduledExecutorService zzc;
    private final HashMap zzd;

    static /* bridge */ /* synthetic */ Logger zza() {
        return zza;
    }

    @VisibleForTesting
    static String zzb(String object) {
        object = Pattern.compile("(?<!\\d)\\d{6}(?!\\d)").matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String zzc() {
        try {
            void var0_2;
            String string;
            String string2 = this.zzb.getPackageName();
            int n = Build.VERSION.SDK_INT;
            if (n < 28) {
                Signature[] signatureArray = Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string2, (int)64).signatures;
            } else {
                Signature[] signatureArray = Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string2, (int)0x8000000).signingInfo.getApkContentsSigners();
            }
            if ((string = zzvn.zzm(string2, var0_2[0].toCharsString())) != null) {
                return string;
            }
            zza.e("Hash generation failed.", new Object[0]);
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zza.e("Unable to find package to obtain hash.", new Object[0]);
            return null;
        }
    }

    private static String zzm(String string, String string2) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append(string);
        ((StringBuilder)object).append(" ");
        ((StringBuilder)object).append(string2);
        string2 = ((StringBuilder)object).toString();
        try {
            object = MessageDigest.getInstance("SHA-256");
            ((MessageDigest)object).update(string2.getBytes(zzo.zzc));
            string2 = Base64.encodeToString((byte[])Arrays.copyOf(((MessageDigest)object).digest(), 9), (int)3).substring(0, 11);
            object = zza;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Package: ");
            stringBuilder.append(string);
            stringBuilder.append(" -- Hash: ");
            stringBuilder.append(string2);
            object.d(stringBuilder.toString(), new Object[0]);
            return string2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            zza.e("NoSuchAlgorithm: ".concat(String.valueOf(noSuchAlgorithmException.getMessage())), new Object[0]);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ HashMap zzd(zzvn zzvn2) {
        return zzvn2.zzd;
    }

    static /* bridge */ /* synthetic */ void zze(zzvn object, String object2) {
        object = (zzvm)((zzvn)object).zzd.get(object2);
        if (object == null || zzag.zzd(((zzvm)object).zzd) || zzag.zzd(((zzvm)object).zze) || ((zzvm)object).zzb.isEmpty()) {
            return;
        }
        object2 = ((zzvm)object).zzb.iterator();
        while (object2.hasNext()) {
            ((zzts)object2.next()).zzo(PhoneAuthCredential.zzc(((zzvm)object).zzd, ((zzvm)object).zze));
        }
        ((zzvm)object).zzh = true;
    }

    static /* bridge */ /* synthetic */ void zzf(zzvn zzvn2, String string) {
        zzvn2.zzn(string);
    }

    static /* bridge */ /* synthetic */ void zzg(zzvn zzvn2, String string) {
        zzvn2.zzo(string);
    }

    static {
        Logger logger;
        String[] stringArray = new String[]{"SmsRetrieverHelper"};
        zza = logger = new Logger("FirebaseAuth", stringArray);
    }

    zzvn(@NonNull Context context) {
        HashMap hashMap;
        this.zzd = hashMap = new HashMap();
        this.zzb = (Context)Preconditions.checkNotNull((Object)context);
        zzf.zza();
        this.zzc = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
    }

    final /* synthetic */ void zzh(String string) {
        this.zzo(string);
    }

    private final void zzn(String object) {
        zzvm zzvm2 = (zzvm)((zzvn)((Object)zzvm2)).zzd.get(object);
        if (zzvm2 == null) {
            return;
        }
        if (!zzvm2.zzh && !zzag.zzd(zzvm2.zzd)) {
            zza.w("Timed out waiting for SMS.", new Object[0]);
            object = zzvm2.zzb.iterator();
            while (object.hasNext()) {
                ((zzts)object.next()).zza(zzvm2.zzd);
            }
            zzvm2.zzi = true;
            return;
        }
    }

    private final void zzo(String string) {
        zzvm zzvm2 = (zzvm)this.zzd.get(string);
        if (zzvm2 == null) {
            return;
        }
        if (!zzvm2.zzi) {
            this.zzn(string);
        }
        this.zzj(string);
    }

    final void zzi(zzts zzts2, String string) {
        zzvm zzvm2 = (zzvm)((zzvn)((Object)zzvm2)).zzd.get(string);
        if (zzvm2 == null) {
            return;
        }
        zzvm2.zzb.add(zzts2);
        if (zzvm2.zzg) {
            zzts2.zzb(zzvm2.zzd);
        }
        if (zzvm2.zzh) {
            zzts2.zzo(PhoneAuthCredential.zzc(zzvm2.zzd, zzvm2.zze));
        }
        if (zzvm2.zzi) {
            zzts2.zza(zzvm2.zzd);
            return;
        }
    }

    final void zzj(String string) {
        zzvm zzvm2 = (zzvm)this.zzd.get(string);
        if (zzvm2 == null) {
            return;
        }
        ScheduledFuture scheduledFuture = zzvm2.zzf;
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            zzvm2.zzf.cancel(false);
        }
        zzvm2.zzb.clear();
        this.zzd.remove(string);
    }

    final void zzk(String string, zzts object, long l, boolean bl) {
        Object object2 = this.zzd;
        zzvm zzvm2 = new zzvm(l, bl);
        ((HashMap)object2).put(string, zzvm2);
        this.zzi((zzts)object, string);
        object = (zzvm)this.zzd.get(string);
        long l2 = ((zzvm)object).zza;
        if (l2 <= 0L) {
            zza.w("Timeout of 0 specified; SmsRetriever will not start.", new Object[0]);
            return;
        }
        ScheduledExecutorService scheduledExecutorService = this.zzc;
        object2 = new zzvi(this, string);
        ((zzvm)object).zzf = scheduledExecutorService.schedule((Runnable)object2, l2, TimeUnit.SECONDS);
        if (!((zzvm)object).zzc) {
            zza.w("SMS auto-retrieval unavailable; SmsRetriever will not start.", new Object[0]);
            return;
        }
        object = new zzvl(this, string);
        string = new IntentFilter();
        string.addAction("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
        com.google.android.gms.internal.firebase-auth-api.zzb.zza(this.zzb.getApplicationContext(), (BroadcastReceiver)object, (IntentFilter)string);
        string = this.zzb;
        string = SmsRetriever.getClient((Context)string);
        string = string.startSmsRetriever();
        object = new zzvj(this);
        string.addOnFailureListener((OnFailureListener)object);
    }

    final boolean zzl(String string) {
        return this.zzd.get(string) != null;
    }
}

