/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.internal.firebase-auth-api.zzf;
import com.google.android.gms.internal.firebase-auth-api.zztw;
import com.google.android.gms.internal.firebase-auth-api.zztx;
import com.google.android.gms.internal.firebase-auth-api.zzty;
import com.google.android.gms.internal.firebase-auth-api.zzvr;
import com.google.android.gms.internal.firebase-auth-api.zzxq;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.internal.zzai;
import com.google.firebase.auth.internal.zzbl;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzi;
import com.google.firebase.auth.internal.zzj;
import com.google.firebase.auth.internal.zzk;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

@KeepName
public class GenericIdpActivity
extends FragmentActivity
implements zzty {
    private static long zzb = 0L;
    private static final zzbm zzc = zzbm.zzc();
    private final Executor zzd = zzf.zza().zza(1);
    private boolean zze = false;

    protected final void onCreate(@NonNull Bundle bundle) {
        super.onCreate(bundle);
        String string = this.getIntent().getAction();
        if ("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN".equals(string) || "com.google.firebase.auth.internal.NONGMSCORE_LINK".equals(string) || "com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE".equals(string) || "android.intent.action.VIEW".equals(string)) {
            long l = DefaultClock.getInstance().currentTimeMillis();
            if (l - zzb < 30000L) {
                Log.e((String)"GenericIdpActivity", (String)"Could not start operation - already in progress");
                return;
            }
            zzb = l;
            if (bundle != null) {
                this.zze = bundle.getBoolean("com.google.firebase.auth.internal.KEY_STARTED_SIGN_IN");
                return;
            }
            return;
        }
        Log.e((String)"GenericIdpActivity", (String)"Could not do operation - unknown action: ".concat(String.valueOf(string)));
        this.zzh();
    }

    public final void onNewIntent(@NonNull Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void onResume() {
        block12: {
            String string;
            super.onResume();
            if ("android.intent.action.VIEW".equals(this.getIntent().getAction())) {
                Intent intent = this.getIntent();
                if (intent.hasExtra("firebaseError")) {
                    this.zzi(zzbl.zzb(intent.getStringExtra("firebaseError")));
                    return;
                }
                if (intent.hasExtra("link") && intent.hasExtra("eventId")) {
                    Object object = intent.getStringExtra("link");
                    Object object2 = intent.getStringExtra("eventId");
                    String string2 = this.getPackageName();
                    boolean bl = intent.getBooleanExtra("encryptionEnabled", true);
                    object2 = zzj.zzb().zza((Context)this, string2, (String)object2);
                    if (object2 == null) {
                        this.zzh();
                    }
                    Object object3 = bl ? zzk.zza(this.getApplicationContext(), FirebaseApp.getInstance((String)((zzi)object2).zza()).getPersistenceKey()).zzb((String)object) : object;
                    object = new zzxq((zzi)object2, (String)object3);
                    object3 = ((zzi)object2).zze();
                    object2 = ((zzi)object2).zzb();
                    ((zzxq)object).zzf((String)object3);
                    if (!("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN".equals(object2) || "com.google.firebase.auth.internal.NONGMSCORE_LINK".equals(object2) || "com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE".equals(object2))) {
                        Log.e((String)"GenericIdpActivity", (String)"unsupported operation: ".concat((String)object2));
                        this.zzh();
                        return;
                    }
                    zzb = 0L;
                    this.zze = false;
                    string2 = new Intent();
                    SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)object, (Intent)string2, (String)"com.google.firebase.auth.internal.VERIFY_ASSERTION_REQUEST");
                    string2.putExtra("com.google.firebase.auth.internal.OPERATION", (String)object2);
                    string2.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
                    if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast((Intent)string2)) {
                        string2 = this.getApplicationContext().getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
                        string2.putString("verifyAssertionRequest", SafeParcelableSerializer.serializeToString((SafeParcelable)object));
                        string2.putString("operation", (String)object2);
                        string2.putString("tenantId", (String)object3);
                        string2.putLong("timestamp", DefaultClock.getInstance().currentTimeMillis());
                        string2.commit();
                    } else {
                        zzc.zzd((Context)this);
                    }
                    this.finish();
                    return;
                }
                this.zzh();
                return;
            }
            if (this.zze) {
                this.zzh();
                return;
            }
            String string3 = this.getPackageName();
            try {
                string = Hex.bytesToStringUppercase((byte[])AndroidUtilsLight.getPackageCertificateHashBytes((Context)this, (String)string3)).toLowerCase(Locale.US);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                String string4 = ((Object)((Object)nameNotFoundException)).toString();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Could not get package signature: ");
                stringBuilder.append(string3);
                stringBuilder.append(" ");
                stringBuilder.append(string4);
                Log.e((String)"GenericIdpActivity", (String)stringBuilder.toString());
                this.zze(string3, null);
                break block12;
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)this.getIntent().getStringExtra("com.google.firebase.auth.KEY_FIREBASE_APP_NAME"));
            if (!zzvr.zzg(firebaseApp)) {
                zztw zztw2 = new zztw(string3, string, this.getIntent(), firebaseApp, this);
                zztw2.executeOnExecutor(this.zzd, new Void[0]);
            } else {
                this.zzf(this.zzg(Uri.parse((String)zzvr.zza(firebaseApp.getOptions().getApiKey())).buildUpon(), this.getIntent(), string3, string).build(), string3);
            }
        }
        this.zze = true;
    }

    protected final void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("com.google.firebase.auth.internal.KEY_STARTED_SIGN_IN", this.zze);
    }

    @Override
    @NonNull
    public final Context zza() {
        return this.getApplicationContext();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Uri.Builder zzg(@NonNull Uri.Builder builder, @NonNull Intent object, @NonNull String string, @NonNull String string2) {
        void var6_13;
        void var4_5;
        void var3_4;
        Object object2;
        String string3 = object.getStringExtra("com.google.firebase.auth.KEY_API_KEY");
        String string4 = object.getStringExtra("com.google.firebase.auth.KEY_PROVIDER_ID");
        String string5 = object.getStringExtra("com.google.firebase.auth.KEY_TENANT_ID");
        String string6 = object.getStringExtra("com.google.firebase.auth.KEY_FIREBASE_APP_NAME");
        Object object3 = object.getStringArrayListExtra("com.google.firebase.auth.KEY_PROVIDER_SCOPES");
        object3 = object3 != null ? (!((ArrayList)object3).isEmpty() ? TextUtils.join((CharSequence)",", (Iterable)object3) : null) : null;
        Bundle bundle = object.getBundleExtra("com.google.firebase.auth.KEY_PROVIDER_CUSTOM_PARAMS");
        if (bundle == null) {
            Object var6_12 = null;
        } else {
            JSONObject jSONObject = new JSONObject();
            try {
                boolean bl;
                object2 = bundle.keySet().iterator();
                while (bl = object2.hasNext()) {
                    String string7 = (String)object2.next();
                    String string8 = bundle.getString(string7);
                    boolean bl2 = TextUtils.isEmpty((CharSequence)string8);
                    if (bl2) continue;
                    jSONObject.put(string7, (Object)string8);
                }
            }
            catch (JSONException jSONException) {
                Log.e((String)"GenericIdpActivity", (String)"Unexpected JSON exception when serializing developer specified custom params");
            }
            String string9 = jSONObject.toString();
        }
        String string10 = UUID.randomUUID().toString();
        object2 = zztx.zza(this, UUID.randomUUID().toString());
        String string11 = object.getAction();
        String string12 = object.getStringExtra("com.google.firebase.auth.internal.CLIENT_VERSION");
        zzj.zzb().zzd(this.getApplicationContext(), (String)var3_4, string10, (String)object2, string11, string4, string5, string6);
        string6 = FirebaseApp.getInstance((String)string6);
        string6 = zzk.zza(this.getApplicationContext(), string6.getPersistenceKey()).zzc();
        if (TextUtils.isEmpty((CharSequence)string6)) {
            Log.e((String)"GenericIdpActivity", (String)"Could not generate an encryption key for Generic IDP - cancelling flow.");
            this.zzi(zzai.zza("Failed to generate/retrieve public encryption key for Generic IDP flow."));
            return null;
        }
        if (object2 == null) {
            return null;
        }
        builder.appendQueryParameter("eid", "p").appendQueryParameter("v", "X".concat(String.valueOf(string12))).appendQueryParameter("authType", "signInWithRedirect").appendQueryParameter("apiKey", string3).appendQueryParameter("providerId", string4).appendQueryParameter("sessionId", (String)object2).appendQueryParameter("eventId", string10).appendQueryParameter("apn", (String)var3_4).appendQueryParameter("sha1Cert", (String)var4_5).appendQueryParameter("publicKey", string6);
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            builder.appendQueryParameter("scopes", (String)object3);
        }
        if (!TextUtils.isEmpty((CharSequence)var6_13)) {
            builder.appendQueryParameter("customParameters", (String)var6_13);
        }
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            builder.appendQueryParameter("tid", string5);
        }
        return builder;
    }

    @Override
    @Nullable
    public final Uri.Builder zzb(@NonNull Intent intent, @NonNull String string, @NonNull String string2) {
        Uri.Builder builder = new Uri.Builder();
        return this.zzg(builder.scheme("https").appendPath("__").appendPath("auth").appendPath("handler"), intent, string, string2);
    }

    @Override
    @NonNull
    public final String zzc(@NonNull String string) {
        return zzvr.zzb(string);
    }

    @Override
    @Nullable
    public final HttpURLConnection zzd(@NonNull URL uRL) {
        try {
            Object object = uRL.openConnection();
            object = (HttpURLConnection)object;
            return object;
        }
        catch (IOException iOException) {
            Log.e((String)"GenericIdpActivity", (String)"Error generating URL connection");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzh() {
        zzb = 0L;
        this.zze = false;
        Intent intent = new Intent();
        intent.putExtra("com.google.firebase.auth.internal.EXTRA_CANCELED", true);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent)) {
            zzc.zzf((Context)this, zzai.zza("WEB_CONTEXT_CANCELED"));
        } else {
            zzc.zzd((Context)this);
        }
        this.finish();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzi(Status status) {
        zzb = 0L;
        this.zze = false;
        Intent intent = new Intent();
        zzbl.zzc(intent, status);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        if (!LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent)) {
            zzc.zzf(this.getApplicationContext(), status);
        } else {
            zzc.zzd((Context)this);
        }
        this.finish();
    }

    @Override
    public final void zze(@NonNull String string, @Nullable Status status) {
        if (status == null) {
            this.zzh();
            return;
        }
        this.zzi(status);
    }

    @Override
    public final void zzf(@NonNull Uri uri, @NonNull String string) {
        Object object = new Intent("android.intent.action.VIEW");
        if (this.getPackageManager().resolveActivity((Intent)object, 0) != null) {
            object = this.getPackageManager();
            Intent intent = new Intent("android.support.customtabs.action.CustomTabsService");
            if ((object = object.queryIntentServices(intent, 0)) != null && !object.isEmpty()) {
                string = new CustomTabsIntent.Builder();
                string = string.build();
                ((CustomTabsIntent)string).intent.addFlags(0x40000000);
                ((CustomTabsIntent)string).intent.addFlags(0x10000000);
                string.launchUrl((Context)this, uri);
                return;
            }
            object = new Intent("android.intent.action.VIEW", uri);
            object.putExtra("com.android.browser.application_id", string);
            object.addFlags(0x40000000);
            object.addFlags(0x10000000);
            this.startActivity((Intent)object);
            return;
        }
        Log.e((String)"GenericIdpActivity", (String)"Device cannot resolve intent for: android.intent.action.VIEW");
        this.zze(string, null);
    }
}

