/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzdn;
import com.google.android.gms.internal.firebase-auth-api.zzds;
import com.google.android.gms.internal.firebase-auth-api.zzdv;
import com.google.android.gms.internal.firebase-auth-api.zzpp;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import javax.crypto.AEADBadTagException;

abstract class zzdp {
    private final zzdn zza;
    private final zzdn zzb;

    abstract zzdn zza(byte[] var1, int var2) throws InvalidKeyException;

    public zzdp(byte[] byArray) throws GeneralSecurityException {
        if (!zzdv.zza(1)) {
            Object object = new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
            throw object;
        }
        ((zzdp)object).zza = ((zzdp)object).zza(byArray, 1);
        ((zzdp)object).zzb = ((zzdp)object).zza(byArray, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] zzb(ByteBuffer object, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        Object object2;
        if (((Buffer)object).remaining() < 16) {
            object2 = new GeneralSecurityException("ciphertext too short");
            throw object2;
        }
        int n = ((Buffer)object).position();
        byte[] byArray3 = new byte[16];
        ((ByteBuffer)object).position(((Buffer)object).limit() + -16);
        ((ByteBuffer)object).get(byArray3);
        ((ByteBuffer)object).position(n);
        ((ByteBuffer)object).limit(((Buffer)object).limit() + -16);
        try {
            Object object3 = ((zzdp)object2).zzb;
            object3 = ((zzdn)object3).zzc(byArray, 0);
            byte[] byArray4 = new byte[32];
            ((ByteBuffer)object3).get(byArray4);
            int n2 = ((Buffer)object).remaining();
            int n3 = n2 % 16;
            n3 = n3 == 0 ? n2 : n2 + 16 - n3;
            ByteBuffer byteBuffer = ByteBuffer.allocate(n3 + 16).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put(byArray2);
            byteBuffer.position(0);
            byteBuffer.put((ByteBuffer)object);
            byteBuffer.position(n3);
            byteBuffer.putLong(0L);
            byteBuffer.putLong(n2);
            byArray2 = byteBuffer.array();
            boolean bl = zzpp.zzb(zzds.zza(byArray4, byArray2), byArray3);
            if (!bl) {
                object2 = new GeneralSecurityException("invalid MAC");
                throw object2;
            }
            ((ByteBuffer)object).position(n);
            return ((zzdp)object2).zza.zzd(byArray, (ByteBuffer)object);
        }
        catch (GeneralSecurityException generalSecurityException) {
            object = new AEADBadTagException(generalSecurityException.toString());
            throw object;
        }
    }

    public final byte[] zzc(byte[] byArray, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        return this.zzb(ByteBuffer.wrap(byArray2), byArray, byArray3);
    }
}

