/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.google.android.gms.internal.firebase-auth-api.zzap;
import com.google.android.gms.internal.firebase-auth-api.zzbk;
import com.google.android.gms.internal.firebase-auth-api.zzfo;
import com.google.android.gms.internal.firebase-auth-api.zzqq;
import com.google.android.gms.internal.firebase-auth-api.zzqs;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.concurrent.GuardedBy;

public final class zzfp
implements zzbk {
    private static final String zza = zzfp.class.getSimpleName();
    @GuardedBy(value="this")
    private KeyStore zzb;

    @Override
    public final synchronized zzap zza(String object) throws GeneralSecurityException {
        zzfo zzfo2 = new zzfo(zzqs.zza("android-keystore://", (String)object), ((zzfp)object2).zzb);
        Object object2 = zzqq.zza(10);
        if (!Arrays.equals((byte[])object2, zzfo2.zza(zzfo2.zzb((byte[])object2, (byte[])(object = (Object)new byte[0])), (byte[])object))) {
            object2 = new KeyStoreException("cannot use Android Keystore: encryption/decryption of non-empty message and empty aad returns an incorrect result");
            throw object2;
        }
        return zzfo2;
    }

    @RequiresApi(value=23)
    public zzfp() throws GeneralSecurityException {
        Object object;
        KeyStore keyStore;
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                keyStore = KeyStore.getInstance("AndroidKeyStore");
                keyStore.load(null);
            }
            catch (IOException | GeneralSecurityException exception) {
                IllegalStateException illegalStateException = new IllegalStateException(exception);
                throw illegalStateException;
            }
        } else {
            object = new IllegalStateException("need Android Keystore on Android M or newer");
            throw object;
        }
        object = new Object();
        ((zzfp)object).zzb = keyStore;
    }

    @Override
    @RequiresApi(value=23)
    public final synchronized boolean zzb(String string) {
        return string.toLowerCase(Locale.US).startsWith("android-keystore://");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final synchronized boolean zzc(String object) throws GeneralSecurityException {
        object = zzqs.zza("android-keystore://", (String)object);
        try {
            return this.zzb.containsAlias((String)object);
        }
        catch (NullPointerException nullPointerException) {
            Log.w((String)zza, (String)"Keystore is temporarily unavailable, wait 20ms, reinitialize Keystore and try again.");
            try {
                Thread.sleep(20L);
                this.zzb = KeyStore.getInstance("AndroidKeyStore");
                this.zzb.load(null);
                return this.zzb.containsAlias((String)object);
            }
            catch (IOException iOException) {
                object = new GeneralSecurityException(iOException);
                throw object;
            }
            catch (InterruptedException interruptedException) {
                return this.zzb.containsAlias((String)object);
            }
        }
    }
}

