/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.firebase-auth-api.zzag;
import com.google.android.gms.internal.firebase-auth-api.zzb;
import com.google.android.gms.internal.firebase-auth-api.zzf;
import com.google.android.gms.internal.firebase-auth-api.zzo;
import com.google.android.gms.internal.firebase-auth-api.zzxa;
import com.google.android.gms.internal.firebase-auth-api.zzyq;
import com.google.android.gms.internal.firebase-auth-api.zzyr;
import com.google.android.gms.internal.firebase-auth-api.zzyt;
import com.google.android.gms.internal.firebase-auth-api.zzyu;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.firebase.auth.PhoneAuthCredential;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzyv {
    private static final Logger zza;
    private final Context zzb;
    private final ScheduledExecutorService zzc;
    private final HashMap zzd;

    static /* bridge */ /* synthetic */ Logger zza() {
        return zza;
    }

    @VisibleForTesting
    static String zzb(String object) {
        object = Pattern.compile("(?<!\\d)\\d{6}(?!\\d)").matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String zzc() {
        try {
            void var0_2;
            String string;
            String string2 = this.zzb.getPackageName();
            int n = Build.VERSION.SDK_INT;
            if (n < 28) {
                Signature[] signatureArray = Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string2, (int)64).signatures;
            } else {
                Signature[] signatureArray = Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string2, (int)0x8000000).signingInfo.getApkContentsSigners();
            }
            if ((string = zzyv.zzm(string2, var0_2[0].toCharsString())) != null) {
                return string;
            }
            zza.e("Hash generation failed.", new Object[0]);
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zza.e("Unable to find package to obtain hash.", new Object[0]);
            return null;
        }
    }

    private static String zzm(String string, String string2) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append(string);
        ((StringBuilder)object).append(" ");
        ((StringBuilder)object).append(string2);
        string2 = ((StringBuilder)object).toString();
        try {
            object = MessageDigest.getInstance("SHA-256");
            ((MessageDigest)object).update(string2.getBytes(zzo.zzc));
            string2 = Base64.encodeToString((byte[])Arrays.copyOf(((MessageDigest)object).digest(), 9), (int)3).substring(0, 11);
            object = zza;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Package: ");
            stringBuilder.append(string);
            stringBuilder.append(" -- Hash: ");
            stringBuilder.append(string2);
            object.d(stringBuilder.toString(), new Object[0]);
            return string2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            zza.e("NoSuchAlgorithm: ".concat(String.valueOf(noSuchAlgorithmException.getMessage())), new Object[0]);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ HashMap zzd(zzyv zzyv2) {
        return zzyv2.zzd;
    }

    static /* bridge */ /* synthetic */ void zze(zzyv object, String object2) {
        object = (zzyu)((zzyv)object).zzd.get(object2);
        if (object == null || zzag.zzd(((zzyu)object).zzd) || zzag.zzd(((zzyu)object).zze) || ((zzyu)object).zzb.isEmpty()) {
            return;
        }
        object2 = ((zzyu)object).zzb.iterator();
        while (object2.hasNext()) {
            ((zzxa)object2.next()).zzo(PhoneAuthCredential.zzc(((zzyu)object).zzd, ((zzyu)object).zze));
        }
        ((zzyu)object).zzh = true;
    }

    static /* bridge */ /* synthetic */ void zzf(zzyv zzyv2, String string) {
        zzyv2.zzn(string);
    }

    static /* bridge */ /* synthetic */ void zzg(zzyv zzyv2, String string) {
        zzyv2.zzo(string);
    }

    static {
        Logger logger;
        String[] stringArray = new String[]{"SmsRetrieverHelper"};
        zza = logger = new Logger("FirebaseAuth", stringArray);
    }

    zzyv(@NonNull Context context) {
        HashMap hashMap;
        this.zzd = hashMap = new HashMap();
        this.zzb = (Context)Preconditions.checkNotNull((Object)context);
        zzf.zza();
        this.zzc = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
    }

    final /* synthetic */ void zzh(String string) {
        this.zzo(string);
    }

    private final void zzn(String object) {
        zzyu zzyu2 = (zzyu)((zzyv)((Object)zzyu2)).zzd.get(object);
        if (zzyu2 == null) {
            return;
        }
        if (!zzyu2.zzh && !zzag.zzd(zzyu2.zzd)) {
            zza.w("Timed out waiting for SMS.", new Object[0]);
            object = zzyu2.zzb.iterator();
            while (object.hasNext()) {
                ((zzxa)object.next()).zza(zzyu2.zzd);
            }
            zzyu2.zzi = true;
            return;
        }
    }

    private final void zzo(String string) {
        zzyu zzyu2 = (zzyu)this.zzd.get(string);
        if (zzyu2 == null) {
            return;
        }
        if (!zzyu2.zzi) {
            this.zzn(string);
        }
        this.zzj(string);
    }

    final void zzi(zzxa zzxa2, String string) {
        zzyu zzyu2 = (zzyu)((zzyv)((Object)zzyu2)).zzd.get(string);
        if (zzyu2 == null) {
            return;
        }
        zzyu2.zzb.add(zzxa2);
        if (zzyu2.zzg) {
            zzxa2.zzb(zzyu2.zzd);
        }
        if (zzyu2.zzh) {
            zzxa2.zzo(PhoneAuthCredential.zzc(zzyu2.zzd, zzyu2.zze));
        }
        if (zzyu2.zzi) {
            zzxa2.zza(zzyu2.zzd);
            return;
        }
    }

    final void zzj(String string) {
        zzyu zzyu2 = (zzyu)this.zzd.get(string);
        if (zzyu2 == null) {
            return;
        }
        ScheduledFuture scheduledFuture = zzyu2.zzf;
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            zzyu2.zzf.cancel(false);
        }
        zzyu2.zzb.clear();
        this.zzd.remove(string);
    }

    final void zzk(String string, zzxa object, long l, boolean bl) {
        Object object2 = this.zzd;
        zzyu zzyu2 = new zzyu(l, bl);
        ((HashMap)object2).put(string, zzyu2);
        this.zzi((zzxa)object, string);
        object = (zzyu)this.zzd.get(string);
        long l2 = ((zzyu)object).zza;
        if (l2 <= 0L) {
            zza.w("Timeout of 0 specified; SmsRetriever will not start.", new Object[0]);
            return;
        }
        ScheduledExecutorService scheduledExecutorService = this.zzc;
        object2 = new zzyq(this, string);
        ((zzyu)object).zzf = scheduledExecutorService.schedule((Runnable)object2, l2, TimeUnit.SECONDS);
        if (!((zzyu)object).zzc) {
            zza.w("SMS auto-retrieval unavailable; SmsRetriever will not start.", new Object[0]);
            return;
        }
        object = new zzyt(this, string);
        string = new IntentFilter();
        string.addAction("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
        com.google.android.gms.internal.firebase-auth-api.zzb.zza(this.zzb.getApplicationContext(), (BroadcastReceiver)object, (IntentFilter)string);
        string = this.zzb;
        string = SmsRetriever.getClient((Context)string);
        string = string.startSmsRetriever();
        object = new zzyr(this);
        string.addOnFailureListener((OnFailureListener)object);
    }

    final boolean zzl(String string) {
        return this.zzd.get(string) != null;
    }
}

