/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase-auth-api.zzaat;
import com.google.android.gms.internal.firebase-auth-api.zzaed;
import com.google.firebase.auth.internal.zzk;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="VerifyAssertionRequestCreator")
public final class zzaec
extends AbstractSafeParcelable
implements zzaat {
    public static final Parcelable.Creator<zzaec> CREATOR = new zzaed();
    @SafeParcelable.Field(id=2, getter="getRequestUri")
    private String zza;
    @SafeParcelable.Field(id=3, getter="getCurrentIdToken")
    private String zzb;
    @SafeParcelable.Field(id=4, getter="getIdToken")
    private String zzc;
    @SafeParcelable.Field(id=5, getter="getAccessToken")
    private String zzd;
    @SafeParcelable.Field(id=6, getter="getProviderId")
    private String zze;
    @Nullable
    @SafeParcelable.Field(id=7, getter="getEmail")
    private String zzf;
    @SafeParcelable.Field(id=8, getter="getPostBody")
    private String zzg;
    @SafeParcelable.Field(id=9, getter="getOauthTokenSecret")
    private String zzh;
    @SafeParcelable.Field(id=10, getter="getReturnSecureToken")
    private boolean zzi;
    @SafeParcelable.Field(id=11, getter="getAutoCreate")
    private boolean zzj;
    @SafeParcelable.Field(id=12, getter="getAuthCode")
    private String zzk;
    @SafeParcelable.Field(id=13, getter="getSessionId")
    private String zzl;
    @SafeParcelable.Field(id=14, getter="getIdpResponseUrl")
    private String zzm;
    @SafeParcelable.Field(id=15, getter="getTenantId")
    private String zzn;
    @SafeParcelable.Field(id=16, getter="getReturnIdpCredential")
    private boolean zzo;
    @SafeParcelable.Field(id=17, getter="getPendingToken")
    @Nullable
    private String zzp;

    public final zzaec zzb(boolean bl) {
        this.zzj = false;
        return this;
    }

    public final zzaec zzc(String string) {
        this.zzb = Preconditions.checkNotEmpty((String)string);
        return this;
    }

    public final zzaec zzd(boolean bl) {
        this.zzo = true;
        return this;
    }

    public final zzaec zze(boolean bl) {
        this.zzi = true;
        return this;
    }

    public final zzaec zzf(@Nullable String string) {
        this.zzn = string;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final String zza() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("autoCreate", this.zzj);
        jSONObject.put("returnSecureToken", this.zzi);
        String string = this.zzb;
        if (string != null) {
            jSONObject.put("idToken", (Object)string);
        }
        if ((string = this.zzg) != null) {
            jSONObject.put("postBody", (Object)string);
        }
        if ((string = this.zzn) != null) {
            jSONObject.put("tenantId", (Object)string);
        }
        if ((string = this.zzp) != null) {
            jSONObject.put("pendingToken", (Object)string);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzl)) {
            string = this.zzl;
            jSONObject.put("sessionId", (Object)string);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzm)) {
            string = this.zzm;
            jSONObject.put("requestUri", (Object)string);
        } else {
            string = this.zza;
            if (string != null) {
                jSONObject.put("requestUri", (Object)string);
            }
        }
        boolean bl = this.zzo;
        jSONObject.put("returnIdpCredential", bl);
        return jSONObject.toString();
    }

    public zzaec() {
        this.zzi = true;
        this.zzj = true;
    }

    public zzaec(zzk object, String string) {
        Preconditions.checkNotNull((Object)object);
        this.zzl = Preconditions.checkNotEmpty((String)((zzk)object).zzd());
        this.zzm = Preconditions.checkNotEmpty((String)string);
        this.zze = Preconditions.checkNotEmpty((String)((zzk)object).zzc());
        this.zzi = true;
        object = String.valueOf(this.zze);
        this.zzg = "providerId=".concat((String)object);
    }

    public zzaec(@Nullable String charSequence, @Nullable String string, String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable String string8) {
        this.zza = "http://localhost";
        this.zzc = charSequence;
        this.zzd = string;
        this.zzh = string4;
        this.zzk = string5;
        this.zzn = string6;
        this.zzp = string7;
        this.zzi = true;
        if (!(TextUtils.isEmpty((CharSequence)this.zzc) && TextUtils.isEmpty((CharSequence)this.zzd) && TextUtils.isEmpty((CharSequence)this.zzk))) {
            this.zze = Preconditions.checkNotEmpty((String)string2);
            this.zzf = null;
            if (!TextUtils.isEmpty((CharSequence)this.zzc)) {
                ((StringBuilder)charSequence).append("id_token=");
                ((StringBuilder)charSequence).append(this.zzc);
                ((StringBuilder)charSequence).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzd)) {
                ((StringBuilder)charSequence).append("access_token=");
                ((StringBuilder)charSequence).append(this.zzd);
                ((StringBuilder)charSequence).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzf)) {
                ((StringBuilder)charSequence).append("identifier=");
                ((StringBuilder)charSequence).append(this.zzf);
                ((StringBuilder)charSequence).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzh)) {
                ((StringBuilder)charSequence).append("oauth_token_secret=");
                ((StringBuilder)charSequence).append(this.zzh);
                ((StringBuilder)charSequence).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzk)) {
                ((StringBuilder)charSequence).append("code=");
                ((StringBuilder)charSequence).append(this.zzk);
                ((StringBuilder)charSequence).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)string8)) {
                ((StringBuilder)charSequence).append("nonce=");
                ((StringBuilder)charSequence).append(string8);
                ((StringBuilder)charSequence).append("&");
            }
        } else {
            throw new IllegalArgumentException("idToken, accessToken and authCode cannot all be null");
        }
        ((StringBuilder)charSequence).append("providerId=");
        ((StringBuilder)charSequence).append(this.zze);
        this.zzg = ((StringBuilder)charSequence).toString();
        this.zzj = true;
    }

    @SafeParcelable.Constructor
    zzaec(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) String string5, @SafeParcelable.Param(id=7) String string6, @SafeParcelable.Param(id=8) String string7, @SafeParcelable.Param(id=9) String string8, @SafeParcelable.Param(id=10) boolean bl, @SafeParcelable.Param(id=11) boolean bl2, @SafeParcelable.Param(id=12) String string9, @SafeParcelable.Param(id=13) String string10, @SafeParcelable.Param(id=14) String string11, @SafeParcelable.Param(id=15) String string12, @SafeParcelable.Param(id=16) boolean bl3, @SafeParcelable.Param(id=17) String string13) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = string3;
        this.zzd = string4;
        this.zze = string5;
        this.zzf = string6;
        this.zzg = string7;
        this.zzh = string8;
        this.zzi = bl;
        this.zzj = bl2;
        this.zzk = string9;
        this.zzl = string10;
        this.zzm = string11;
        this.zzn = string12;
        this.zzo = bl3;
        this.zzp = string13;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)5, (String)this.zzd, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)6, (String)this.zze, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)7, (String)this.zzf, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)8, (String)this.zzg, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)9, (String)this.zzh, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)10, (boolean)this.zzi);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)11, (boolean)this.zzj);
        SafeParcelWriter.writeString((Parcel)parcel, (int)12, (String)this.zzk, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)13, (String)this.zzl, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)14, (String)this.zzm, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)15, (String)this.zzn, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)16, (boolean)this.zzo);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeString((Parcel)parcel2, (int)17, (String)this.zzp, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

