/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.google.android.gms.internal.firebase-auth-api.zzbb;
import com.google.android.gms.internal.firebase-auth-api.zzbz;
import com.google.android.gms.internal.firebase-auth-api.zzja;
import com.google.android.gms.internal.firebase-auth-api.zzva;
import com.google.android.gms.internal.firebase-auth-api.zzvc;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.concurrent.GuardedBy;
import javax.crypto.KeyGenerator;

public final class zzjb
implements zzbz {
    private static final Object zza = new Object();
    private static final String zzb = zzjb.class.getSimpleName();
    @GuardedBy(value="this")
    private KeyStore zzc;

    @Override
    public final synchronized zzbb zza(String string) throws GeneralSecurityException {
        zzja zzja2;
        zzja zzja3 = zzja2 = new zzja(zzvc.zza("android-keystore://", string), ((zzjb)object).zzc);
        byte[] byArray = zzva.zza(10);
        Object object = new byte[0];
        if (!Arrays.equals(byArray, zzja3.zza(zzja3.zzb(byArray, (byte[])object), (byte[])object))) {
            throw new KeyStoreException("cannot use Android Keystore: encryption/decryption of non-empty message and empty aad returns an incorrect result");
        }
        return zzja2;
    }

    @RequiresApi(value=23)
    public zzjb() throws GeneralSecurityException {
        KeyStore keyStore;
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                keyStore = KeyStore.getInstance("AndroidKeyStore");
                keyStore.load(null);
            }
            catch (IOException | GeneralSecurityException exception) {
                throw new IllegalStateException(exception);
            }
        } else {
            throw new IllegalStateException("need Android Keystore on Android M or newer");
        }
        this.zzc = keyStore;
    }

    @Override
    @RequiresApi(value=23)
    public final synchronized boolean zzb(String string) {
        return string.toLowerCase(Locale.US).startsWith("android-keystore://");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresApi(value=23)
    static boolean zzc(String string) throws GeneralSecurityException {
        zzjb zzjb2 = new zzjb();
        Object object = zza;
        synchronized (object) {
            boolean bl = zzjb2.zzd(string);
            if (bl) return false;
            string = zzvc.zza("android-keystore://", string);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
            keyGenerator.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(string, 3).setKeySize(256).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).build());
            keyGenerator.generateKey();
            return true;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final synchronized boolean zzd(String string) throws GeneralSecurityException {
        string = zzvc.zza("android-keystore://", string);
        try {
            return this.zzc.containsAlias(string);
        }
        catch (NullPointerException nullPointerException) {
            Log.w((String)zzb, (String)"Keystore is temporarily unavailable, wait, reinitialize Keystore and try again.");
            try {
                double d = Math.random();
                double d2 = d * 40.0;
                try {
                    Thread.sleep((int)d2);
                }
                catch (InterruptedException interruptedException) {}
                this.zzc = KeyStore.getInstance("AndroidKeyStore");
                this.zzc.load(null);
                return this.zzc.containsAlias(string);
            }
            catch (IOException iOException) {
                throw new GeneralSecurityException(iOException);
            }
        }
    }
}

