/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzbb;
import com.google.android.gms.internal.firebase-auth-api.zzhh;
import com.google.android.gms.internal.firebase-auth-api.zztn;
import com.google.android.gms.internal.firebase-auth-api.zzto;
import com.google.android.gms.internal.firebase-auth-api.zzvc;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zztp
implements zzbb {
    private static final ThreadLocal zza = new zztn();
    private static final ThreadLocal zzb = new zzto();
    private final byte[] zzc;
    private final byte[] zzd;
    private final SecretKeySpec zze;
    private final int zzf;

    public zztp(byte[] byArray, int n) throws GeneralSecurityException {
        if (!zzhh.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
        }
        if (n != 12 && n != 16) {
            throw new IllegalArgumentException("IV size should be either 12 or 16 bytes");
        }
        this.zzf = n;
        zzvc.zzb(byArray.length);
        String string = "AES";
        this.zze = new SecretKeySpec(byArray, string);
        Cipher cipher = (Cipher)zza.get();
        cipher.init(1, this.zze);
        this.zzc = zztp.zzc(cipher.doFinal(new byte[16]));
        this.zzd = zztp.zzc(this.zzc);
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length;
        int n2 = n - this.zzf + -16;
        if (n2 < 0) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        zztp zztp2 = this;
        Cipher cipher = (Cipher)zza.get();
        cipher.init(1, this.zze);
        byte[] byArray3 = zztp2.zzd(cipher, 0, byArray, 0, this.zzf);
        byte[] byArray4 = zztp2.zzd(cipher, 1, byArray2, 0, 0);
        byte[] byArray5 = zztp2.zzd(cipher, 2, byArray, this.zzf, n2);
        int n3 = n + -16;
        int n4 = 0;
        for (n = 0; n < 16; ++n) {
            n4 |= byArray[n3 + n] ^ byArray4[n] ^ byArray3[n] ^ byArray5[n];
            n4 = (byte)n4;
        }
        if (n4 != 0) {
            throw new AEADBadTagException("tag mismatch");
        }
        Cipher cipher2 = (Cipher)zzb.get();
        cipher2.init(1, (Key)this.zze, new IvParameterSpec(byArray3));
        return cipher2.doFinal(byArray, this.zzf, n2);
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        throw null;
    }

    private static byte[] zzc(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        while (n < 15) {
            byte by = byArray[n];
            byArray2[n++] = (byte)((by + by ^ (byArray[n] & 0xFF) >>> 7) & 0xFF);
        }
        byte by = byArray[15];
        byArray2[15] = (byte)(by + by ^ byArray[0] >> 7 & 0x87);
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final byte[] zzd(Cipher cipher, int n, byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        Object object;
        byte[] byArray2 = new byte[16];
        byArray2[15] = (byte)n;
        if (n3 == 0) {
            return cipher.doFinal(zztp.zze(byArray2, ((zztp)object).zzc));
        }
        byte[] byArray3 = cipher.doFinal(byArray2);
        int n4 = 0;
        while (n3 - n4 > 16) {
            for (int i = 0; i < 16; ++i) {
                int n5 = i;
                byArray3[n5] = (byte)(byArray3[n5] ^ byArray[n2 + n4 + i]);
            }
            byArray3 = cipher.doFinal(byArray3);
            n4 += 16;
        }
        if ((byArray = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3)).length == 16) {
            object = zztp.zze(byArray, ((zztp)object).zzc);
            return cipher.doFinal(zztp.zze(byArray3, (byte[])object));
        }
        byte[] byArray4 = Arrays.copyOf(((zztp)object).zzd, 16);
        for (int i = 0; i < (n3 = byArray.length); ++i) {
            int n6 = i;
            byArray4[n6] = (byte)(byArray4[i] ^ byArray[n6]);
        }
        int n7 = n3;
        byArray4[n7] = (byte)(byArray4[n7] ^ 0x80);
        object = byArray4;
        return cipher.doFinal(zztp.zze(byArray3, (byte[])object));
    }

    private static byte[] zze(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            byArray3[n2] = (byte)(byArray[i] ^ byArray2[n2]);
        }
        return byArray3;
    }
}

