/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzafe;
import com.google.android.gms.internal.zzafg;
import com.google.android.gms.internal.zzafj;
import com.google.android.gms.internal.zzafl;
import com.google.android.gms.internal.zzafn;
import com.google.android.gms.internal.zzafo;
import com.google.android.gms.internal.zzafs;
import com.google.android.gms.internal.zzaft;
import com.google.android.gms.internal.zzafu;
import com.google.android.gms.internal.zzafv;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzafz;
import com.google.android.gms.internal.zzaga;
import com.google.android.gms.internal.zzrb;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.model.GetAccountInfoUser;
import com.google.firebase.auth.api.model.ProviderUserInfo;
import com.google.firebase.auth.api.model.VerifyAssertionRequest;
import java.util.ArrayList;
import java.util.List;

public class zzafd
extends com.google.android.gms.common.api.zzc<zzafl.zza> {
    zzafd(@NonNull Context context, @NonNull zzafl.zza zza2) {
        super(context, zzafl.aNI, (Api.ApiOptions)zza2);
    }

    public Task<GetTokenResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzafs zzafs2) {
        return this.zza(this.zza(new zzd(string).zzd(firebaseApp).zzd(firebaseUser).zzbc(zzafs2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zzn(string).zzd(firebaseApp).zzbc(zzafs2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zzm(authCredential).zzd(firebaseApp).zzbc(zzafs2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zzh(authCredential).zzd(firebaseApp).zzd(firebaseUser).zzbc(zzafs2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zzl().zzd(firebaseApp).zzbc(zzafs2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zzt(userProfileChangeRequest).zzd(firebaseApp).zzd(firebaseUser).zzbc(zzafs2)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zzr(string).zzd(firebaseApp).zzd(firebaseUser).zzbc(zzafs2)));
    }

    public Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zzs(string).zzd(firebaseApp).zzd(firebaseUser).zzbc(zzafs2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zza(string, string2).zzd(firebaseApp).zzbc(zzafs2)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zzo(string, string2).zzd(firebaseApp).zzbc(zzafs2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull String string2, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zzi(string, string2).zzd(firebaseApp).zzd(firebaseUser).zzbc(zzafs2)));
    }

    public Task<ProviderQueryResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zza(this.zza(new zzc(string).zzd(firebaseApp)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zzb(this.zza(new zzk(string).zzd(firebaseApp)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzafs zzafs2) {
        zzab.zzaa((Object)firebaseApp);
        zzab.zzaa((Object)authCredential);
        zzab.zzaa((Object)firebaseUser);
        zzab.zzaa((Object)zzafs2);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            return this.zza(firebaseApp, (EmailAuthCredential)authCredential, firebaseUser, zzafs2);
        }
        return this.zza(firebaseApp, authCredential, firebaseUser, zzafs2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull EmailAuthCredential emailAuthCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zze(emailAuthCredential).zzd(firebaseApp).zzd(firebaseUser).zzbc(zzafs2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzafs zzafs2) {
        zzab.zzaa((Object)firebaseApp);
        zzab.zzaa((Object)authCredential);
        zzab.zzaa((Object)firebaseUser);
        zzab.zzaa((Object)zzafs2);
        List list = firebaseUser.getProviders();
        if (list != null && list.contains(authCredential.getProvider())) {
            return Tasks.forException((Exception)zzafg.zzes(new Status(17015)));
        }
        return this.zzb(this.zza(new zzf(authCredential).zzd(firebaseApp).zzd(firebaseUser).zzbc(zzafs2)));
    }

    public Task<AuthResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzafs zzafs2) {
        zzab.zzaa((Object)firebaseApp);
        zzab.zzhs((String)string);
        zzab.zzaa((Object)firebaseUser);
        zzab.zzaa((Object)zzafs2);
        List list = firebaseUser.getProviders();
        if (list != null && !list.contains(string) || firebaseUser.isAnonymous()) {
            return Tasks.forException((Exception)zzafg.zzes(new Status(17016, string)));
        }
        switch (string) {
            case "password": {
                return this.zza(firebaseApp, firebaseUser, zzafs2);
            }
        }
        return this.zza(firebaseApp, string, firebaseUser, zzafs2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zzp().zzd(firebaseApp).zzd(firebaseUser).zzbc(zzafs2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull FirebaseUser firebaseUser, @NonNull zzafs zzafs2) {
        return this.zzb(this.zza(new zzq(string).zzd(firebaseApp).zzd(firebaseUser).zzbc(zzafs2)));
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzafs zzafs2) {
        return this.zza(this.zza(new zzj().zzd(firebaseApp).zzd(firebaseUser).zzbc(zzafs2)));
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull zzaga zzaga2) {
        return this.zzb(this.zza(new zzb().zzd(firebaseUser).zzbc(zzaga2)));
    }

    @NonNull
    private static zzafx zza(@NonNull FirebaseApp firebaseApp, @NonNull GetAccountInfoUser getAccountInfoUser) {
        return zzafd.zza(firebaseApp, getAccountInfoUser, false);
    }

    @NonNull
    private static zzafx zza(@NonNull FirebaseApp firebaseApp, @NonNull GetAccountInfoUser getAccountInfoUser, boolean bl) {
        zzab.zzaa((Object)firebaseApp);
        zzab.zzaa((Object)getAccountInfoUser);
        ArrayList<zzafv> arrayList = new ArrayList<zzafv>();
        zzafv zzafv2 = new zzafv(getAccountInfoUser, "firebase");
        arrayList.add(zzafv2);
        List list = getAccountInfoUser.zzclk();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(new zzafv((ProviderUserInfo)list.get(i)));
            }
        }
        zzafx zzafx2 = new zzafx(firebaseApp, arrayList);
        zzafx cfr_ignored_0 = (zzafx)zzafx2.zzcm(bl);
        if (!TextUtils.isEmpty((CharSequence)getAccountInfoUser.getEmail()) && !TextUtils.isEmpty((CharSequence)getAccountInfoUser.getPassword())) {
            zzafx2.zzqn("password");
        }
        return zzafx2;
    }

    private <ResultT, CallbackT> zzg<ResultT, CallbackT> zza(zzafo<ResultT, CallbackT> zzafo2) {
        return new zzg<ResultT, CallbackT>(zzafo2);
    }

    private class zzg<ResultT, CallbackT>
    extends zzrb<zzafe, ResultT>
    implements zzafn<ResultT> {
        private zzafo<ResultT, CallbackT> aNA;
        private TaskCompletionSource<ResultT> sq;

        public zzg(zzafo<ResultT, CallbackT> zzafo2) {
            this.aNA = zzafo2;
            this.aNA.zza(this);
        }

        protected void zza(zzafe zzafe2, TaskCompletionSource<ResultT> taskCompletionSource) throws RemoteException {
            this.sq = taskCompletionSource;
            this.aNA.zza(zzafe2.zzckz());
        }

        @Override
        public final void zza(ResultT ResultT, Status status) {
            zzab.zzb(this.sq, (Object)"doExecute must be called before onComplete");
            if (status != null) {
                this.sq.setException((Exception)zzafg.zzes(status));
            } else {
                this.sq.setResult(ResultT);
            }
        }
    }

    static final class zzb
    extends zzafo<Void, zzaga> {
        public zzb() {
            super(5);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zzg(this.aNL.zzckt(), this.aNK);
        }

        @Override
        public void zzcky() {
            ((zzaga)this.aNN).zzckr();
            this.zzbd(null);
        }
    }

    static final class zzj
    extends zzafo<Void, zzafs> {
        public zzj() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zzf(this.aNL.zzckt(), this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ, this.aNL.isAnonymous());
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
            this.zzbd(null);
        }
    }

    static final class zzq
    extends zzafo<AuthResult, zzafs> {
        @NonNull
        private String aNC;

        public zzq(@NonNull String string) {
            super(2);
            this.aNC = zzab.zzh((String)string, (Object)"provider cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zze(this.aNC, this.aNL.zzckt(), this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ);
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
            this.zzbd(new zzafu(zzafx2));
        }
    }

    static final class zzp
    extends zzafo<AuthResult, zzafs> {
        public zzp() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zze(this.aNL.zzckt(), this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ);
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
            this.zzbd(new zzafu(zzafx2));
        }
    }

    static final class zzf
    extends zzafo<AuthResult, zzafs> {
        @NonNull
        private final VerifyAssertionRequest aNz;

        public zzf(@NonNull AuthCredential authCredential) {
            super(2);
            zzab.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aNz = zzaft.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zza(this.aNL.zzckt(), this.aNz, (zzafj)this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ);
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
            this.zzbd(new zzafu(zzafx2));
        }
    }

    static final class zze
    extends zzafo<AuthResult, zzafs> {
        @NonNull
        private final EmailAuthCredential aNy;

        public zze(@NonNull EmailAuthCredential emailAuthCredential) {
            super(2);
            this.aNy = (EmailAuthCredential)zzab.zzb((Object)emailAuthCredential, (Object)"credential cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zza(this.aNy.getEmail(), this.aNy.getPassword(), this.aNL.zzckt(), this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ);
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
            this.zzbd(new zzafu(zzafx2));
        }
    }

    static final class zzk
    extends zzafo<Void, zzafs> {
        @NonNull
        private String dG;

        public zzk(@NonNull String string) {
            super(4);
            this.dG = zzab.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zzd(this.dG, this.aNK);
        }

        @Override
        public void zzcky() {
            this.zzcle();
        }
    }

    static final class zzc
    extends zzafo<ProviderQueryResult, zzafs> {
        @NonNull
        private final String dG;

        public zzc(@NonNull String string) {
            super(3);
            this.dG = zzab.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zzc(this.dG, this.aNK);
        }

        @Override
        public void zzcky() {
            this.zzbd(new zzafy(this.aNR));
        }
    }

    static final class zzi
    extends zzafo<Void, zzafs> {
        @NonNull
        private final String dG;
        @NonNull
        private final String cQ;

        public zzi(@NonNull String string, @NonNull String string2) {
            super(2);
            this.dG = zzab.zzh((String)string, (Object)"email cannot be null or empty");
            this.cQ = zzab.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zzd(this.dG, this.cQ, this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ);
            if (this.aNL.getUid().equalsIgnoreCase(zzafx2.getUid())) {
                ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
                this.zzcle();
            } else {
                this.zzet(zzafz.zzclz());
            }
        }
    }

    static final class zzo
    extends zzafo<AuthResult, zzafs> {
        @NonNull
        private String dG;
        @NonNull
        private String cQ;

        public zzo(String string, String string2) {
            super(2);
            this.dG = zzab.zzh((String)string, (Object)"email cannot be null or empty");
            this.cQ = zzab.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zzd(this.dG, this.cQ, this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ);
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
            this.zzbd(new zzafu(zzafx2));
        }
    }

    static final class zza
    extends zzafo<AuthResult, zzafs> {
        @NonNull
        private String dG;
        @NonNull
        private String cQ;

        public zza(@NonNull String string, @NonNull String string2) {
            super(2);
            this.dG = zzab.zzh((String)string, (Object)"email cannot be null or empty");
            this.cQ = zzab.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zzc(this.dG, this.cQ, this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ);
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
            this.zzbd(new zzafu(zzafx2));
        }
    }

    static final class zzs
    extends zzafo<Void, zzafs> {
        @NonNull
        private final String cQ;

        public zzs(@NonNull String string) {
            super(2);
            this.cQ = zzab.zzh((String)string, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zzb(this.aNL.zzckt(), this.cQ, this.aNK);
        }

        @Override
        public void zzcky() {
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafd.zza(this.aNi, this.aNQ));
            this.zzcle();
        }
    }

    static final class zzr
    extends zzafo<Void, zzafs> {
        @NonNull
        private final String dG;

        public zzr(String string) {
            super(2);
            this.dG = zzab.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zza(this.aNL.zzckt(), this.dG, (zzafj)this.aNK);
        }

        @Override
        public void zzcky() {
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafd.zza(this.aNi, this.aNQ));
            this.zzcle();
        }
    }

    static final class zzt
    extends zzafo<Void, zzafs> {
        @NonNull
        private final UserProfileChangeRequest aND;

        public zzt(UserProfileChangeRequest userProfileChangeRequest) {
            super(2);
            this.aND = (UserProfileChangeRequest)zzab.zzb((Object)userProfileChangeRequest, (Object)"request cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zza(this.aNL.zzckt(), this.aND, (zzafj)this.aNK);
        }

        @Override
        public void zzcky() {
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafd.zza(this.aNi, this.aNQ));
            this.zzcle();
        }
    }

    static final class zzl
    extends zzafo<AuthResult, zzafs> {
        public zzl() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zza(this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ, true);
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
            this.zzbd(new zzafu(zzafx2));
        }
    }

    static final class zzh
    extends zzafo<Void, zzafs> {
        @NonNull
        private final VerifyAssertionRequest aNz;

        public zzh(@NonNull AuthCredential authCredential) {
            super(2);
            zzab.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aNz = zzaft.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zza(this.aNz, (zzafj)this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ);
            if (this.aNL.getUid().equalsIgnoreCase(zzafx2.getUid())) {
                ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
                this.zzcle();
            } else {
                this.zzet(zzafz.zzclz());
            }
        }
    }

    static final class zzm
    extends zzafo<AuthResult, zzafs> {
        @NonNull
        private final VerifyAssertionRequest aNz;

        public zzm(@NonNull AuthCredential authCredential) {
            super(2);
            zzab.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aNz = zzaft.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zza(this.aNz, (zzafj)this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ);
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
            this.zzbd(new zzafu(zzafx2));
        }
    }

    static final class zzn
    extends zzafo<AuthResult, zzafs> {
        @NonNull
        private final String ct;

        public zzn(@NonNull String string) {
            super(2);
            this.ct = zzab.zzh((String)string, (Object)"token cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zzb(this.ct, this.aNK);
        }

        @Override
        public void zzcky() {
            zzafx zzafx2 = zzafd.zza(this.aNi, this.aNQ);
            ((zzafs)this.aNN).zza(this.aNP, (FirebaseUser)zzafx2);
            this.zzbd(new zzafu(zzafx2));
        }
    }

    static final class zzd
    extends zzafo<GetTokenResult, zzafs> {
        @NonNull
        private final String aNx;

        public zzd(@NonNull String string) {
            super(1);
            this.aNx = zzab.zzh((String)string, (Object)"refresh token cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aNM.zza(this.aNx, (zzafj)this.aNK);
        }

        @Override
        public void zzcky() {
            this.aNP.zzqm(this.aNx);
            ((zzafs)this.aNN).zza(this.aNP, this.aNL);
            this.zzbd(new GetTokenResult(this.aNP.getAccessToken()));
        }
    }
}

