/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzafd;
import com.google.android.gms.internal.zzafg;
import com.google.android.gms.internal.zzafi;
import com.google.android.gms.internal.zzafl;
import com.google.android.gms.internal.zzafs;
import com.google.android.gms.internal.zzafu;
import com.google.android.gms.internal.zzafw;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzaga;
import com.google.android.gms.internal.zzagb;
import com.google.android.gms.internal.zzagc;
import com.google.android.gms.internal.zzalt;
import com.google.android.gms.internal.zzams;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.model.GetTokenResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FirebaseAuth
implements zzalt {
    private FirebaseApp aNi;
    private List<AuthStateListener> mListeners;
    private zzafd aNj;
    private FirebaseUser aNk;
    private zzagb aNl;
    private zzams aNm;
    private zzagc aNn;
    private static Map<String, FirebaseAuth> abO = new ArrayMap();
    private static FirebaseAuth aNo;

    public static FirebaseAuth getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        return FirebaseAuth.zzb(firebaseApp);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, FirebaseAuth.zza(firebaseApp), new zzagb(firebaseApp.getApplicationContext(), firebaseApp.zzckc(), zzafi.zzcla()));
    }

    FirebaseAuth(FirebaseApp firebaseApp, zzafd zzafd2, zzagb zzagb2) {
        this.aNi = (FirebaseApp)zzab.zzaa((Object)firebaseApp);
        this.aNj = (zzafd)((Object)zzab.zzaa((Object)((Object)zzafd2)));
        this.aNl = (zzagb)zzab.zzaa((Object)zzagb2);
        this.mListeners = new CopyOnWriteArrayList<AuthStateListener>();
        this.aNm = zzafi.zzcla();
        this.aNn = zzagc.zzcmc();
        this.zzckq();
    }

    static zzafd zza(FirebaseApp firebaseApp) {
        zzafl.zza zza2 = new zzafl.zza.zza(firebaseApp.getOptions().getApiKey()).zzcld();
        return zzafl.zza(firebaseApp.getApplicationContext(), zza2);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.aNk;
    }

    public void zza(@NonNull FirebaseUser firebaseUser, boolean bl, boolean bl2) {
        zzab.zzaa((Object)firebaseUser);
        if (this.aNk == null) {
            this.aNk = firebaseUser;
        } else {
            this.aNk.zzcm(firebaseUser.isAnonymous());
            this.aNk.zzan(firebaseUser.getProviderData());
        }
        if (bl) {
            this.aNl.zze(this.aNk);
        }
        if (bl2) {
            this.zza(this.aNk);
        }
    }

    public void zza(@NonNull FirebaseUser firebaseUser, @NonNull GetTokenResponse getTokenResponse, boolean bl) {
        boolean bl2;
        zzab.zzaa((Object)firebaseUser);
        zzab.zzaa((Object)getTokenResponse);
        if (this.aNk == null) {
            bl2 = true;
        } else {
            GetTokenResponse getTokenResponse2 = (GetTokenResponse)this.aNm.zzf(this.aNk.zzckt(), GetTokenResponse.class);
            String string = getTokenResponse2.getAccessToken();
            String string2 = getTokenResponse.getAccessToken();
            boolean bl3 = bl2 = this.aNk.getUid().equalsIgnoreCase(firebaseUser.getUid()) && string != null && !string.equals(string2);
        }
        if (bl2) {
            if (this.aNk != null) {
                this.aNk.zzql(this.aNm.zzcj((Object)getTokenResponse));
            }
            this.zza(this.aNk);
        }
        if (bl) {
            this.aNl.zza(firebaseUser, getTokenResponse);
        }
    }

    public void zzckp() {
        if (this.aNk != null) {
            this.aNl.zzg(this.aNk);
            this.aNk = null;
        }
        this.aNl.zzcmb();
        this.zza(null);
    }

    private static FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzc(firebaseApp);
    }

    private static synchronized FirebaseAuth zzc(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = abO.get(firebaseApp.zzckc());
        if (firebaseAuth == null) {
            firebaseAuth = new zzafw(firebaseApp);
            firebaseApp.zza((zzalt)firebaseAuth);
            if (aNo == null) {
                aNo = firebaseAuth;
            }
            abO.put(firebaseApp.zzckc(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addAuthStateListener(final @NonNull AuthStateListener authStateListener) {
        this.mListeners.add(authStateListener);
        this.aNn.execute(new Runnable(){

            @Override
            public void run() {
                authStateListener.onAuthStateChanged(FirebaseAuth.this);
            }
        });
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.mListeners.remove(authStateListener);
    }

    public void zza(final @Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(36 + String.valueOf(string).length()).append("Notifying listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying listeners about a sign-out event.");
        }
        this.aNn.execute(new Runnable(){

            @Override
            public void run() {
                FirebaseAuth.this.aNi.zza((zzalt)FirebaseAuth.this, firebaseUser);
                for (AuthStateListener authStateListener : FirebaseAuth.this.mListeners) {
                    authStateListener.onAuthStateChanged(FirebaseAuth.this);
                }
            }
        });
    }

    @NonNull
    public Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzafg.zzes(new Status(17495)));
        }
        GetTokenResponse getTokenResponse = (GetTokenResponse)this.aNm.zzf(this.aNk.zzckt(), GetTokenResponse.class);
        if (getTokenResponse.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(getTokenResponse.getAccessToken()));
        }
        return this.aNj.zza(this.aNi, firebaseUser, getTokenResponse.zzcln(), new zzafs(){

            public void zza(@NonNull GetTokenResponse getTokenResponse, @NonNull FirebaseUser firebaseUser) {
                FirebaseAuth.this.zza(firebaseUser, getTokenResponse, true);
            }
        });
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzab.zzaa((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.aNj.zzb(this.aNi, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzafs)new zza());
        }
        return this.aNj.zza(this.aNi, authCredential, (zzafs)new zza());
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzab.zzaa((Object)firebaseUser);
        zzab.zzaa((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.aNj.zza(this.aNi, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza());
        }
        return this.aNj.zza(this.aNi, firebaseUser, authCredential, (zzafs)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzab.zzhs((String)string);
        return this.aNj.zza(this.aNi, string, (zzafs)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzab.zzhs((String)string);
        zzab.zzhs((String)string2);
        return this.aNj.zzb(this.aNi, string, string2, (zzafs)new zza());
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.aNk != null && this.aNk.isAnonymous()) {
            zzafx zzafx2 = (zzafx)this.aNk;
            zzafu zzafu2 = new zzafu(zzafx2);
            return Tasks.forResult((Object)zzafu2);
        }
        return this.aNj.zza(this.aNi, new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        zzab.zzaa((Object)firebaseUser);
        return this.aNj.zzb(this.aNi, firebaseUser, new zza());
    }

    @NonNull
    public Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzab.zzaa((Object)authCredential);
        zzab.zzaa((Object)firebaseUser);
        return this.aNj.zzb(this.aNi, firebaseUser, authCredential, (zzafs)new zza());
    }

    @NonNull
    public Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzab.zzhs((String)string);
        zzab.zzaa((Object)firebaseUser);
        return this.aNj.zzd(this.aNi, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzab.zzhs((String)string);
        zzab.zzhs((String)string2);
        return this.aNj.zza(this.aNi, string, string2, (zzafs)new zza());
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzab.zzhs((String)string);
        return this.aNj.zza(this.aNi, string);
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzab.zzaa((Object)firebaseUser);
        zzab.zzaa((Object)userProfileChangeRequest);
        return this.aNj.zza(this.aNi, firebaseUser, userProfileChangeRequest, (zzafs)new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzab.zzaa((Object)firebaseUser);
        zzab.zzhs((String)string);
        return this.aNj.zzb(this.aNi, firebaseUser, string, (zzafs)new zza());
    }

    @NonNull
    public Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzab.zzaa((Object)firebaseUser);
        zzab.zzhs((String)string);
        return this.aNj.zzc(this.aNi, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzab.zzhs((String)string);
        return this.aNj.zzb(this.aNi, string);
    }

    @NonNull
    public Task<Void> zzc(final @NonNull FirebaseUser firebaseUser) {
        zzab.zzaa((Object)firebaseUser);
        return this.aNj.zza(firebaseUser, new zzaga(){

            public void zzckr() {
                if (FirebaseAuth.this.aNk.getUid().equalsIgnoreCase(firebaseUser.getUid())) {
                    FirebaseAuth.this.zzckp();
                }
            }
        });
    }

    public void signOut() {
        this.zzckp();
    }

    protected void zzckq() {
        this.aNk = this.aNl.zzcma();
        if (this.aNk != null) {
            this.zza(this.aNk, false, true);
            GetTokenResponse getTokenResponse = this.aNl.zzf(this.aNk);
            if (getTokenResponse != null) {
                this.zza(this.aNk, getTokenResponse, false);
            }
        }
    }

    class zza
    implements zzafs {
        zza() {
        }

        public void zza(@NonNull GetTokenResponse getTokenResponse, @NonNull FirebaseUser firebaseUser) {
            zzab.zzaa((Object)getTokenResponse);
            zzab.zzaa((Object)firebaseUser);
            firebaseUser.zzql(FirebaseAuth.this.aNm.zzcj((Object)getTokenResponse));
            FirebaseAuth.this.zza(firebaseUser, getTokenResponse, true);
            FirebaseAuth.this.zza(firebaseUser, true, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }
}

