/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzagl;
import com.google.android.gms.internal.zzago;
import com.google.android.gms.internal.zzagq;
import com.google.android.gms.internal.zzagt;
import com.google.android.gms.internal.zzaha;
import com.google.android.gms.internal.zzahc;
import com.google.android.gms.internal.zzahe;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzahk;
import com.google.android.gms.internal.zzanb;
import com.google.android.gms.internal.zzanc;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.model.GetTokenResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FirebaseAuth
implements zzanb {
    private FirebaseApp aTF;
    private List<AuthStateListener> mListeners;
    private zzagl aTG;
    private FirebaseUser aTH;
    private zzahj aTI;
    private zzahk aTJ;
    private static Map<String, FirebaseAuth> afS = new ArrayMap();
    private static FirebaseAuth aTK;

    public static FirebaseAuth getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        return FirebaseAuth.zzc(firebaseApp);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzc(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, FirebaseAuth.zzb(firebaseApp), new zzahj(firebaseApp.getApplicationContext(), firebaseApp.zzcnv(), zzagq.zzcpf()));
    }

    FirebaseAuth(FirebaseApp firebaseApp, zzagl zzagl2, zzahj zzahj2) {
        this.aTF = (FirebaseApp)zzac.zzy((Object)firebaseApp);
        this.aTG = (zzagl)((Object)zzac.zzy((Object)((Object)zzagl2)));
        this.aTI = (zzahj)zzac.zzy((Object)zzahj2);
        this.mListeners = new CopyOnWriteArrayList<AuthStateListener>();
        this.aTJ = zzahk.zzcqi();
        this.zzcos();
    }

    static zzagl zzb(FirebaseApp firebaseApp) {
        zzagt.zza zza2 = new zzagt.zza.zza(firebaseApp.getOptions().getApiKey()).zzcpj();
        return zzagt.zza(firebaseApp.getApplicationContext(), zza2);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.aTH;
    }

    public void zza(@NonNull FirebaseUser firebaseUser, boolean bl, boolean bl2) {
        zzac.zzy((Object)firebaseUser);
        if (this.aTH == null) {
            this.aTH = firebaseUser;
        } else {
            this.aTH.zzcs(firebaseUser.isAnonymous());
            this.aTH.zzaq(firebaseUser.getProviderData());
        }
        if (bl) {
            this.aTI.zzf(this.aTH);
        }
        if (bl2) {
            this.zza(this.aTH);
        }
    }

    public void zza(@NonNull FirebaseUser firebaseUser, @NonNull GetTokenResponse getTokenResponse, boolean bl) {
        boolean bl2;
        zzac.zzy((Object)firebaseUser);
        zzac.zzy((Object)getTokenResponse);
        if (this.aTH == null) {
            bl2 = true;
        } else {
            GetTokenResponse getTokenResponse2 = this.aTH.zzcov();
            String string = getTokenResponse2.getAccessToken();
            String string2 = getTokenResponse.getAccessToken();
            boolean bl3 = bl2 = this.aTH.getUid().equalsIgnoreCase(firebaseUser.getUid()) && string != null && !string.equals(string2);
        }
        if (bl2) {
            if (this.aTH != null) {
                this.aTH.zza(getTokenResponse);
            }
            this.zza(this.aTH);
        }
        if (bl) {
            this.aTI.zza(firebaseUser, getTokenResponse);
        }
    }

    public void zzcor() {
        if (this.aTH != null) {
            this.aTI.zzh(this.aTH);
            this.aTH = null;
        }
        this.aTI.zzcqh();
        this.zza(null);
    }

    private static FirebaseAuth zzc(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzd(firebaseApp);
    }

    private static synchronized FirebaseAuth zzd(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = afS.get(firebaseApp.zzcnv());
        if (firebaseAuth == null) {
            firebaseAuth = new zzahe(firebaseApp);
            firebaseApp.zza((zzanb)firebaseAuth);
            if (aTK == null) {
                aTK = firebaseAuth;
            }
            afS.put(firebaseApp.zzcnv(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addAuthStateListener(final @NonNull AuthStateListener authStateListener) {
        this.mListeners.add(authStateListener);
        this.aTJ.execute(new Runnable(){

            @Override
            public void run() {
                authStateListener.onAuthStateChanged(FirebaseAuth.this);
            }
        });
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.mListeners.remove(authStateListener);
    }

    public void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(36 + String.valueOf(string).length()).append("Notifying listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzcox() : null;
        final zzanc zzanc2 = new zzanc(string);
        this.aTJ.execute(new Runnable(){

            @Override
            public void run() {
                FirebaseAuth.this.aTF.zza(zzanc2);
                for (AuthStateListener authStateListener : FirebaseAuth.this.mListeners) {
                    authStateListener.onAuthStateChanged(FirebaseAuth.this);
                }
            }
        });
    }

    @NonNull
    public Task<GetTokenResult> zzcr(boolean bl) {
        return this.zza(this.aTH, bl);
    }

    @NonNull
    public Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzago.zzew(new Status(17495)));
        }
        GetTokenResponse getTokenResponse = this.aTH.zzcov();
        if (getTokenResponse.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(getTokenResponse.getAccessToken()));
        }
        return this.aTG.zza(this.aTF, firebaseUser, getTokenResponse.zzcps(), new zzaha(){

            @Override
            public void zza(@NonNull GetTokenResponse getTokenResponse, @NonNull FirebaseUser firebaseUser) {
                FirebaseAuth.this.zza(firebaseUser, getTokenResponse, true);
            }
        });
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzac.zzy((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.aTG.zzb(this.aTF, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzaha)new zza());
        }
        return this.aTG.zza(this.aTF, authCredential, (zzaha)new zza());
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzac.zzy((Object)firebaseUser);
        zzac.zzy((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.aTG.zza(this.aTF, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza());
        }
        return this.aTG.zza(this.aTF, firebaseUser, authCredential, (zzaha)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzac.zzhz((String)string);
        return this.aTG.zza(this.aTF, string, (zzaha)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzac.zzhz((String)string);
        zzac.zzhz((String)string2);
        return this.aTG.zzb(this.aTF, string, string2, (zzaha)new zza());
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.aTH != null && this.aTH.isAnonymous()) {
            zzahf zzahf2 = (zzahf)this.aTH;
            zzahc zzahc2 = new zzahc(zzahf2);
            return Tasks.forResult((Object)zzahc2);
        }
        return this.aTG.zza(this.aTF, new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        zzac.zzy((Object)firebaseUser);
        return this.aTG.zzb(this.aTF, firebaseUser, new zza());
    }

    @NonNull
    public Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzac.zzy((Object)authCredential);
        zzac.zzy((Object)firebaseUser);
        return this.aTG.zzb(this.aTF, firebaseUser, authCredential, (zzaha)new zza());
    }

    @NonNull
    public Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzhz((String)string);
        zzac.zzy((Object)firebaseUser);
        return this.aTG.zzd(this.aTF, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzac.zzhz((String)string);
        zzac.zzhz((String)string2);
        return this.aTG.zza(this.aTF, string, string2, (zzaha)new zza());
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzac.zzhz((String)string);
        return this.aTG.zza(this.aTF, string);
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzac.zzy((Object)firebaseUser);
        zzac.zzy((Object)userProfileChangeRequest);
        return this.aTG.zza(this.aTF, firebaseUser, userProfileChangeRequest, (zzaha)new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzy((Object)firebaseUser);
        zzac.zzhz((String)string);
        return this.aTG.zzb(this.aTF, firebaseUser, string, (zzaha)new zza());
    }

    @NonNull
    public Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzy((Object)firebaseUser);
        zzac.zzhz((String)string);
        return this.aTG.zzc(this.aTF, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzac.zzhz((String)string);
        return this.aTG.zzb(this.aTF, string);
    }

    @NonNull
    public Task<Void> zzrv(@NonNull String string) {
        zzac.zzhz((String)string);
        return this.aTG.zzc(this.aTF, string);
    }

    @NonNull
    public Task<Void> zzc(final @NonNull FirebaseUser firebaseUser) {
        zzac.zzy((Object)firebaseUser);
        return this.aTG.zza(firebaseUser, new zzahi(){

            public void zzcot() {
                if (FirebaseAuth.this.aTH.getUid().equalsIgnoreCase(firebaseUser.getUid())) {
                    FirebaseAuth.this.zzcor();
                }
            }
        });
    }

    public void signOut() {
        this.zzcor();
    }

    protected void zzcos() {
        this.aTH = this.aTI.zzcqg();
        if (this.aTH != null) {
            this.zza(this.aTH, false, true);
            GetTokenResponse getTokenResponse = this.aTI.zzg(this.aTH);
            if (getTokenResponse != null) {
                this.zza(this.aTH, getTokenResponse, false);
            }
        }
    }

    class zza
    implements zzaha {
        zza() {
        }

        @Override
        public void zza(@NonNull GetTokenResponse getTokenResponse, @NonNull FirebaseUser firebaseUser) {
            zzac.zzy((Object)getTokenResponse);
            zzac.zzy((Object)firebaseUser);
            firebaseUser.zza(getTokenResponse);
            FirebaseAuth.this.zza(firebaseUser, getTokenResponse, true);
            FirebaseAuth.this.zza(firebaseUser, true, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }
}

