/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzahc;
import com.google.android.gms.internal.zzahe;
import com.google.android.gms.internal.zzahh;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzahl;
import com.google.android.gms.internal.zzahm;
import com.google.android.gms.internal.zzahq;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzahs;
import com.google.android.gms.internal.zzaht;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzahx;
import com.google.android.gms.internal.zzahy;
import com.google.android.gms.internal.zzsb;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.model.GetAccountInfoUser;
import com.google.firebase.auth.api.model.ProviderUserInfo;
import com.google.firebase.auth.api.model.VerifyAssertionRequest;
import java.util.ArrayList;
import java.util.List;

public class zzahb
extends com.google.android.gms.common.api.zzc<zzahj.zza> {
    zzahb(@NonNull Context context, @NonNull zzahj.zza zza2) {
        super(context, zzahj.aXv, (Api.ApiOptions)zza2, (zzsb)new com.google.firebase.zza());
    }

    public Task<GetTokenResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzahq zzahq2) {
        return this.doRead(this.zza(new zzd(string).zze(firebaseApp).zze(firebaseUser).zzbd(zzahq2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zzo(string).zze(firebaseApp).zzbd(zzahq2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zzn(authCredential).zze(firebaseApp).zzbd(zzahq2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zzh(authCredential).zze(firebaseApp).zze(firebaseUser).zzbd(zzahq2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zzm().zze(firebaseApp).zzbd(zzahq2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zzu(userProfileChangeRequest).zze(firebaseApp).zze(firebaseUser).zzbd(zzahq2)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zzs(string).zze(firebaseApp).zze(firebaseUser).zzbd(zzahq2)));
    }

    public Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zzt(string).zze(firebaseApp).zze(firebaseUser).zzbd(zzahq2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zza(string, string2).zze(firebaseApp).zzbd(zzahq2)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zzp(string, string2).zze(firebaseApp).zzbd(zzahq2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull String string2, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zzi(string, string2).zze(firebaseApp).zze(firebaseUser).zzbd(zzahq2)));
    }

    public Task<ProviderQueryResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doRead(this.zza(new zzc(string).zze(firebaseApp)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zzl(string).zze(firebaseApp)));
    }

    public Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zzk(string).zze(firebaseApp)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzahq zzahq2) {
        zzaa.zzy((Object)firebaseApp);
        zzaa.zzy((Object)authCredential);
        zzaa.zzy((Object)firebaseUser);
        zzaa.zzy((Object)zzahq2);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            return this.zza(firebaseApp, (EmailAuthCredential)authCredential, firebaseUser, zzahq2);
        }
        return this.zza(firebaseApp, authCredential, firebaseUser, zzahq2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull EmailAuthCredential emailAuthCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zze(emailAuthCredential).zze(firebaseApp).zze(firebaseUser).zzbd(zzahq2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzahq zzahq2) {
        zzaa.zzy((Object)firebaseApp);
        zzaa.zzy((Object)authCredential);
        zzaa.zzy((Object)firebaseUser);
        zzaa.zzy((Object)zzahq2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && list.contains(authCredential.getProvider())) {
            return Tasks.forException((Exception)zzahe.zzfc(new Status(17015)));
        }
        return this.doWrite(this.zza(new zzf(authCredential).zze(firebaseApp).zze(firebaseUser).zzbd(zzahq2)));
    }

    public Task<AuthResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzahq zzahq2) {
        zzaa.zzy((Object)firebaseApp);
        zzaa.zzib((String)string);
        zzaa.zzy((Object)firebaseUser);
        zzaa.zzy((Object)zzahq2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && !list.contains(string) || firebaseUser.isAnonymous()) {
            return Tasks.forException((Exception)zzahe.zzfc(new Status(17016, string)));
        }
        switch (string) {
            case "password": {
                return this.zza(firebaseApp, firebaseUser, zzahq2);
            }
        }
        return this.zza(firebaseApp, string, firebaseUser, zzahq2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zzq().zze(firebaseApp).zze(firebaseUser).zzbd(zzahq2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull FirebaseUser firebaseUser, @NonNull zzahq zzahq2) {
        return this.doWrite(this.zza(new zzr(string).zze(firebaseApp).zze(firebaseUser).zzbd(zzahq2)));
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzahq zzahq2) {
        return this.doRead(this.zza(new zzj().zze(firebaseApp).zze(firebaseUser).zzbd(zzahq2)));
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull zzahy zzahy2) {
        return this.doWrite(this.zza(new zzb().zze(firebaseUser).zzbd(zzahy2)));
    }

    @NonNull
    private static zzahv zza(@NonNull FirebaseApp firebaseApp, @NonNull GetAccountInfoUser getAccountInfoUser) {
        return zzahb.zza(firebaseApp, getAccountInfoUser, false);
    }

    @NonNull
    private static zzahv zza(@NonNull FirebaseApp firebaseApp, @NonNull GetAccountInfoUser getAccountInfoUser, boolean bl) {
        zzaa.zzy((Object)firebaseApp);
        zzaa.zzy((Object)getAccountInfoUser);
        ArrayList<zzaht> arrayList = new ArrayList<zzaht>();
        zzaht zzaht2 = new zzaht(getAccountInfoUser, "firebase");
        arrayList.add(zzaht2);
        List list = getAccountInfoUser.zzcpr();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(new zzaht((ProviderUserInfo)list.get(i)));
            }
        }
        zzahv zzahv2 = new zzahv(firebaseApp, arrayList);
        zzahv cfr_ignored_0 = (zzahv)zzahv2.zzcu(bl);
        return zzahv2;
    }

    private <ResultT, CallbackT> zzg<ResultT, CallbackT> zza(zzahm<ResultT, CallbackT> zzahm2) {
        return new zzg<ResultT, CallbackT>(zzahm2);
    }

    private class zzg<ResultT, CallbackT>
    extends zzse<zzahc, ResultT>
    implements zzahl<ResultT> {
        private zzahm<ResultT, CallbackT> aXn;
        private TaskCompletionSource<ResultT> yg;

        public zzg(zzahm<ResultT, CallbackT> zzahm2) {
            this.aXn = zzahm2;
            this.aXn.zza(this);
        }

        protected void zza(zzahc zzahc2, TaskCompletionSource<ResultT> taskCompletionSource) throws RemoteException {
            this.yg = taskCompletionSource;
            this.aXn.zza(zzahc2.zzcpg());
        }

        @Override
        public final void zza(ResultT ResultT, Status status) {
            zzaa.zzb(this.yg, (Object)"doExecute must be called before onComplete");
            if (status != null) {
                this.yg.setException((Exception)zzahe.zzfc(status));
            } else {
                this.yg.setResult(ResultT);
            }
        }

        protected /* synthetic */ void zzb(Api.zzb zzb2, TaskCompletionSource taskCompletionSource) throws RemoteException {
            this.zza((zzahc)zzb2, taskCompletionSource);
        }
    }

    static final class zzb
    extends zzahm<Void, zzahy> {
        public zzb() {
            super(5);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zzg(this.aXy.zzcoy(), this.aXx);
        }

        @Override
        public void zzcpf() {
            ((zzahy)this.aXA).zzcov();
            this.zzbe(null);
        }
    }

    static final class zzj
    extends zzahm<Void, zzahq> {
        public zzj() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zzf(this.aXy.zzcoy(), this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD, this.aXy.isAnonymous());
            ((zzahq)this.aXA).zza(this.aXC, zzahv2);
            this.zzbe(null);
        }
    }

    static final class zzr
    extends zzahm<AuthResult, zzahq> {
        @NonNull
        private String aXp;

        public zzr(@NonNull String string) {
            super(2);
            this.aXp = zzaa.zzh((String)string, (Object)"provider cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zze(this.aXp, this.aXy.zzcoy(), this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD);
            ((zzahq)this.aXA).zza(this.aXC, zzahv2);
            this.zzbe(new zzahs(zzahv2));
        }
    }

    static final class zzq
    extends zzahm<AuthResult, zzahq> {
        public zzq() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zze(this.aXy.zzcoy(), this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD);
            ((zzahq)this.aXA).zza(this.aXC, zzahv2);
            this.zzbe(new zzahs(zzahv2));
        }
    }

    static final class zzf
    extends zzahm<AuthResult, zzahq> {
        @NonNull
        private final VerifyAssertionRequest aXm;

        public zzf(@NonNull AuthCredential authCredential) {
            super(2);
            zzaa.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aXm = zzahr.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zza(this.aXy.zzcoy(), this.aXm, (zzahh)this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD);
            ((zzahq)this.aXA).zza(this.aXC, zzahv2);
            this.zzbe(new zzahs(zzahv2));
        }
    }

    static final class zze
    extends zzahm<AuthResult, zzahq> {
        @NonNull
        private final EmailAuthCredential aXl;

        public zze(@NonNull EmailAuthCredential emailAuthCredential) {
            super(2);
            this.aXl = (EmailAuthCredential)zzaa.zzb((Object)emailAuthCredential, (Object)"credential cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zza(this.aXl.getEmail(), this.aXl.getPassword(), this.aXy.zzcoy(), this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD);
            ((zzahq)this.aXA).zza(this.aXC, zzahv2);
            this.zzbe(new zzahs(zzahv2));
        }
    }

    static final class zzk
    extends zzahm<Void, zzahq> {
        @NonNull
        private String hN;

        public zzk(@NonNull String string) {
            super(6);
            this.hN = zzaa.zzh((String)string, (Object)"token cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zzh(this.hN, this.aXx);
        }

        @Override
        public void zzcpf() {
            this.zzcpm();
        }
    }

    static final class zzl
    extends zzahm<Void, zzahq> {
        @NonNull
        private String jg;

        public zzl(@NonNull String string) {
            super(4);
            this.jg = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zzd(this.jg, this.aXx);
        }

        @Override
        public void zzcpf() {
            this.zzcpm();
        }
    }

    static final class zzc
    extends zzahm<ProviderQueryResult, zzahq> {
        @NonNull
        private final String jg;

        public zzc(@NonNull String string) {
            super(3);
            this.jg = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zzc(this.jg, this.aXx);
        }

        @Override
        public void zzcpf() {
            this.zzbe(new zzahw(this.aXE));
        }
    }

    static final class zzi
    extends zzahm<Void, zzahq> {
        @NonNull
        private final String jg;
        @NonNull
        private final String io;

        public zzi(@NonNull String string, @NonNull String string2) {
            super(2);
            this.jg = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
            this.io = zzaa.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zzd(this.jg, this.io, this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD);
            if (this.aXy.getUid().equalsIgnoreCase(zzahv2.getUid())) {
                ((zzahq)this.aXA).zza(this.aXC, zzahv2);
                this.zzcpm();
            } else {
                this.zzfd(zzahx.zzcqh());
            }
        }
    }

    static final class zzp
    extends zzahm<AuthResult, zzahq> {
        @NonNull
        private String jg;
        @NonNull
        private String io;

        public zzp(String string, String string2) {
            super(2);
            this.jg = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
            this.io = zzaa.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zzd(this.jg, this.io, this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD);
            ((zzahq)this.aXA).zza(this.aXC, zzahv2);
            this.zzbe(new zzahs(zzahv2));
        }
    }

    static final class zza
    extends zzahm<AuthResult, zzahq> {
        @NonNull
        private String jg;
        @NonNull
        private String io;

        public zza(@NonNull String string, @NonNull String string2) {
            super(2);
            this.jg = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
            this.io = zzaa.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zzc(this.jg, this.io, this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD);
            ((zzahq)this.aXA).zza(this.aXC, zzahv2);
            this.zzbe(new zzahs(zzahv2));
        }
    }

    static final class zzt
    extends zzahm<Void, zzahq> {
        @NonNull
        private final String io;

        public zzt(@NonNull String string) {
            super(2);
            this.io = zzaa.zzh((String)string, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zzb(this.aXy.zzcoy(), this.io, this.aXx);
        }

        @Override
        public void zzcpf() {
            ((zzahq)this.aXA).zza(this.aXC, zzahb.zza(this.aWU, this.aXD));
            this.zzcpm();
        }
    }

    static final class zzs
    extends zzahm<Void, zzahq> {
        @NonNull
        private final String jg;

        public zzs(String string) {
            super(2);
            this.jg = zzaa.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zza(this.aXy.zzcoy(), this.jg, (zzahh)this.aXx);
        }

        @Override
        public void zzcpf() {
            ((zzahq)this.aXA).zza(this.aXC, zzahb.zza(this.aWU, this.aXD));
            this.zzcpm();
        }
    }

    static final class zzu
    extends zzahm<Void, zzahq> {
        @NonNull
        private final UserProfileChangeRequest aXq;

        public zzu(UserProfileChangeRequest userProfileChangeRequest) {
            super(2);
            this.aXq = (UserProfileChangeRequest)zzaa.zzb((Object)userProfileChangeRequest, (Object)"request cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zza(this.aXy.zzcoy(), this.aXq, (zzahh)this.aXx);
        }

        @Override
        public void zzcpf() {
            ((zzahq)this.aXA).zza(this.aXC, zzahb.zza(this.aWU, this.aXD));
            this.zzcpm();
        }
    }

    static final class zzm
    extends zzahm<AuthResult, zzahq> {
        public zzm() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zza(this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD, true);
            ((zzahq)this.aXA).zza(this.aXC, zzahv2);
            this.zzbe(new zzahs(zzahv2));
        }
    }

    static final class zzh
    extends zzahm<Void, zzahq> {
        @NonNull
        private final VerifyAssertionRequest aXm;

        public zzh(@NonNull AuthCredential authCredential) {
            super(2);
            zzaa.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aXm = zzahr.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zza(this.aXm, (zzahh)this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD);
            if (this.aXy.getUid().equalsIgnoreCase(zzahv2.getUid())) {
                ((zzahq)this.aXA).zza(this.aXC, zzahv2);
                this.zzcpm();
            } else {
                this.zzfd(zzahx.zzcqh());
            }
        }
    }

    static final class zzn
    extends zzahm<AuthResult, zzahq> {
        @NonNull
        private final VerifyAssertionRequest aXm;

        public zzn(@NonNull AuthCredential authCredential) {
            super(2);
            zzaa.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.aXm = zzahr.zza((AuthCredential)authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zza(this.aXm, (zzahh)this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD);
            ((zzahq)this.aXA).zza(this.aXC, zzahv2);
            this.zzbe(new zzahs(zzahv2));
        }
    }

    static final class zzo
    extends zzahm<AuthResult, zzahq> {
        @NonNull
        private final String hN;

        public zzo(@NonNull String string) {
            super(2);
            this.hN = zzaa.zzh((String)string, (Object)"token cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zzb(this.hN, this.aXx);
        }

        @Override
        public void zzcpf() {
            zzahv zzahv2 = zzahb.zza(this.aWU, this.aXD);
            ((zzahq)this.aXA).zza(this.aXC, zzahv2);
            this.zzbe(new zzahs(zzahv2));
        }
    }

    static final class zzd
    extends zzahm<GetTokenResult, zzahq> {
        @NonNull
        private final String aXk;

        public zzd(@NonNull String string) {
            super(1);
            this.aXk = zzaa.zzh((String)string, (Object)"refresh token cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.aXz.zza(this.aXk, (zzahh)this.aXx);
        }

        @Override
        public void zzcpf() {
            this.aXC.zzrv(this.aXk);
            ((zzahq)this.aXA).zza(this.aXC, this.aXy);
            this.zzbe(new GetTokenResult(this.aXC.getAccessToken()));
        }
    }
}

