/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzahb;
import com.google.android.gms.internal.zzahe;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzahq;
import com.google.android.gms.internal.zzahs;
import com.google.android.gms.internal.zzahu;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzahy;
import com.google.android.gms.internal.zzahz;
import com.google.android.gms.internal.zzaia;
import com.google.android.gms.internal.zzans;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.model.GetTokenResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FirebaseAuth
implements zzans {
    private FirebaseApp aWU;
    private List<AuthStateListener> mListeners;
    private zzahb aWV;
    private FirebaseUser aWW;
    private zzahz aWX;
    private zzaia aWY;
    private static Map<String, FirebaseAuth> aic = new ArrayMap();
    private static FirebaseAuth aWZ;

    public static FirebaseAuth getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        return FirebaseAuth.zzc(firebaseApp);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzc(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, FirebaseAuth.zzb(firebaseApp), new zzahz(firebaseApp.getApplicationContext(), firebaseApp.zzcnv(), zzahg.zzcph()));
    }

    FirebaseAuth(FirebaseApp firebaseApp, zzahb zzahb2, zzahz zzahz2) {
        this.aWU = (FirebaseApp)zzaa.zzy((Object)firebaseApp);
        this.aWV = (zzahb)((Object)zzaa.zzy((Object)((Object)zzahb2)));
        this.aWX = (zzahz)zzaa.zzy((Object)zzahz2);
        this.mListeners = new CopyOnWriteArrayList<AuthStateListener>();
        this.aWY = zzaia.zzcqk();
        this.zzcou();
    }

    static zzahb zzb(FirebaseApp firebaseApp) {
        zzahj.zza zza2 = new zzahj.zza.zza(firebaseApp.getOptions().getApiKey()).zzcpl();
        return zzahj.zza(firebaseApp.getApplicationContext(), zza2);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.aWW;
    }

    public void zza(@NonNull FirebaseUser firebaseUser, boolean bl, boolean bl2) {
        zzaa.zzy((Object)firebaseUser);
        if (this.aWW == null) {
            this.aWW = firebaseUser;
        } else {
            this.aWW.zzcu(firebaseUser.isAnonymous());
            this.aWW.zzaq(firebaseUser.getProviderData());
        }
        if (bl) {
            this.aWX.zzf(this.aWW);
        }
        if (bl2) {
            this.zza(this.aWW);
        }
    }

    public void zza(@NonNull FirebaseUser firebaseUser, @NonNull GetTokenResponse getTokenResponse, boolean bl) {
        boolean bl2;
        zzaa.zzy((Object)firebaseUser);
        zzaa.zzy((Object)getTokenResponse);
        if (this.aWW == null) {
            bl2 = true;
        } else {
            String string;
            GetTokenResponse getTokenResponse2 = this.aWW.zzcox();
            String string2 = getTokenResponse2.getAccessToken();
            boolean bl3 = !string2.equals(string = getTokenResponse.getAccessToken());
            boolean bl4 = this.aWW.getUid().equals(firebaseUser.getUid());
            bl2 = !bl4 || bl3;
        }
        if (bl2) {
            if (this.aWW != null) {
                this.aWW.zza(getTokenResponse);
            }
            this.zza(firebaseUser, bl, false);
            this.zza(this.aWW);
        }
        if (bl) {
            this.aWX.zza(firebaseUser, getTokenResponse);
        }
    }

    public void zzcot() {
        if (this.aWW != null) {
            this.aWX.zzh(this.aWW);
            this.aWW = null;
        }
        this.aWX.zzcqj();
        this.zza(null);
    }

    private static FirebaseAuth zzc(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzd(firebaseApp);
    }

    private static synchronized FirebaseAuth zzd(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = aic.get(firebaseApp.zzcnv());
        if (firebaseAuth == null) {
            firebaseAuth = new zzahu(firebaseApp);
            firebaseApp.zza((zzans)firebaseAuth);
            if (aWZ == null) {
                aWZ = firebaseAuth;
            }
            aic.put(firebaseApp.zzcnv(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addAuthStateListener(final @NonNull AuthStateListener authStateListener) {
        this.mListeners.add(authStateListener);
        this.aWY.execute(new Runnable(){

            @Override
            public void run() {
                authStateListener.onAuthStateChanged(FirebaseAuth.this);
            }
        });
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.mListeners.remove(authStateListener);
    }

    public void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(36 + String.valueOf(string).length()).append("Notifying listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzcoz() : null;
        final zzant zzant2 = new zzant(string);
        this.aWY.execute(new Runnable(){

            @Override
            public void run() {
                FirebaseAuth.this.aWU.zza(zzant2);
                for (AuthStateListener authStateListener : FirebaseAuth.this.mListeners) {
                    authStateListener.onAuthStateChanged(FirebaseAuth.this);
                }
            }
        });
    }

    @NonNull
    public Task<GetTokenResult> zzct(boolean bl) {
        return this.zza(this.aWW, bl);
    }

    @NonNull
    public Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzahe.zzfc(new Status(17495)));
        }
        GetTokenResponse getTokenResponse = this.aWW.zzcox();
        if (getTokenResponse.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(getTokenResponse.getAccessToken()));
        }
        return this.aWV.zza(this.aWU, firebaseUser, getTokenResponse.zzcpu(), new zzahq(){

            @Override
            public void zza(@NonNull GetTokenResponse getTokenResponse, @NonNull FirebaseUser firebaseUser) {
                FirebaseAuth.this.zza(firebaseUser, getTokenResponse, true);
            }
        });
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzaa.zzy((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.aWV.zzb(this.aWU, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzahq)new zza());
        }
        return this.aWV.zza(this.aWU, authCredential, (zzahq)new zza());
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzaa.zzy((Object)firebaseUser);
        zzaa.zzy((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.aWV.zza(this.aWU, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza());
        }
        return this.aWV.zza(this.aWU, firebaseUser, authCredential, (zzahq)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzaa.zzib((String)string);
        return this.aWV.zza(this.aWU, string, (zzahq)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzaa.zzib((String)string);
        zzaa.zzib((String)string2);
        return this.aWV.zzb(this.aWU, string, string2, (zzahq)new zza());
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.aWW != null && this.aWW.isAnonymous()) {
            zzahv zzahv2 = (zzahv)this.aWW;
            zzahs zzahs2 = new zzahs(zzahv2);
            return Tasks.forResult((Object)zzahs2);
        }
        return this.aWV.zza(this.aWU, new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        zzaa.zzy((Object)firebaseUser);
        return this.aWV.zzb(this.aWU, firebaseUser, new zza());
    }

    @NonNull
    public Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzaa.zzy((Object)authCredential);
        zzaa.zzy((Object)firebaseUser);
        return this.aWV.zzb(this.aWU, firebaseUser, authCredential, (zzahq)new zza());
    }

    @NonNull
    public Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzaa.zzib((String)string);
        zzaa.zzy((Object)firebaseUser);
        return this.aWV.zzd(this.aWU, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzaa.zzib((String)string);
        zzaa.zzib((String)string2);
        return this.aWV.zza(this.aWU, string, string2, (zzahq)new zza());
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzaa.zzib((String)string);
        return this.aWV.zza(this.aWU, string);
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzaa.zzy((Object)firebaseUser);
        zzaa.zzy((Object)userProfileChangeRequest);
        return this.aWV.zza(this.aWU, firebaseUser, userProfileChangeRequest, (zzahq)new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzaa.zzy((Object)firebaseUser);
        zzaa.zzib((String)string);
        return this.aWV.zzb(this.aWU, firebaseUser, string, (zzahq)new zza());
    }

    @NonNull
    public Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzaa.zzy((Object)firebaseUser);
        zzaa.zzib((String)string);
        return this.aWV.zzc(this.aWU, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzaa.zzib((String)string);
        return this.aWV.zzb(this.aWU, string);
    }

    @NonNull
    public Task<Void> zzru(@NonNull String string) {
        zzaa.zzib((String)string);
        return this.aWV.zzc(this.aWU, string);
    }

    @NonNull
    public Task<Void> zzc(final @NonNull FirebaseUser firebaseUser) {
        zzaa.zzy((Object)firebaseUser);
        return this.aWV.zza(firebaseUser, new zzahy(){

            public void zzcov() {
                if (FirebaseAuth.this.aWW.getUid().equalsIgnoreCase(firebaseUser.getUid())) {
                    FirebaseAuth.this.zzcot();
                }
            }
        });
    }

    public void signOut() {
        this.zzcot();
    }

    protected void zzcou() {
        GetTokenResponse getTokenResponse;
        this.aWW = this.aWX.zzcqi();
        if (this.aWW != null && (getTokenResponse = this.aWX.zzg(this.aWW)) != null) {
            this.zza(this.aWW, getTokenResponse, false);
        }
    }

    class zza
    implements zzahq {
        zza() {
        }

        @Override
        public void zza(@NonNull GetTokenResponse getTokenResponse, @NonNull FirebaseUser firebaseUser) {
            zzaa.zzy((Object)getTokenResponse);
            zzaa.zzy((Object)firebaseUser);
            firebaseUser.zza(getTokenResponse);
            FirebaseAuth.this.zza(firebaseUser, getTokenResponse, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }
}

