/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.components.ComponentFactory;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.zza;
import com.google.firebase.components.zzb;
import com.google.firebase.components.zzk;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@KeepForSdk
public final class Component<T> {
    private final Set<Class<? super T>> zzab;
    private final Set<Dependency> zzac;
    private final int zzad;
    private final ComponentFactory<T> zzae;

    private Component(Set<Class<? super T>> set, Set<Dependency> set2, int n, ComponentFactory<T> componentFactory) {
        this.zzab = Collections.unmodifiableSet(set);
        this.zzac = Collections.unmodifiableSet(set2);
        this.zzad = n;
        this.zzae = componentFactory;
    }

    public final Set<Class<? super T>> zze() {
        return this.zzab;
    }

    public final Set<Dependency> zzf() {
        return this.zzac;
    }

    public final ComponentFactory<T> zzg() {
        return this.zzae;
    }

    public final boolean zzh() {
        return this.zzad == 1;
    }

    public final boolean zzi() {
        return this.zzad == 2;
    }

    public final String toString() {
        return "Component<" + Arrays.toString(this.zzab.toArray()) + ">{" + this.zzad + ", deps=" + Arrays.toString(this.zzac.toArray()) + "}";
    }

    @KeepForSdk
    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder((Class)clazz, new Class[0], null);
    }

    @KeepForSdk
    public static <T> Builder<T> builder(Class<T> clazz, Class<? super T> ... classArray) {
        return new Builder((Class)clazz, (Class[])classArray, null);
    }

    @KeepForSdk
    public static <T> Component<T> of(Class<T> clazz, T t) {
        return Component.builder(clazz).factory(new zza(t)).build();
    }

    /* synthetic */ Component(Set set, Set set2, int n, ComponentFactory componentFactory, zzb zzb2) {
        this(set, set2, n, componentFactory);
    }

    @KeepForSdk
    public static class Builder<T> {
        private final Set<Class<? super T>> zzab = new HashSet<Class<? super T>>();
        private final Set<Dependency> zzac = new HashSet<Dependency>();
        private int zzad = 0;
        private ComponentFactory<T> zzae;

        private Builder(Class<T> clazz, Class<? super T> ... classArray) {
            zzk.zza(clazz, "Null interface");
            this.zzab.add(clazz);
            Class<? super T>[] classArray2 = classArray;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                zzk.zza(classArray2[i], "Null interface");
            }
            Collections.addAll(this.zzab, classArray);
        }

        @KeepForSdk
        public Builder<T> add(Dependency dependency) {
            zzk.zza(dependency, "Null dependency");
            Class<?> clazz = dependency.zzn();
            String string = "Components are not allowed to depend on interfaces they themselves provide.";
            if (!(!this.zzab.contains(clazz))) {
                throw new IllegalArgumentException(string);
            }
            this.zzac.add(dependency);
            return this;
        }

        @KeepForSdk
        public Builder<T> alwaysEager() {
            return this.zza(1);
        }

        @KeepForSdk
        public Builder<T> eagerInDefaultApp() {
            return this.zza(2);
        }

        private final Builder<T> zza(int n) {
            zzk.checkState(this.zzad == 0, "Instantiation type has already been set.");
            this.zzad = n;
            return this;
        }

        @KeepForSdk
        public Builder<T> factory(ComponentFactory<T> componentFactory) {
            this.zzae = zzk.zza(componentFactory, "Null factory");
            return this;
        }

        @KeepForSdk
        public Component<T> build() {
            zzk.checkState(this.zzae != null, "Missing required property: factory.");
            return new Component(new HashSet<Class<? super T>>(this.zzab), new HashSet<Dependency>(this.zzac), this.zzad, this.zzae, null);
        }

        /* synthetic */ Builder(Class clazz, Class[] classArray, zzb zzb2) {
            this(clazz, classArray);
        }
    }
}

