/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.util.Log;
import com.google.firebase.components.ComponentDiscoveryService;
import com.google.firebase.components.zzd;
import com.google.firebase.components.zzf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class zze
implements zzf {
    private zze() {
    }

    @Override
    public final List<String> zzc(Context context) {
        Bundle bundle = zze.zzd(context);
        if (bundle == null) {
            Log.w((String)"ComponentDiscovery", (String)"Could not retrieve metadata, returning empty list of registrars.");
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : bundle.keySet()) {
            Object object = bundle.get(string);
            if (!"com.google.firebase.components.ComponentRegistrar".equals(object) || !string.startsWith("com.google.firebase.components:")) continue;
            arrayList.add(string.substring(31));
        }
        return arrayList;
    }

    private static Bundle zzd(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                Log.w((String)"ComponentDiscovery", (String)"Context has no PackageManager.");
                return null;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, ComponentDiscoveryService.class), 128);
            if (serviceInfo == null) {
                Log.w((String)"ComponentDiscovery", (String)"ComponentDiscoveryService has no service info.");
                return null;
            }
            return serviceInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"ComponentDiscovery", (String)"Application info not found.");
            return null;
        }
    }

    /* synthetic */ zze(zzd zzd2) {
        this();
    }
}

