/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public final class Dependency {
    private final Class<?> anInterface;
    private final int type;
    private final int injection;

    private Dependency(Class<?> anInterface, int type, int injection) {
        this.anInterface = (Class)Preconditions.checkNotNull(anInterface, (Object)"Null dependency anInterface.");
        this.type = type;
        this.injection = injection;
    }

    @KeepForSdk
    public static Dependency optional(Class<?> anInterface) {
        return new Dependency(anInterface, 0, 0);
    }

    @KeepForSdk
    public static Dependency required(Class<?> anInterface) {
        return new Dependency(anInterface, 1, 0);
    }

    @KeepForSdk
    public static Dependency optionalProvider(Class<?> anInterface) {
        return new Dependency(anInterface, 0, 1);
    }

    @KeepForSdk
    public static Dependency requiredProvider(Class<?> anInterface) {
        return new Dependency(anInterface, 1, 1);
    }

    public Class<?> getInterface() {
        return this.anInterface;
    }

    public boolean isRequired() {
        return this.type == 1;
    }

    public boolean isDirectInjection() {
        return this.injection == 0;
    }

    public boolean equals(Object o) {
        if (o instanceof Dependency) {
            Dependency other = (Dependency)o;
            return this.anInterface == other.anInterface && this.type == other.type && this.injection == other.injection;
        }
        return false;
    }

    public int hashCode() {
        int h = 1000003;
        h ^= this.anInterface.hashCode();
        h *= 1000003;
        h ^= this.type;
        h *= 1000003;
        return h ^= this.injection;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Dependency{anInterface=").append(this.anInterface).append(", required=").append(this.type == 1).append(", direct=").append(this.injection == 0).append("}");
        return sb.toString();
    }
}

