/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import android.support.annotation.VisibleForTesting;
import com.google.firebase.inject.Provider;

class Lazy<T>
implements Provider<T> {
    private static final Object UNINITIALIZED = new Object();
    private volatile Object instance = UNINITIALIZED;
    private volatile Provider<T> provider;

    Lazy(T instance) {
        this.instance = instance;
    }

    Lazy(Provider<T> provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object result = this.instance;
        if (result == UNINITIALIZED) {
            Lazy lazy = this;
            synchronized (lazy) {
                result = this.instance;
                if (result == UNINITIALIZED) {
                    this.instance = result = this.provider.get();
                    this.provider = null;
                }
            }
        }
        Object tResult = result;
        return (T)tResult;
    }

    @VisibleForTesting
    boolean isInitialized() {
        return this.instance != UNINITIALIZED;
    }
}

