/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.heartbeatinfo;

import android.content.Context;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.datastore.preferences.core.MutablePreferences;
import androidx.datastore.preferences.core.Preferences;
import androidx.datastore.preferences.core.PreferencesKeys;
import com.google.firebase.datastorage.JavaDataStorage;
import com.google.firebase.datastorage.JavaDataStorageKt;
import com.google.firebase.heartbeatinfo.HeartBeatResult;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

class HeartBeatInfoStorage {
    private static HeartBeatInfoStorage instance = null;
    private static final Preferences.Key<Long> GLOBAL = PreferencesKeys.longKey((String)"fire-global");
    private static final String PREFERENCES_NAME = "FirebaseAppHeartBeat";
    private static final String HEARTBEAT_PREFERENCES_NAME = "FirebaseHeartBeat";
    private static final Preferences.Key<Long> HEART_BEAT_COUNT_TAG = PreferencesKeys.longKey((String)"fire-count");
    private static final Preferences.Key<String> LAST_STORED_DATE = PreferencesKeys.stringKey((String)"last-used-date");
    private static final int HEART_BEAT_COUNT_LIMIT = 30;
    private final JavaDataStorage firebaseDataStore;

    public HeartBeatInfoStorage(Context applicationContext, String persistenceKey) {
        this.firebaseDataStore = new JavaDataStorage(applicationContext, HEARTBEAT_PREFERENCES_NAME + persistenceKey);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    HeartBeatInfoStorage(JavaDataStorage javaDataStorage) {
        this.firebaseDataStore = javaDataStorage;
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    int getHeartBeatCount() {
        return this.firebaseDataStore.getSync(HEART_BEAT_COUNT_TAG, 0L).intValue();
    }

    synchronized void deleteAllHeartBeats() {
        this.firebaseDataStore.editSync((Function1<? super MutablePreferences, Unit>)((Function1)pref -> {
            long counter = 0L;
            for (Map.Entry entry : pref.asMap().entrySet()) {
                String today;
                if (!(entry.getValue() instanceof Set)) continue;
                Preferences.Key key = (Preferences.Key)entry.getKey();
                Set dates = (Set)entry.getValue();
                if (dates.contains(today = this.getFormattedDate(System.currentTimeMillis()))) {
                    pref.set(key, Set.of(today));
                    ++counter;
                    continue;
                }
                pref.remove(key);
            }
            if (counter == 0L) {
                pref.remove(HEART_BEAT_COUNT_TAG);
            } else {
                pref.set(HEART_BEAT_COUNT_TAG, (Object)counter);
            }
            return null;
        }));
    }

    synchronized List<HeartBeatResult> getAllHeartBeats() {
        ArrayList<HeartBeatResult> heartBeatResults = new ArrayList<HeartBeatResult>();
        String today = this.getFormattedDate(System.currentTimeMillis());
        for (Map.Entry<Preferences.Key<?>, Object> entry : this.firebaseDataStore.getAllSync().entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            HashSet dates = new HashSet((Set)entry.getValue());
            dates.remove(today);
            if (dates.isEmpty()) continue;
            heartBeatResults.add(HeartBeatResult.create(entry.getKey().getName(), new ArrayList<String>(dates)));
        }
        this.updateGlobalHeartBeat(System.currentTimeMillis());
        return heartBeatResults;
    }

    private synchronized Preferences.Key<Set<String>> getStoredUserAgentString(MutablePreferences preferences, String dateString) {
        for (Map.Entry entry : preferences.asMap().entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            Set dateSet = (Set)entry.getValue();
            for (String date : dateSet) {
                if (!dateString.equals(date)) continue;
                return PreferencesKeys.stringSetKey((String)((Preferences.Key)entry.getKey()).getName());
            }
        }
        return null;
    }

    private synchronized void updateStoredUserAgent(MutablePreferences preferences, Preferences.Key<Set<String>> userAgent, String dateString) {
        this.removeStoredDate(preferences, dateString);
        HashSet<String> userAgentDateSet = new HashSet<String>(JavaDataStorageKt.getOrDefault((Preferences)preferences, userAgent, new HashSet()));
        userAgentDateSet.add(dateString);
        preferences.set(userAgent, userAgentDateSet);
    }

    private synchronized void removeStoredDate(MutablePreferences preferences, String dateString) {
        Preferences.Key<Set<String>> userAgent = this.getStoredUserAgentString(preferences, dateString);
        if (userAgent == null) {
            return;
        }
        HashSet userAgentDateSet = new HashSet(JavaDataStorageKt.getOrDefault((Preferences)preferences, userAgent, new HashSet()));
        userAgentDateSet.remove(dateString);
        if (userAgentDateSet.isEmpty()) {
            preferences.remove(userAgent);
        } else {
            preferences.set(userAgent, userAgentDateSet);
        }
    }

    synchronized void postHeartBeatCleanUp() {
        String dateString = this.getFormattedDate(System.currentTimeMillis());
        this.firebaseDataStore.editSync((Function1<? super MutablePreferences, Unit>)((Function1)pref -> {
            pref.set(LAST_STORED_DATE, (Object)dateString);
            this.removeStoredDate((MutablePreferences)pref, dateString);
            return null;
        }));
    }

    private synchronized String getFormattedDate(long millis) {
        if (Build.VERSION.SDK_INT >= 26) {
            Instant instant = new Date(millis).toInstant();
            LocalDateTime ldt = instant.atOffset(ZoneOffset.UTC).toLocalDateTime();
            return ldt.format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        return new SimpleDateFormat("yyyy-MM-dd", Locale.UK).format(new Date(millis));
    }

    synchronized void storeHeartBeat(long millis, String userAgentString) {
        String dateString = this.getFormattedDate(millis);
        Preferences.Key userAgent = PreferencesKeys.stringSetKey((String)userAgentString);
        this.firebaseDataStore.editSync((Function1<? super MutablePreferences, Unit>)((Function1)pref -> {
            String lastDateString = JavaDataStorageKt.getOrDefault((Preferences)pref, LAST_STORED_DATE, "");
            if (lastDateString.equals(dateString)) {
                Preferences.Key<Set<String>> storedUserAgent = this.getStoredUserAgentString((MutablePreferences)pref, dateString);
                if (storedUserAgent == null) {
                    return null;
                }
                if (storedUserAgent.getName().equals(userAgentString)) {
                    return null;
                }
                this.updateStoredUserAgent((MutablePreferences)pref, (Preferences.Key<Set<String>>)userAgent, dateString);
                return null;
            }
            long heartBeatCount = JavaDataStorageKt.getOrDefault((Preferences)pref, HEART_BEAT_COUNT_TAG, 0L);
            if (heartBeatCount + 1L == 30L) {
                heartBeatCount = this.cleanUpStoredHeartBeats((MutablePreferences)pref);
            }
            HashSet<String> userAgentDateSet = new HashSet<String>(JavaDataStorageKt.getOrDefault((Preferences)pref, userAgent, new HashSet()));
            userAgentDateSet.add(dateString);
            pref.set(userAgent, userAgentDateSet);
            pref.set(HEART_BEAT_COUNT_TAG, (Object)(++heartBeatCount));
            pref.set(LAST_STORED_DATE, (Object)dateString);
            return null;
        }));
    }

    private synchronized long cleanUpStoredHeartBeats(MutablePreferences preferences) {
        long heartBeatCount = JavaDataStorageKt.getOrDefault((Preferences)preferences, HEART_BEAT_COUNT_TAG, 0L);
        String lowestDate = null;
        String userAgentString = "";
        Set userAgentDateSet = new HashSet();
        for (Map.Entry entry : preferences.asMap().entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            Set dateSet = (Set)entry.getValue();
            for (String date : dateSet) {
                if (lowestDate != null && lowestDate.compareTo(date) <= 0) continue;
                userAgentDateSet = dateSet;
                lowestDate = date;
                userAgentString = ((Preferences.Key)entry.getKey()).getName();
            }
        }
        userAgentDateSet = new HashSet(userAgentDateSet);
        userAgentDateSet.remove(lowestDate);
        preferences.set(PreferencesKeys.stringSetKey((String)userAgentString), userAgentDateSet);
        preferences.set(HEART_BEAT_COUNT_TAG, (Object)(heartBeatCount - 1L));
        return heartBeatCount - 1L;
    }

    synchronized long getLastGlobalHeartBeat() {
        return this.firebaseDataStore.getSync(GLOBAL, -1L);
    }

    synchronized void updateGlobalHeartBeat(long millis) {
        this.firebaseDataStore.editSync((Function1<? super MutablePreferences, Unit>)((Function1)pref -> {
            pref.set(GLOBAL, (Object)millis);
            return null;
        }));
    }

    synchronized boolean isSameDateUtc(long base, long target) {
        return this.getFormattedDate(base).equals(this.getFormattedDate(target));
    }

    synchronized boolean shouldSendSdkHeartBeat(Preferences.Key<Long> heartBeatTag, long millis) {
        if (this.isSameDateUtc(this.firebaseDataStore.getSync(heartBeatTag, -1L), millis)) {
            return false;
        }
        this.firebaseDataStore.putSync(heartBeatTag, millis);
        return true;
    }

    synchronized boolean shouldSendGlobalHeartBeat(long millis) {
        return this.shouldSendSdkHeartBeat(GLOBAL, millis);
    }
}

