/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzaas;
import com.google.android.gms.internal.zzacy;
import com.google.android.gms.internal.zzacz;
import com.google.android.gms.internal.zzada;
import com.google.android.gms.internal.zzadb;
import com.google.android.gms.internal.zzadd;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzadh;
import com.google.android.gms.internal.zzadj;
import com.google.android.gms.internal.zzadl;
import com.google.android.gms.internal.zzadn;
import com.google.android.gms.internal.zzado;
import com.google.android.gms.internal.zzadp;
import com.google.android.gms.internal.zzzv;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class zzade
implements zzacz {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzaHr = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzaHs = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public PendingResult<zzacz.zzb> zza(GoogleApiClient googleApiClient, final zzacz.zza zza2) {
        if (googleApiClient == null || zza2 == null) {
            return null;
        }
        return googleApiClient.zza((zzzv.zza)new zzc(this, googleApiClient){

            @Override
            protected void zza(Context context, zzado zzado2) throws RemoteException {
                String string;
                String string2;
                String string3;
                DataHolder dataHolder;
                block3: {
                    DataHolder.zza zza22 = com.google.android.gms.common.data.zzd.zzwC();
                    for (Map.Entry<String, String> object2 : zza2.zzyR().entrySet()) {
                        com.google.android.gms.common.data.zzd.zza((DataHolder.zza)zza22, (SafeParcelable)new zzadh(object2.getKey(), object2.getValue()));
                    }
                    dataHolder = zza22.zzcE(0);
                    string3 = zzaas.zzay((Context)context) == Status.zzayh ? zzaas.zzwj() : null;
                    string2 = null;
                    string = null;
                    try {
                        string2 = com.google.firebase.iid.zzc.zzaab().getId();
                        string = com.google.firebase.iid.zzc.zzaab().getToken();
                    }
                    catch (IllegalStateException list) {
                        if (!Log.isLoggable((String)"ConfigApiImpl", (int)3)) break block3;
                        Log.d((String)"ConfigApiImpl", (String)"Cannot retrieve instanceId or instanceIdToken.", (Throwable)list);
                    }
                }
                List<zzadb> list = zzadd.zzaS(context);
                zzadj zzadj2 = new zzadj(context.getPackageName(), zza2.zzyQ(), dataHolder, string3, string2, string, null, zza2.zzyS(), list);
                zzado2.zza(this.zzaHu, zzadj2);
                dataHolder.close();
            }

            protected zzacz.zzb zzH(Status status) {
                return new zzd(status, new HashMap<String, TreeMap<String, byte[]>>());
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzH(status);
            }
        });
    }

    private static Status zzdn(int n) {
        return new Status(n, zzada.getStatusCodeString(n));
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(zzadl zzadl2) {
        if (zzadl2 == null) {
            return null;
        }
        DataHolder dataHolder = zzadl2.zzzb();
        if (dataHolder == null) {
            return null;
        }
        com.google.android.gms.common.data.zzd zzd2 = new com.google.android.gms.common.data.zzd(dataHolder, zzadp.CREATOR);
        zzadp zzadp2 = (zzadp)((Object)zzd2.get(0));
        zzadl2.zzzc();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : zzadp2.zzzd().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = zzadp2.zzzd().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    static abstract class zzc
    extends zzb<zzacz.zzb> {
        protected zzadn zzaHu = new zza(){

            @Override
            public void zza(Status status, zzadl zzadl2) {
                if (zzadl2.getStatusCode() == 6502 || zzadl2.getStatusCode() == 6507) {
                    zzc.this.zzb(new zzd(zzade.zzdn(zzadl2.getStatusCode()), zzade.zza(zzadl2), zzadl2.getThrottleEndTimeMillis()));
                } else {
                    zzc.this.zzb(new zzd(zzade.zzdn(zzadl2.getStatusCode()), zzade.zza(zzadl2)));
                }
            }
        };

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }
    }

    public static class zzd
    implements zzacz.zzb {
        private final Map<String, TreeMap<String, byte[]>> zzaHw;
        private final Status zzahq;
        private final long zzaHx;

        public zzd(Status status, Map<String, TreeMap<String, byte[]>> map) {
            this(status, map, -1L);
        }

        public zzd(Status status, Map<String, TreeMap<String, byte[]>> map, long l) {
            this.zzahq = status;
            this.zzaHw = map;
            this.zzaHx = l;
        }

        @Override
        public long getThrottleEndTimeMillis() {
            return this.zzaHx;
        }

        @Override
        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public byte[] zza(String string, byte[] byArray, String string2) {
            if (this.zzH(string, string2)) {
                return this.zzaHw.get(string2).get(string);
            }
            return byArray;
        }

        public boolean zzH(String string, String string2) {
            if (this.zzaHw == null || this.zzaHw.get(string2) == null) {
                return false;
            }
            return this.zzaHw.get(string2).get(string) != null;
        }

        @Override
        public Map<String, Set<String>> zzyU() {
            HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
            if (this.zzaHw != null) {
                for (String string : this.zzaHw.keySet()) {
                    Map map = this.zzaHw.get(string);
                    if (map == null) continue;
                    hashMap.put(string, map.keySet());
                }
            }
            return hashMap;
        }
    }

    static abstract class zzb<R extends Result>
    extends zzzv.zza<R, zzadg> {
        public zzb(GoogleApiClient googleApiClient) {
            super(zzacy.API, googleApiClient);
        }

        protected final void zza(zzadg zzadg2) throws RemoteException {
            this.zza(zzadg2.getContext(), (zzado)zzadg2.zzwW());
        }

        protected abstract void zza(Context var1, zzado var2) throws RemoteException;
    }

    static abstract class zza
    extends zzadn.zza {
        zza() {
        }

        @Override
        public void zza(Status status, byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zza(Status status, Map map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zzI(Status status) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zza(Status status, zzadl zzadl2) {
            throw new UnsupportedOperationException();
        }
    }
}

