/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzacz;
import com.google.android.gms.internal.zzadf;
import com.google.android.gms.internal.zzbqo;
import com.google.android.gms.internal.zzbqp;
import com.google.android.gms.internal.zzbqq;
import com.google.android.gms.internal.zzbqr;
import com.google.android.gms.internal.zzbqs;
import com.google.android.gms.internal.zzbqt;
import com.google.android.gms.internal.zzbqu;
import com.google.android.gms.internal.zzbul;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzcjz;
    private zzbqq zzcjA;
    private zzbqq zzcjB;
    private zzbqq zzcjC;
    private zzbqt zzcjD;
    private final Context mContext;
    private final ReadWriteLock zzcjE = new ReentrantReadWriteLock(true);

    FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzbqq zzbqq2, zzbqq zzbqq3, zzbqq zzbqq4, zzbqt zzbqt2) {
        this.mContext = context;
        this.zzcjD = zzbqt2 != null ? zzbqt2 : new zzbqt();
        this.zzcjD.zzaS(this.zzcc(this.mContext));
        if (zzbqq2 != null) {
            this.zzcjA = zzbqq2;
        }
        if (zzbqq3 != null) {
            this.zzcjB = zzbqq3;
        }
        if (zzbqq4 != null) {
            this.zzcjC = zzbqq4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzcjz == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            return FirebaseRemoteConfig.zzcb(context);
        }
        return zzcjz;
    }

    public static FirebaseRemoteConfig zzcb(Context context) {
        if (zzcjz == null) {
            zzbqu.zze zze2 = FirebaseRemoteConfig.zzcd(context);
            if (zze2 == null) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                }
                zzcjz = new FirebaseRemoteConfig(context);
            } else {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                }
                zzbqq zzbqq2 = FirebaseRemoteConfig.zza(zze2.zzckb);
                zzbqq zzbqq3 = FirebaseRemoteConfig.zza(zze2.zzckc);
                zzbqq zzbqq4 = FirebaseRemoteConfig.zza(zze2.zzckd);
                zzbqt zzbqt2 = FirebaseRemoteConfig.zza(zze2.zzcke);
                if (zzbqt2 != null) {
                    zzbqt2.zzaH(FirebaseRemoteConfig.zza(zze2.zzckf));
                }
                zzcjz = new FirebaseRemoteConfig(context, zzbqq2, zzbqq3, zzbqq4, zzbqt2);
            }
        }
        return zzcjz;
    }

    private long zzcc(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf(context.getPackageName());
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zzbqu.zze zzcd(Context context) {
        zzbqu.zze zze2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            zzbul zzbul2 = zzbul.zzad((byte[])FirebaseRemoteConfig.zzl(fileInputStream));
            zze2 = new zzbqu.zze();
            zze2.zzb(zzbul2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zze2;
    }

    private static Map<String, zzbqo> zza(zzbqu.zzf[] zzfArray) {
        HashMap<String, zzbqo> hashMap = new HashMap<String, zzbqo>();
        if (zzfArray == null) {
            return hashMap;
        }
        for (zzbqu.zzf zzf2 : zzfArray) {
            String string = zzf2.zzaFs;
            int n = zzf2.resourceId;
            long l = zzf2.zzckh;
            hashMap.put(string, new zzbqo(n, l));
        }
        return hashMap;
    }

    private static zzbqt zza(zzbqu.zzc zzc2) {
        if (zzc2 == null) {
            return null;
        }
        zzbqt zzbqt2 = new zzbqt();
        zzbqt2.zzpV(zzc2.zzcjX);
        zzbqt2.zzbc(zzc2.zzcjY);
        return zzbqt2;
    }

    private static zzbqq zza(zzbqu.zza zza2) {
        zzbqu.zzd[] zzdArray;
        if (zza2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        for (zzbqu.zzd zzd2 : zzdArray = zza2.zzcjU) {
            String string = zzd2.zzaFs;
            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
            for (zzbqu.zzb zzb2 : zzd2.zzcka) {
                hashMap2.put(zzb2.zzaA, zzb2.zzcjW);
            }
            hashMap.put(string, hashMap2);
        }
        return new zzbqq(hashMap, zza2.timestamp);
    }

    private static byte[] zzl(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FirebaseRemoteConfig.zzb(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static long zzb(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateFetched() {
        this.zzcjE.writeLock().lock();
        try {
            if (this.zzcjA == null) {
                return false;
            }
            if (this.zzcjB != null && this.zzcjB.getTimestamp() >= this.zzcjA.getTimestamp()) {
                return false;
            }
            long l = this.zzcjA.getTimestamp();
            this.zzcjB = this.zzcjA;
            this.zzcjB.setTimestamp(System.currentTimeMillis());
            this.zzcjA = new zzbqq(null, l);
            this.zzaas();
            return true;
        }
        finally {
            this.zzcjE.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzcjE.readLock().lock();
        try {
            if (this.zzcjD != null && this.zzcjD.zzaay() != null && this.zzcjD.zzaay().get(string) != null && n == ((zzbqo)(object = this.zzcjD.zzaay().get(string))).zzaat() && this.zzcjD.zzaaz() == ((zzbqo)object).zzaau()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzcjE.readLock().unlock();
        }
        object = new HashMap();
        try {
            Resources resources = this.mContext.getResources();
            XmlResourceParser xmlResourceParser = resources.getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzbqo zzbqo2 = new zzbqo(n, this.zzcjD.zzaaz());
            this.zzcjD.zza(string, zzbqo2);
            this.zzc((Map<String, Object>)object, string, false);
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzbqs.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzbqs.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzbqs.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzbqs.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzbqs.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzbqs.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzcjE.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzcjC == null || !this.zzcjC.zzjG(string)) {
                    return;
                }
                this.zzcjC.zzj(null, string);
                this.zzcjC.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzcjC == null) {
                    this.zzcjC = new zzbqq(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis());
                }
                this.zzcjC.zzj(hashMap, string);
                this.zzcjC.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzcjD.zzjH(string);
            }
            this.zzaas();
        }
        finally {
            this.zzcjE.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzcjE.writeLock().lock();
        try {
            boolean bl = this.zzcjD.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzcjD.zzbc(bl2);
            if (bl != bl2) {
                this.zzaas();
            }
        }
        finally {
            this.zzcjE.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzcjE.readLock().lock();
        try {
            if (this.zzcjB != null && this.zzcjB.zzav(string, string2)) {
                byte[] byArray = this.zzcjB.zzaw(string, string2);
                return byArray;
            }
            if (this.zzcjC != null && this.zzcjC.zzav(string, string2)) {
                byte[] byArray = this.zzcjC.zzaw(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzcjE.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_STRING;
        }
        this.zzcjE.readLock().lock();
        try {
            if (this.zzcjB != null && this.zzcjB.zzav(string, string2)) {
                String string3 = new String(this.zzcjB.zzaw(string, string2), zzbqs.UTF_8);
                return string3;
            }
            if (this.zzcjC != null && this.zzcjC.zzav(string, string2)) {
                String string4 = new String(this.zzcjC.zzaw(string, string2), zzbqs.UTF_8);
                return string4;
            }
            String string5 = DEFAULT_VALUE_FOR_STRING;
            return string5;
        }
        finally {
            this.zzcjE.readLock().unlock();
        }
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzcjE.readLock().lock();
        try {
            String string3;
            if (this.zzcjB != null && this.zzcjB.zzav(string, string2)) {
                string3 = new String(this.zzcjB.zzaw(string, string2), zzbqs.UTF_8);
                if (zzbqs.zzaHr.matcher(string3).matches()) {
                    return true;
                }
                if (zzbqs.zzaHs.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzcjC != null && this.zzcjC.zzav(string, string2)) {
                string3 = new String(this.zzcjC.zzaw(string, string2), zzbqs.UTF_8);
                if (zzbqs.zzaHr.matcher(string3).matches()) {
                    return true;
                }
                if (zzbqs.zzaHs.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzcjE.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzbqs(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzcjE.readLock().lock();
        try {
            if (this.zzcjB != null && this.zzcjB.zzav(string, string2)) {
                zzbqs zzbqs2 = new zzbqs(this.zzcjB.zzaw(string, string2), 2);
                return zzbqs2;
            }
            if (this.zzcjC != null && this.zzcjC.zzav(string, string2)) {
                zzbqs zzbqs3 = new zzbqs(this.zzcjC.zzaw(string, string2), 1);
                return zzbqs3;
            }
            zzbqs zzbqs4 = new zzbqs(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzbqs4;
        }
        finally {
            this.zzcjE.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigInfo getInfo() {
        zzbqr zzbqr2 = new zzbqr();
        this.zzcjE.readLock().lock();
        try {
            long l = this.zzcjA == null ? -1L : this.zzcjA.getTimestamp();
            zzbqr2.zzaR(l);
            zzbqr2.zzpV(this.zzcjD.getLastFetchStatus());
            zzbqr2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzcjD.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzcjE.readLock().unlock();
        }
        return zzbqr2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzcjE.readLock().lock();
        try {
            if (this.zzcjB == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzcjB.zzax(string, string2);
            return set;
        }
        finally {
            this.zzcjE.readLock().unlock();
        }
    }

    private void zzaas() {
        this.zzcjE.readLock().lock();
        try {
            zzbqp zzbqp2 = new zzbqp(this.mContext, this.zzcjA, this.zzcjB, this.zzcjC, this.zzcjD);
            if (Build.VERSION.SDK_INT >= 11) {
                AsyncTask.SERIAL_EXECUTOR.execute(zzbqp2);
            } else {
                new zza().execute(zzbqp2);
            }
        }
        finally {
            this.zzcjE.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> fetch(long l) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzcjE.readLock().lock();
        try {
            zzacz.zza.zza zza2 = new zzacz.zza.zza();
            zza2.zzJ(l);
            if (this.zzcjD.isDeveloperModeEnabled()) {
                zza2.zzG("_rcn_developer", "true");
            }
            zza2.zzdl(10200);
            PendingResult<zzacz.zzb> pendingResult = new zzadf(this.mContext).zza(zza2.zzyT());
            pendingResult.setResultCallback((ResultCallback)new ResultCallback<zzacz.zzb>(){

                public void zza(@NonNull zzacz.zzb zzb2) {
                    FirebaseRemoteConfig.this.zza((TaskCompletionSource<Void>)taskCompletionSource, zzb2);
                }

                public /* synthetic */ void onResult(@NonNull Result result) {
                    this.zza((zzacz.zzb)result);
                }
            });
        }
        finally {
            this.zzcjE.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    void zza(TaskCompletionSource<Void> taskCompletionSource, zzacz.zzb zzb2) {
        if (zzb2 == null || zzb2.getStatus() == null) {
            this.zzcjD.zzpV(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzaas();
            return;
        }
        int n = zzb2.getStatus().getStatusCode();
        this.zzcjE.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzcjD.zzpV(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzaas();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzcjD.zzpV(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzb2.getThrottleEndTimeMillis())));
                    this.zzaas();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzcjD.zzpV(-1);
                    if (this.zzcjA != null && !this.zzcjA.zzaaw()) {
                        Map<String, Set<String>> map = zzb2.zzyU();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzb2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzcjA = new zzbqq(hashMap, this.zzcjA.getTimestamp());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzaas();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzb2.zzyU();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzb2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzcjA = new zzbqq(hashMap, System.currentTimeMillis());
                    this.zzcjD.zzpV(-1);
                    taskCompletionSource.setResult(null);
                    this.zzaas();
                    return;
                }
                default: {
                    if (zzb2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzcjD.zzpV(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzaas();
                    return;
                }
            }
        }
        finally {
            this.zzcjE.writeLock().unlock();
        }
    }

    static class zza
    implements Executor {
        zza() {
        }

        @Override
        public void execute(Runnable runnable) {
            new Thread(runnable).start();
        }
    }
}

