/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzd;
import com.google.android.gms.internal.zzbds;
import com.google.android.gms.internal.zzbdu;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbeb;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbep;
import com.google.android.gms.internal.zzbev;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class zzbea
implements zzbds {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzfzv = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzfzw = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public final PendingResult<zzbdw> zza(GoogleApiClient googleApiClient, zzbdu zzbdu2) {
        if (googleApiClient == null || zzbdu2 == null) {
            return null;
        }
        return googleApiClient.zzd((zzm)new zzbeb(this, googleApiClient, zzbdu2));
    }

    private static Status zzck(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 6500: {
                string = "NOT_AUTHORIZED_TO_FETCH";
                break;
            }
            case 6501: {
                string = "ANOTHER_FETCH_INFLIGHT";
                break;
            }
            case 6502: {
                string = "FETCH_THROTTLED";
                break;
            }
            case 6503: {
                string = "NOT_AVAILABLE";
                break;
            }
            case 6504: {
                string = "FAILURE_CACHE";
                break;
            }
            case -6505: {
                string = "SUCCESS_FRESH";
                break;
            }
            case -6506: {
                string = "SUCCESS_CACHE";
                break;
            }
            case 6507: {
                string = "FETCH_THROTTLED_STALE";
                break;
            }
            case -6508: {
                string = "SUCCESS_CACHE_STALE";
                break;
            }
            default: {
                string = CommonStatusCodes.getStatusCodeString((int)n2);
            }
        }
        return new Status(n, string);
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(zzbep zzbep2) {
        if (zzbep2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbep2.zzalz();
        if (dataHolder == null) {
            return null;
        }
        zzbev zzbev2 = (zzbev)((Object)new zzd(dataHolder, zzbev.CREATOR).get(0));
        zzbep2.zzamb();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : zzbev2.zzamd().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = zzbev2.zzamd().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    @Nullable
    static List<byte[]> zzb(@Nullable zzbep zzbep2) {
        if (zzbep2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbep2.zzama();
        if (dataHolder == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator iterator = new zzd(dataHolder, zzbej.CREATOR).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((zzbej)((Object)iterator.next())).getPayload());
        }
        zzbep2.zzamc();
        return arrayList;
    }

    static /* synthetic */ Status zzcl(int n) {
        return zzbea.zzck(n);
    }

    static /* synthetic */ HashMap zzc(zzbep zzbep2) {
        return zzbea.zza(zzbep2);
    }
}

