/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzd;
import com.google.android.gms.internal.zzbgf;
import com.google.android.gms.internal.zzbgh;
import com.google.android.gms.internal.zzbgj;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgw;
import com.google.android.gms.internal.zzbhc;
import com.google.android.gms.internal.zzbhi;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class zzbgn
implements zzbgf {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzgdf = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzgdg = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public final PendingResult<zzbgj> zza(GoogleApiClient googleApiClient, zzbgh zzbgh2) {
        if (googleApiClient == null || zzbgh2 == null) {
            return null;
        }
        return googleApiClient.zzd((zzm)new zzbgo(this, googleApiClient, zzbgh2));
    }

    private static Status zzco(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 6500: {
                string = "NOT_AUTHORIZED_TO_FETCH";
                break;
            }
            case 6501: {
                string = "ANOTHER_FETCH_INFLIGHT";
                break;
            }
            case 6502: {
                string = "FETCH_THROTTLED";
                break;
            }
            case 6503: {
                string = "NOT_AVAILABLE";
                break;
            }
            case 6504: {
                string = "FAILURE_CACHE";
                break;
            }
            case -6505: {
                string = "SUCCESS_FRESH";
                break;
            }
            case -6506: {
                string = "SUCCESS_CACHE";
                break;
            }
            case 6507: {
                string = "FETCH_THROTTLED_STALE";
                break;
            }
            case -6508: {
                string = "SUCCESS_CACHE_STALE";
                break;
            }
            default: {
                string = CommonStatusCodes.getStatusCodeString((int)n2);
            }
        }
        return new Status(n, string);
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(zzbhc zzbhc2) {
        if (zzbhc2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbhc2.zzams();
        if (dataHolder == null) {
            return null;
        }
        zzbhi zzbhi2 = (zzbhi)((Object)new zzd(dataHolder, zzbhi.CREATOR).get(0));
        zzbhc2.zzamu();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : zzbhi2.zzamw().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = zzbhi2.zzamw().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    @Nullable
    static List<byte[]> zzb(@Nullable zzbhc zzbhc2) {
        if (zzbhc2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbhc2.zzamt();
        if (dataHolder == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator iterator = new zzd(dataHolder, zzbgw.CREATOR).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((zzbgw)((Object)iterator.next())).getPayload());
        }
        zzbhc2.zzamv();
        return arrayList;
    }

    static /* synthetic */ Status zzcp(int n) {
        return zzbgn.zzco(n);
    }

    static /* synthetic */ HashMap zzc(zzbhc zzbhc2) {
        return zzbgn.zza(zzbhc2);
    }
}

