/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzd;
import com.google.android.gms.internal.zzbhi;
import com.google.android.gms.internal.zzbhk;
import com.google.android.gms.internal.zzbhm;
import com.google.android.gms.internal.zzbhr;
import com.google.android.gms.internal.zzbhz;
import com.google.android.gms.internal.zzbif;
import com.google.android.gms.internal.zzbil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class zzbhq
implements zzbhi {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzgfp = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzgfq = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public final PendingResult<zzbhm> zza(GoogleApiClient googleApiClient, zzbhk zzbhk2) {
        if (googleApiClient == null || zzbhk2 == null) {
            return null;
        }
        return googleApiClient.zzd((zzm)new zzbhr(this, googleApiClient, zzbhk2));
    }

    private static Status zzcn(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 6500: {
                string = "NOT_AUTHORIZED_TO_FETCH";
                break;
            }
            case 6501: {
                string = "ANOTHER_FETCH_INFLIGHT";
                break;
            }
            case 6502: {
                string = "FETCH_THROTTLED";
                break;
            }
            case 6503: {
                string = "NOT_AVAILABLE";
                break;
            }
            case 6504: {
                string = "FAILURE_CACHE";
                break;
            }
            case -6505: {
                string = "SUCCESS_FRESH";
                break;
            }
            case -6506: {
                string = "SUCCESS_CACHE";
                break;
            }
            case 6507: {
                string = "FETCH_THROTTLED_STALE";
                break;
            }
            case -6508: {
                string = "SUCCESS_CACHE_STALE";
                break;
            }
            default: {
                string = CommonStatusCodes.getStatusCodeString((int)n2);
            }
        }
        return new Status(n, string);
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(zzbif zzbif2) {
        if (zzbif2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbif2.zzand();
        if (dataHolder == null) {
            return null;
        }
        zzbil zzbil2 = (zzbil)((Object)new zzd(dataHolder, zzbil.CREATOR).get(0));
        zzbif2.zzanf();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : zzbil2.zzanh().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = zzbil2.zzanh().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    @Nullable
    static List<byte[]> zzb(@Nullable zzbif zzbif2) {
        if (zzbif2 == null) {
            return null;
        }
        DataHolder dataHolder = zzbif2.zzane();
        if (dataHolder == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator iterator = new zzd(dataHolder, zzbhz.CREATOR).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((zzbhz)((Object)iterator.next())).getPayload());
        }
        zzbif2.zzang();
        return arrayList;
    }

    static /* synthetic */ Status zzco(int n) {
        return zzbhq.zzcn(n);
    }

    static /* synthetic */ HashMap zzc(zzbif zzbif2) {
        return zzbhq.zza(zzbif2);
    }
}

