/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.internal.zzbhg;
import com.google.android.gms.internal.zzbhk;
import com.google.android.gms.internal.zzbhl;
import com.google.android.gms.internal.zzbhm;
import com.google.android.gms.internal.zzbhx;
import com.google.android.gms.internal.zzdvs;
import com.google.android.gms.internal.zzexb;
import com.google.android.gms.internal.zzexc;
import com.google.android.gms.internal.zzexd;
import com.google.android.gms.internal.zzexe;
import com.google.android.gms.internal.zzexf;
import com.google.android.gms.internal.zzexg;
import com.google.android.gms.internal.zzexh;
import com.google.android.gms.internal.zzexi;
import com.google.android.gms.internal.zzexj;
import com.google.android.gms.internal.zzexk;
import com.google.android.gms.internal.zzexl;
import com.google.android.gms.internal.zzexm;
import com.google.android.gms.internal.zzexn;
import com.google.android.gms.internal.zzfjj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.zza;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig zzogh;
    private zzexe zzogi;
    private zzexe zzogj;
    private zzexe zzogk;
    private zzexh zzogl;
    private final Context mContext;
    private final ReadWriteLock zzogm = new ReentrantReadWriteLock(true);

    private FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzexe zzexe2, zzexe zzexe3, zzexe zzexe4, zzexh zzexh2) {
        this.mContext = context;
        this.zzogl = zzexh2 != null ? zzexh2 : new zzexh();
        this.zzogl.zzcn(this.zzfd(this.mContext));
        if (zzexe2 != null) {
            this.zzogi = zzexe2;
        }
        if (zzexe3 != null) {
            this.zzogj = zzexe3;
        }
        if (zzexe4 != null) {
            this.zzogk = zzexe4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (zzogh == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            if (zzogh == null) {
                zzexm zzexm2 = FirebaseRemoteConfig.zzfe(context);
                if (zzexm2 == null) {
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                    }
                    zzogh = new FirebaseRemoteConfig(context);
                } else {
                    zzexh zzexh2;
                    zzexh zzexh3;
                    if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                        Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                    }
                    zzexe zzexe2 = FirebaseRemoteConfig.zza(zzexm2.zzohm);
                    zzexe zzexe3 = FirebaseRemoteConfig.zza(zzexm2.zzohn);
                    zzexe zzexe4 = FirebaseRemoteConfig.zza(zzexm2.zzoho);
                    zzexk zzexk2 = zzexm2.zzohp;
                    if (zzexk2 == null) {
                        zzexh3 = null;
                    } else {
                        zzexh zzexh4 = new zzexh();
                        zzexh4.zzii(zzexk2.zzohh);
                        zzexh4.zzcv(zzexk2.zzohi);
                        zzexh4.zzco(zzexk2.zzohj);
                        zzexh3 = zzexh2 = zzexh4;
                    }
                    if (zzexh3 != null) {
                        zzexh2.zzat(FirebaseRemoteConfig.zza(zzexm2.zzohq));
                    }
                    zzogh = new FirebaseRemoteConfig(context, zzexe2, zzexe3, zzexe4, zzexh2);
                }
            }
            return zzogh;
        }
        return zzogh;
    }

    private final long zzfd(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = context.getPackageName();
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    private static zzexm zzfe(Context context) {
        zzexm zzexm2;
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            Object object = fileInputStream;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FirebaseRemoteConfig.zza((InputStream)object, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            object = byArray;
            zzfjj zzfjj2 = zzfjj.zzn((byte[])byArray, (int)0, (int)((Object)object).length);
            zzexm2 = new zzexm();
            zzexm2.zza(zzfjj2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zzexm2;
    }

    private static Map<String, zzexb> zza(zzexn[] zzexnArray) {
        HashMap<String, zzexb> hashMap = new HashMap<String, zzexb>();
        if (zzexnArray == null) {
            return hashMap;
        }
        zzexn[] zzexnArray2 = zzexnArray;
        int n = zzexnArray.length;
        for (int i = 0; i < n; ++i) {
            zzexn zzexn2 = zzexnArray2[i];
            String string = zzexn2.zzjrg;
            int n2 = zzexn2.resourceId;
            long l = zzexn2.zzohs;
            hashMap.put(string, new zzexb(n2, l));
        }
        return hashMap;
    }

    private static zzexe zza(zzexi zzexi2) {
        Object object;
        if (zzexi2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        Object object2 = zzexi2.zzohd;
        int n = zzexi2.zzohd.length;
        for (int i = 0; i < n; ++i) {
            zzexl zzexl2 = object2[i];
            String string = zzexl2.zzjrg;
            object = new HashMap();
            zzexj[] zzexjArray = zzexl2.zzohl;
            int n2 = zzexl2.zzohl.length;
            for (int j = 0; j < n2; ++j) {
                zzexj zzexj2 = zzexjArray[j];
                object.put(zzexj2.key, zzexj2.zzohg);
            }
            hashMap.put(string, (Map<String, byte[]>)object);
        }
        object2 = zzexi2.zzohe;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Object object3 = object2;
        int n3 = ((zzexl[])object2).length;
        for (int i = 0; i < n3; ++i) {
            object = object3[i];
            arrayList.add((byte[])object);
        }
        return new zzexe(hashMap, zzexi2.timestamp, arrayList);
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public boolean activateFetched() {
        this.zzogm.writeLock().lock();
        try {
            if (this.zzogi == null) {
                return false;
            }
            if (this.zzogj != null && this.zzogj.getTimestamp() >= this.zzogi.getTimestamp()) {
                return false;
            }
            long l = this.zzogi.getTimestamp();
            this.zzogj = this.zzogi;
            this.zzogj.setTimestamp(System.currentTimeMillis());
            this.zzogi = new zzexe(null, l, null);
            long l2 = this.zzogl.zzclj();
            this.zzogl.zzco(zzdvs.zza(l2, this.zzogj.zzanb()));
            long l3 = l2;
            List<byte[]> list = this.zzogj.zzanb();
            Context context = this.mContext;
            FirebaseRemoteConfig.zzr(new zzexc(context, list, l3));
            this.zzcld();
            return true;
        }
        finally {
            this.zzogm.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.zzogm.readLock().lock();
        try {
            if (this.zzogl != null && this.zzogl.zzclh() != null && this.zzogl.zzclh().get(string) != null && n == ((zzexb)(object = this.zzogl.zzclh().get(string))).getResourceId() && this.zzogl.zzcli() == ((zzexb)object).zzcle()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.zzogm.readLock().unlock();
        }
        object = new HashMap();
        try {
            XmlResourceParser xmlResourceParser = this.mContext.getResources().getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzexb zzexb2 = new zzexb(n, this.zzogl.zzcli());
            this.zzogl.zza(string, zzexb2);
            this.zzc((Map<String, Object>)object, string, false);
            return;
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
            return;
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    private final void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzexg.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzexg.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzexg.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzexg.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzexg.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzexg.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.zzogm.writeLock().lock();
        try {
            if (bl2) {
                if (this.zzogk == null || !this.zzogk.zzse(string)) {
                    return;
                }
                this.zzogk.zzi(null, string);
                this.zzogk.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.zzogk == null) {
                    this.zzogk = new zzexe(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis(), null);
                }
                this.zzogk.zzi(hashMap, string);
                this.zzogk.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.zzogl.zzsf(string);
            }
            this.zzcld();
            return;
        }
        finally {
            this.zzogm.writeLock().unlock();
        }
    }

    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzogm.writeLock().lock();
        try {
            boolean bl = this.zzogl.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.zzogl.zzcv(bl2);
            if (bl != bl2) {
                this.zzcld();
            }
            return;
        }
        finally {
            this.zzogm.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.zzogm.readLock().lock();
        try {
            if (this.zzogj != null && this.zzogj.zzbn(string, string2)) {
                byte[] byArray = this.zzogj.zzbo(string, string2);
                return byArray;
            }
            if (this.zzogk != null && this.zzogk.zzbn(string, string2)) {
                byte[] byArray = this.zzogk.zzbo(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.zzogm.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    public String getString(String string, String string2) {
        block5: {
            if (string2 == null) {
                return DEFAULT_VALUE_FOR_STRING;
            }
            this.zzogm.readLock().lock();
            try {
                if (this.zzogj == null || !this.zzogj.zzbn(string, string2)) break block5;
                String string3 = new String(this.zzogj.zzbo(string, string2), zzexg.UTF_8);
                this.zzogm.readLock().unlock();
                return string3;
            }
            catch (Throwable throwable) {
                this.zzogm.readLock().unlock();
                throw throwable;
            }
        }
        if (this.zzogk != null && this.zzogk.zzbn(string, string2)) {
            String string4 = new String(this.zzogk.zzbo(string, string2), zzexg.UTF_8);
            this.zzogm.readLock().unlock();
            return string4;
        }
        String string5 = DEFAULT_VALUE_FOR_STRING;
        this.zzogm.readLock().unlock();
        return string5;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.zzogm.readLock().lock();
        try {
            String string3;
            if (this.zzogj != null && this.zzogj.zzbn(string, string2)) {
                string3 = new String(this.zzogj.zzbo(string, string2), zzexg.UTF_8);
                if (zzexg.zzgfp.matcher(string3).matches()) {
                    return true;
                }
                if (zzexg.zzgfq.matcher(string3).matches()) {
                    return false;
                }
            }
            if (this.zzogk != null && this.zzogk.zzbn(string, string2)) {
                string3 = new String(this.zzogk.zzbo(string, string2), zzexg.UTF_8);
                if (zzexg.zzgfp.matcher(string3).matches()) {
                    return true;
                }
                if (zzexg.zzgfq.matcher(string3).matches()) {
                    return false;
                }
            }
            return false;
        }
        finally {
            this.zzogm.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzexg(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.zzogm.readLock().lock();
        try {
            if (this.zzogj != null && this.zzogj.zzbn(string, string2)) {
                zzexg zzexg2 = new zzexg(this.zzogj.zzbo(string, string2), 2);
                return zzexg2;
            }
            if (this.zzogk != null && this.zzogk.zzbn(string, string2)) {
                zzexg zzexg3 = new zzexg(this.zzogk.zzbo(string, string2), 1);
                return zzexg3;
            }
            zzexg zzexg4 = new zzexg(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzexg4;
        }
        finally {
            this.zzogm.readLock().unlock();
        }
    }

    public FirebaseRemoteConfigInfo getInfo() {
        zzexf zzexf2 = new zzexf();
        this.zzogm.readLock().lock();
        try {
            long l = this.zzogi == null ? -1L : this.zzogi.getTimestamp();
            zzexf2.zzcm(l);
            zzexf2.zzii(this.zzogl.getLastFetchStatus());
            zzexf2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.zzogl.isDeveloperModeEnabled()).build());
        }
        finally {
            this.zzogm.readLock().unlock();
        }
        return zzexf2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    public Set<String> getKeysByPrefix(String string, String string2) {
        this.zzogm.readLock().lock();
        try {
            if (this.zzogj == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.zzogj.zzbp(string, string2);
            return set;
        }
        finally {
            this.zzogm.readLock().unlock();
        }
    }

    private static void zzr(Runnable runnable) {
        AsyncTask.SERIAL_EXECUTOR.execute(runnable);
    }

    private final void zzcld() {
        this.zzogm.readLock().lock();
        try {
            FirebaseRemoteConfig.zzr(new zzexd(this.mContext, this.zzogi, this.zzogj, this.zzogk, this.zzogl));
            return;
        }
        finally {
            this.zzogm.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    public Task<Void> fetch(long l) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzogm.readLock().lock();
        try {
            int n;
            long l2;
            long l3;
            zzbhl zzbhl2 = new zzbhl();
            zzbhl2.zzaa(l);
            if (this.zzogl.isDeveloperModeEnabled()) {
                zzbhl2.zzx("_rcn_developer", "true");
            }
            zzbhl2.zzck(10300);
            if (this.zzogj != null && this.zzogj.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzogj.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbhl2.zzcm(n);
            }
            if (this.zzogi != null && this.zzogi.getTimestamp() != -1L) {
                l3 = System.currentTimeMillis() - this.zzogi.getTimestamp();
                l2 = TimeUnit.SECONDS.convert(l3, TimeUnit.MILLISECONDS);
                n = l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
                zzbhl2.zzcl(n);
            }
            zzbhk zzbhk2 = zzbhl2.zzana();
            zzbhx zzbhx2 = new zzbhx(this.mContext);
            zzbhg.zzgfi.zza(zzbhx2.zzago(), zzbhk2).setResultCallback((ResultCallback)new zza(this, taskCompletionSource));
        }
        finally {
            this.zzogm.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final void zza(TaskCompletionSource<Void> taskCompletionSource, zzbhm zzbhm2) {
        if (zzbhm2 == null || zzbhm2.getStatus() == null) {
            this.zzogl.zzii(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzcld();
            return;
        }
        int n = zzbhm2.getStatus().getStatusCode();
        this.zzogm.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.zzogl.zzii(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzcld();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.zzogl.zzii(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzbhm2.getThrottleEndTimeMillis())));
                    this.zzcld();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.zzogl.zzii(-1);
                    if (this.zzogi != null && !this.zzogi.zzclg()) {
                        Map<String, Set<String>> map = zzbhm2.zzanc();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzbhm2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.zzogi = new zzexe(hashMap, this.zzogi.getTimestamp(), zzbhm2.zzanb());
                    }
                    taskCompletionSource.setResult(null);
                    this.zzcld();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzbhm2.zzanc();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzbhm2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.zzogi = new zzexe(hashMap, System.currentTimeMillis(), zzbhm2.zzanb());
                    this.zzogl.zzii(-1);
                    taskCompletionSource.setResult(null);
                    this.zzcld();
                    return;
                }
                default: {
                    if (zzbhm2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.zzogl.zzii(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.zzcld();
                    return;
                }
            }
        }
        finally {
            this.zzogm.writeLock().unlock();
        }
    }
}

