/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.config;

import com.google.android.gms.internal.config.zzba;
import com.google.android.gms.internal.config.zzbh;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzaz {
    private final ByteBuffer zzcg;

    private zzaz(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzaz(ByteBuffer byteBuffer) {
        this.zzcg = byteBuffer;
        this.zzcg.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzaz zza(byte[] byArray) {
        return zzaz.zzb(byArray, 0, byArray.length);
    }

    public static zzaz zzb(byte[] byArray, int n, int n2) {
        return new zzaz(byArray, 0, n2);
    }

    public final void zzc(int n, int n2) throws IOException {
        this.zze(1, 0);
        int n3 = n2;
        zzaz zzaz2 = this;
        if (n3 >= 0) {
            zzaz2.zzm(n3);
            return;
        }
        long l = n3;
        zzaz zzaz3 = zzaz2;
        while (true) {
            zzaz zzaz4;
            byte by;
            int n4;
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                n4 = (int)l;
                by = (byte)n4;
                zzaz4 = zzaz3;
                if (!zzaz4.zzcg.hasRemaining()) {
                    throw new zzba(zzaz4.zzcg.position(), zzaz4.zzcg.limit());
                }
                zzaz4.zzcg.put(by);
                return;
            }
            n4 = (int)l & 0x7F | 0x80;
            by = (byte)n4;
            zzaz4 = zzaz3;
            if (!zzaz4.zzcg.hasRemaining()) {
                throw new zzba(zzaz4.zzcg.position(), zzaz4.zzcg.limit());
            }
            zzaz4.zzcg.put(by);
            l >>>= 7;
        }
    }

    public final void zza(int n, long l) throws IOException {
        long l2;
        this.zze(n, 1);
        long l3 = l2 = l;
        zzaz zzaz2 = this;
        if (zzaz2.zzcg.remaining() < 8) {
            throw new zzba(zzaz2.zzcg.position(), zzaz2.zzcg.limit());
        }
        zzaz2.zzcg.putLong(l3);
    }

    public final void zza(int n, String string) throws IOException {
        this.zze(n, 2);
        String string2 = string;
        zzaz zzaz2 = this;
        try {
            int n2 = zzaz.zzn(string2.length());
            int n3 = zzaz.zzn(string2.length() * 3);
            if (n2 == n3) {
                int n4 = zzaz2.zzcg.position();
                if (zzaz2.zzcg.remaining() < n2) {
                    throw new zzba(n4 + n2, zzaz2.zzcg.limit());
                }
                zzaz2.zzcg.position(n4 + n2);
                zzaz.zza(string2, zzaz2.zzcg);
                int n5 = zzaz2.zzcg.position();
                zzaz2.zzcg.position(n4);
                zzaz2.zzm(n5 - n4 - n2);
                zzaz2.zzcg.position(n5);
                return;
            }
            zzaz2.zzm(zzaz.zza(string2));
            zzaz.zza(string2, zzaz2.zzcg);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzba zzba2 = new zzba(zzaz2.zzcg.position(), zzaz2.zzcg.limit());
            zzba2.initCause(bufferOverflowException);
            throw zzba2;
        }
    }

    public final void zza(int n, zzbh zzbh2) throws IOException {
        this.zze(n, 2);
        zzbh zzbh3 = zzbh2;
        zzaz zzaz2 = this;
        zzbh zzbh4 = zzbh3;
        if (zzbh4.zzcq < 0) {
            zzbh4.zzah();
        }
        zzaz2.zzm(zzbh4.zzcq);
        zzbh3.zza(zzaz2);
    }

    public final void zza(int n, byte[] byArray) throws IOException {
        this.zze(n, 2);
        byte[] byArray2 = byArray;
        zzaz zzaz2 = this;
        zzaz2.zzm(byArray2.length);
        zzaz2.zzc(byArray2);
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public static int zzd(int n, int n2) {
        return zzaz.zzl(1) + zzaz.zzj(n2);
    }

    public static int zzb(int n, String string) {
        int n2 = zzaz.zza(string);
        return zzaz.zzl(n) + (zzaz.zzn(n2) + n2);
    }

    public static int zzb(int n, zzbh zzbh2) {
        int n2 = zzbh2.zzah();
        return zzaz.zzl(n) + (zzaz.zzn(n2) + n2);
    }

    public static int zzj(int n) {
        if (n >= 0) {
            return zzaz.zzn(n);
        }
        return 10;
    }

    public static int zzb(byte[] byArray) {
        return zzaz.zzn(byArray.length) + byArray.length;
    }

    public final void zzac() {
        if (this.zzcg.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zzcg.remaining()));
        }
    }

    public final void zza(byte by) throws IOException {
        if (!this.zzcg.hasRemaining()) {
            throw new zzba(this.zzcg.position(), this.zzcg.limit());
        }
        this.zzcg.put(by);
    }

    private final void zzk(int n) throws IOException {
        byte by = (byte)n;
        zzaz zzaz2 = this;
        if (!zzaz2.zzcg.hasRemaining()) {
            throw new zzba(zzaz2.zzcg.position(), zzaz2.zzcg.limit());
        }
        zzaz2.zzcg.put(by);
    }

    public final void zzc(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        zzaz zzaz2 = this;
        if (zzaz2.zzcg.remaining() >= n) {
            zzaz2.zzcg.put(byArray2, 0, n);
            return;
        }
        throw new zzba(zzaz2.zzcg.position(), zzaz2.zzcg.limit());
    }

    public final void zze(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzm(n << 3 | n3);
    }

    public static int zzl(int n) {
        return zzaz.zzn(n << 3);
    }

    public final void zzm(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzk(n);
                return;
            }
            this.zzk(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzn(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }
}

