/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.config;

import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.data.DataBufferSafeParcelable;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.config.zzad;
import com.google.android.gms.internal.config.zzaj;
import com.google.android.gms.internal.config.zzg;
import com.google.android.gms.internal.config.zzi;
import com.google.android.gms.internal.config.zzk;
import com.google.android.gms.internal.config.zzp;
import com.google.android.gms.internal.config.zzx;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class zzo
implements zzg {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern zzl = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    private static final Pattern zzm = Pattern.compile("^(0|false|f|no|n|off|)$", 2);

    @Override
    public final PendingResult<zzk> zza(GoogleApiClient googleApiClient, zzi zzi2) {
        if (googleApiClient == null || zzi2 == null) {
            return null;
        }
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzp(this, googleApiClient, zzi2));
    }

    private static Status zzd(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 6500: {
                string = "NOT_AUTHORIZED_TO_FETCH";
                break;
            }
            case 6501: {
                string = "ANOTHER_FETCH_INFLIGHT";
                break;
            }
            case 6502: {
                string = "FETCH_THROTTLED";
                break;
            }
            case 6503: {
                string = "NOT_AVAILABLE";
                break;
            }
            case 6504: {
                string = "FAILURE_CACHE";
                break;
            }
            case -6505: {
                string = "SUCCESS_FRESH";
                break;
            }
            case -6506: {
                string = "SUCCESS_CACHE";
                break;
            }
            case 6507: {
                string = "FETCH_THROTTLED_STALE";
                break;
            }
            case -6508: {
                string = "SUCCESS_CACHE_STALE";
                break;
            }
            default: {
                string = CommonStatusCodes.getStatusCodeString((int)n2);
            }
        }
        return new Status(n, string);
    }

    private static HashMap<String, TreeMap<String, byte[]>> zza(zzad zzad2) {
        if (zzad2 == null) {
            return null;
        }
        DataHolder dataHolder = zzad2.zzi();
        if (dataHolder == null) {
            return null;
        }
        zzaj zzaj2 = (zzaj)((Object)new DataBufferSafeParcelable(dataHolder, zzaj.CREATOR).get(0));
        zzad2.zzk();
        HashMap<String, TreeMap<String, byte[]>> hashMap = new HashMap<String, TreeMap<String, byte[]>>();
        for (String string : zzaj2.zzm().keySet()) {
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            hashMap.put(string, treeMap);
            Bundle bundle = zzaj2.zzm().getBundle(string);
            for (String string2 : bundle.keySet()) {
                treeMap.put(string2, bundle.getByteArray(string2));
            }
        }
        return hashMap;
    }

    @Nullable
    static List<byte[]> zzb(@Nullable zzad zzad2) {
        if (zzad2 == null) {
            return null;
        }
        DataHolder dataHolder = zzad2.zzj();
        if (dataHolder == null) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        Iterator iterator = new DataBufferSafeParcelable(dataHolder, zzx.CREATOR).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((zzx)((Object)iterator.next())).getPayload());
        }
        zzad2.zzl();
        return arrayList;
    }

    static /* synthetic */ Status zze(int n) {
        return zzo.zzd(n);
    }

    static /* synthetic */ HashMap zzc(zzad zzad2) {
        return zzo.zza(zzad2);
    }
}

