/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import com.google.android.gms.internal.firebase_remote_config.zzch;
import com.google.android.gms.internal.firebase_remote_config.zzcn;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class zzco {
    private static ParameterizedType zza(Type type, Class<?> clazz) {
        if (type instanceof Class || type instanceof ParameterizedType) {
            block0: while (type != null && type != Object.class) {
                Class<?> clazz2;
                if (type instanceof Class) {
                    clazz2 = (Class<?>)type;
                } else {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    clazz2 = zzco.zza(parameterizedType);
                    if (clazz2 == clazz) {
                        return parameterizedType;
                    }
                    if (clazz.isInterface()) {
                        for (Type type2 : clazz2.getGenericInterfaces()) {
                            Class<?> clazz3;
                            Class<?> clazz4 = clazz3 = type2 instanceof Class ? (Class<?>)type2 : zzco.zza((ParameterizedType)type2);
                            if (!clazz.isAssignableFrom(clazz3)) continue;
                            type = type2;
                            continue block0;
                        }
                    }
                }
                type = clazz2.getGenericSuperclass();
            }
        }
        return null;
    }

    public static boolean zza(Class<?> clazz, Class<?> clazz2) {
        return clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz);
    }

    public static <T> T zzf(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw zzco.zza(illegalAccessException, clazz);
        }
        catch (InstantiationException instantiationException) {
            throw zzco.zza(instantiationException, clazz);
        }
    }

    private static IllegalArgumentException zza(Exception exception, Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder("unable to create new instance of class ").append(clazz.getName());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (clazz.isArray()) {
            arrayList.add("because it is an array");
        } else if (clazz.isPrimitive()) {
            arrayList.add("because it is primitive");
        } else if (clazz == Void.class) {
            arrayList.add("because it is void");
        } else {
            if (Modifier.isInterface(clazz.getModifiers())) {
                arrayList.add("because it is an interface");
            } else if (Modifier.isAbstract(clazz.getModifiers())) {
                arrayList.add("because it is abstract");
            }
            if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
                arrayList.add("because it is not static");
            }
            if (!Modifier.isPublic(clazz.getModifiers())) {
                arrayList.add("possibly because it is not public");
            } else {
                try {
                    clazz.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    arrayList.add("because it has no accessible default constructor");
                }
            }
        }
        boolean bl = false;
        ArrayList<String> arrayList2 = arrayList;
        int n = arrayList2.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = arrayList2.get(n2);
            ++n2;
            String string = (String)e;
            if (bl) {
                stringBuilder.append(" and");
            } else {
                bl = true;
            }
            stringBuilder.append(" ").append(string);
        }
        return new IllegalArgumentException(stringBuilder.toString(), exception);
    }

    public static boolean zzc(Type type) {
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
    }

    public static Type zzd(Type type) {
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return ((Class)type).getComponentType();
    }

    public static Class<?> zza(ParameterizedType parameterizedType) {
        return (Class)parameterizedType.getRawType();
    }

    public static Type zza(WildcardType wildcardType) {
        Type[] typeArray = wildcardType.getLowerBounds();
        if (typeArray.length != 0) {
            return typeArray[0];
        }
        return wildcardType.getUpperBounds()[0];
    }

    public static Type zza(List<Type> list, TypeVariable<?> typeVariable) {
        Object obj = typeVariable.getGenericDeclaration();
        if (obj instanceof Class) {
            Class clazz = (Class)obj;
            int n = list.size();
            ParameterizedType parameterizedType = null;
            while (parameterizedType == null && --n >= 0) {
                parameterizedType = zzco.zza(list.get(n), clazz);
            }
            if (parameterizedType != null) {
                Type type;
                int n2;
                TypeVariable<?>[] typeVariableArray = obj.getTypeParameters();
                for (n2 = 0; n2 < typeVariableArray.length && !typeVariableArray[n2].equals(typeVariable); ++n2) {
                }
                Type type2 = parameterizedType.getActualTypeArguments()[n2];
                if (type2 instanceof TypeVariable && (type = zzco.zza(list, (TypeVariable)type2)) != null) {
                    return type;
                }
                return type2;
            }
        }
        return null;
    }

    public static Class<?> zzb(List<Type> list, Type type) {
        if (type instanceof TypeVariable) {
            type = zzco.zza(list, (TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(zzco.zzb(list, zzco.zzd(type)), 0).getClass();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return zzco.zza((ParameterizedType)type);
        }
        zzch.checkArgument(type == null, "wildcard type is not supported: %s", type);
        return Object.class;
    }

    public static Type zze(Type type) {
        return zzco.zza(type, Iterable.class, 0);
    }

    public static Type zzf(Type type) {
        return zzco.zza(type, Map.class, 1);
    }

    private static Type zza(Type type, Class<?> clazz, int n) {
        Type type2;
        ParameterizedType parameterizedType = zzco.zza(type, clazz);
        if (parameterizedType == null) {
            return null;
        }
        Type type3 = parameterizedType.getActualTypeArguments()[n];
        if (type3 instanceof TypeVariable && (type2 = zzco.zza(Arrays.asList(type), (TypeVariable)type3)) != null) {
            return type2;
        }
        return type3;
    }

    public static <T> Iterable<T> zzi(Object object) {
        if (object instanceof Iterable) {
            return (Iterable)object;
        }
        Class<?> clazz = object.getClass();
        zzch.checkArgument(clazz.isArray(), "not an array or Iterable: %s", clazz);
        if (!clazz.getComponentType().isPrimitive()) {
            return Arrays.asList((Object[])object);
        }
        return new zzcn(object);
    }

    public static Object zza(Collection<?> collection, Class<?> clazz) {
        if (clazz.isPrimitive()) {
            Object object = Array.newInstance(clazz, collection.size());
            int n = 0;
            for (Object obj : collection) {
                Array.set(object, n++, obj);
            }
            return object;
        }
        return collection.toArray((Object[])Array.newInstance(clazz, collection.size()));
    }
}

