/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.firebase_remote_config.zzeh;
import com.google.android.gms.internal.firebase_remote_config.zzej;
import com.google.android.gms.internal.firebase_remote_config.zzek;
import com.google.android.gms.internal.firebase_remote_config.zzem;
import com.google.android.gms.internal.firebase_remote_config.zzen;
import com.google.android.gms.internal.firebase_remote_config.zzeo;
import com.google.android.gms.internal.firebase_remote_config.zzex;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class zzei {
    @GuardedBy(value="ConfigCacheClient.class")
    private static final Map<String, zzei> zzkg = new HashMap<String, zzei>();
    private final ExecutorService zzkh;
    private final zzex zzki;
    @GuardedBy(value="this")
    @Nullable
    private Task<zzen> zzkj;
    private static final Executor zzkk = zzem.zzko;

    private zzei(ExecutorService executorService, zzex zzex2) {
        this.zzkh = executorService;
        this.zzki = zzex2;
        this.zzkj = null;
    }

    public final Task<zzen> zzb(zzen zzen2) {
        this.zzd(zzen2);
        return this.zza(zzen2, false);
    }

    @Nullable
    public final zzen zzco() {
        return this.zzb(5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    final zzen zzb(long l) {
        zzei zzei2 = this;
        synchronized (zzei2) {
            if (this.zzkj != null && this.zzkj.isSuccessful()) {
                return (zzen)this.zzkj.getResult();
            }
        }
        try {
            TimeUnit timeUnit = TimeUnit.SECONDS;
            Task<zzen> task = this.zzcp();
            zzeo zzeo2 = new zzeo(null);
            task.addOnSuccessListener(zzkk, zzeo2);
            task.addOnFailureListener(zzkk, zzeo2);
            task.addOnCanceledListener(zzkk, zzeo2);
            if (!zzeo2.await(5L, timeUnit)) {
                throw new TimeoutException("Task await timed out.");
            }
            if (!task.isSuccessful()) {
                throw new ExecutionException(task.getException());
            }
            return (zzen)task.getResult();
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            Log.d((String)"ConfigCacheClient", (String)"Reading from storage file failed.", (Throwable)exception);
            return null;
        }
    }

    public final Task<zzen> zzc(zzen zzen2) {
        return this.zza(zzen2, true);
    }

    public final Task<zzen> zza(zzen zzen2, boolean bl) {
        return Tasks.call((Executor)this.zzkh, (Callable)new zzeh(this, zzen2)).onSuccessTask((Executor)this.zzkh, (SuccessContinuation)new zzek(this, bl, zzen2));
    }

    public final synchronized Task<zzen> zzcp() {
        if (this.zzkj == null || this.zzkj.isComplete() && !this.zzkj.isSuccessful()) {
            zzex zzex2 = this.zzki;
            zzex2.getClass();
            this.zzkj = Tasks.call((Executor)this.zzkh, (Callable)zzej.zza(zzex2));
        }
        return this.zzkj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        zzei zzei2 = this;
        synchronized (zzei2) {
            this.zzkj = Tasks.forResult(null);
        }
        this.zzki.zzdc();
    }

    private final synchronized void zzd(zzen zzen2) {
        this.zzkj = Tasks.forResult((Object)zzen2);
    }

    public static synchronized zzei zza(ExecutorService executorService, zzex zzex2) {
        String string = zzex2.getFileName();
        if (!zzkg.containsKey(string)) {
            zzkg.put(string, new zzei(executorService, zzex2));
        }
        return zzkg.get(string);
    }

    final /* synthetic */ Task zza(boolean bl, zzen zzen2, Void void_) throws Exception {
        if (bl) {
            this.zzd(zzen2);
        }
        return Tasks.forResult((Object)zzen2);
    }

    final /* synthetic */ Void zze(zzen zzen2) throws Exception {
        return this.zzki.zzh(zzen2);
    }
}

