/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.firebase_remote_config.zzei;
import com.google.android.gms.internal.firebase_remote_config.zzen;
import com.google.android.gms.internal.firebase_remote_config.zzfe;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.json.JSONException;

public final class zzew {
    @VisibleForTesting(otherwise=3)
    public static final Charset zzln = Charset.forName("UTF-8");
    static final Pattern zzlo = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    static final Pattern zzlp = Pattern.compile("^(0|false|f|no|n|off|)$", 2);
    private final zzei zzje;
    private final zzei zzjf;

    public zzew(zzei zzei2, zzei zzei3) {
        this.zzje = zzei2;
        this.zzjf = zzei3;
    }

    public final String getString(String string) {
        String string2 = zzew.zza(this.zzje, string, "String");
        if (string2 != null) {
            return string2;
        }
        String string3 = zzew.zza(this.zzjf, string, "String");
        if (string3 != null) {
            return string3;
        }
        return "";
    }

    public final boolean getBoolean(String string) {
        String string2;
        String string3 = zzew.zza(this.zzje, string, "Boolean");
        if (string3 != null) {
            if (zzlo.matcher(string3).matches()) {
                return true;
            }
            if (zzlp.matcher(string3).matches()) {
                return false;
            }
        }
        if ((string2 = zzew.zza(this.zzjf, string, "Boolean")) != null) {
            if (zzlo.matcher(string2).matches()) {
                return true;
            }
            if (zzlp.matcher(string2).matches()) {
                return false;
            }
        }
        return false;
    }

    public final byte[] getByteArray(String string) {
        String string2 = zzew.zza(this.zzje, string, "ByteArray");
        if (string2 != null) {
            return string2.getBytes(zzln);
        }
        String string3 = zzew.zza(this.zzjf, string, "ByteArray");
        if (string3 != null) {
            return string3.getBytes(zzln);
        }
        return FirebaseRemoteConfig.DEFAULT_VALUE_FOR_BYTE_ARRAY;
    }

    public final double getDouble(String string) {
        Double d = zzew.zza(this.zzje, string);
        if (d != null) {
            return d;
        }
        Double d2 = zzew.zza(this.zzjf, string);
        if (d2 != null) {
            return d2;
        }
        return 0.0;
    }

    public final long getLong(String string) {
        Long l = zzew.zzb(this.zzje, string);
        if (l != null) {
            return l;
        }
        Long l2 = zzew.zzb(this.zzjf, string);
        if (l2 != null) {
            return l2;
        }
        return 0L;
    }

    public final FirebaseRemoteConfigValue getValue(String string) {
        String string2 = zzew.zza(this.zzje, string, "FirebaseRemoteConfigValue");
        if (string2 != null) {
            return new zzfe(string2, 2);
        }
        String string3 = zzew.zza(this.zzjf, string, "FirebaseRemoteConfigValue");
        if (string3 != null) {
            return new zzfe(string3, 1);
        }
        return new zzfe("", 0);
    }

    public final Set<String> getKeysByPrefix(String string) {
        zzen zzen2;
        if (string == null) {
            string = "";
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        zzen zzen3 = this.zzje.zzb(5L);
        if (zzen3 != null) {
            treeSet.addAll(zzew.zza(string, zzen3));
        }
        if ((zzen2 = this.zzjf.zzb(5L)) != null) {
            treeSet.addAll(zzew.zza(string, zzen2));
        }
        return treeSet;
    }

    private static TreeSet<String> zza(String string, zzen zzen2) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = zzen2.zzcq().keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            treeSet.add(string2);
        }
        return treeSet;
    }

    public final Map<String, FirebaseRemoteConfigValue> getAll() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(zzew.zza(this.zzje));
        hashSet.addAll(zzew.zza(this.zzjf));
        HashMap<String, FirebaseRemoteConfigValue> hashMap = new HashMap<String, FirebaseRemoteConfigValue>();
        for (String string : hashSet) {
            hashMap.put(string, this.getValue(string));
        }
        return hashMap;
    }

    @Nullable
    private static String zza(zzei zzei2, String string, String string2) {
        zzen zzen2 = zzei2.zzb(5L);
        if (zzen2 == null) {
            return null;
        }
        try {
            return zzen2.zzcq().getString(string);
        }
        catch (JSONException jSONException) {
            zzew.zze(string, string2);
            return null;
        }
    }

    @Nullable
    private static Double zza(zzei zzei2, String string) {
        zzen zzen2 = zzei2.zzb(5L);
        if (zzen2 == null) {
            return null;
        }
        try {
            return zzen2.zzcq().getDouble(string);
        }
        catch (JSONException jSONException) {
            zzew.zze(string, "Double");
            return null;
        }
    }

    @Nullable
    private static Long zzb(zzei zzei2, String string) {
        zzen zzen2 = zzei2.zzb(5L);
        if (zzen2 == null) {
            return null;
        }
        try {
            return zzen2.zzcq().getLong(string);
        }
        catch (JSONException jSONException) {
            zzew.zze(string, "Long");
            return null;
        }
    }

    private static Set<String> zza(zzei zzei2) {
        HashSet<String> hashSet = new HashSet<String>();
        zzen zzen2 = zzei2.zzb(5L);
        if (zzen2 == null) {
            return hashSet;
        }
        Iterator iterator = zzen2.zzcq().keys();
        while (iterator.hasNext()) {
            hashSet.add((String)iterator.next());
        }
        return hashSet;
    }

    private static void zze(String string, String string2) {
        Log.w((String)"FirebaseRemoteConfig", (String)String.format("No value of type '%s' exists for parameter key '%s'.", string2, string));
    }
}

