/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import com.google.android.gms.internal.firebase_remote_config.zzfr;
import com.google.android.gms.internal.firebase_remote_config.zzhm;
import com.google.android.gms.internal.firebase_remote_config.zzhn;
import com.google.android.gms.internal.firebase_remote_config.zzjc;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfv
extends zzfr<Boolean>
implements zzhn<Boolean>,
zzjc,
RandomAccess {
    private static final zzfv zzop = new zzfv(new boolean[0], 0);
    private boolean[] zzoq;
    private int size;

    zzfv() {
        this(new boolean[10], 0);
    }

    private zzfv(boolean[] blArray, int n) {
        this.zzoq = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzet();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzoq, n2, this.zzoq, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfv)) {
            return super.equals(object);
        }
        zzfv zzfv2 = (zzfv)object;
        if (this.size != zzfv2.size) {
            return false;
        }
        boolean[] blArray = zzfv2.zzoq;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzoq[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzhm.zzf(this.zzoq[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzet();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzt(n));
        }
        if (this.size < this.zzoq.length) {
            System.arraycopy(this.zzoq, n, this.zzoq, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzoq, 0, blArray, 0, n);
            System.arraycopy(this.zzoq, n, blArray, n + 1, this.size - n);
            this.zzoq = blArray;
        }
        this.zzoq[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzet();
        zzhm.checkNotNull(collection);
        if (!(collection instanceof zzfv)) {
            return super.addAll(collection);
        }
        zzfv zzfv2 = (zzfv)collection;
        if (zzfv2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfv2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfv2.size;
        if (n > this.zzoq.length) {
            this.zzoq = Arrays.copyOf(this.zzoq, n);
        }
        System.arraycopy(zzfv2.zzoq, 0, this.zzoq, this.size, zzfv2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzet();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzoq[i])) continue;
            System.arraycopy(this.zzoq, i + 1, this.zzoq, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzs(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzt(n));
        }
    }

    private final String zzt(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzfv zzfv2 = this;
        zzfv2.zzet();
        zzfv2.zzs(n);
        boolean bl3 = zzfv2.zzoq[n];
        zzfv2.zzoq[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfv zzfv2 = this;
        zzfv2.zzet();
        zzfv2.zzs(n);
        boolean bl = zzfv2.zzoq[n];
        if (n < zzfv2.size - 1) {
            System.arraycopy(zzfv2.zzoq, n + 1, zzfv2.zzoq, n, zzfv2.size - n - 1);
        }
        --zzfv2.size;
        ++zzfv2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzhn zzu(int n) {
        int n2 = n;
        zzfv zzfv2 = this;
        if (n2 < zzfv2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfv(Arrays.copyOf(zzfv2.zzoq, n2), zzfv2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzfv zzfv2 = this;
        zzfv2.zzs(n);
        return zzfv2.zzoq[n];
    }

    static {
        zzop.zzes();
    }
}

