/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import com.google.android.gms.internal.firebase_remote_config.zzfr;
import com.google.android.gms.internal.firebase_remote_config.zzhm;
import com.google.android.gms.internal.firebase_remote_config.zzhn;
import com.google.android.gms.internal.firebase_remote_config.zzjc;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzhg
extends zzfr<Float>
implements zzhn<Float>,
zzjc,
RandomAccess {
    private static final zzhg zzsu = new zzhg(new float[0], 0);
    private float[] zzsv;
    private int size;

    zzhg() {
        this(new float[10], 0);
    }

    private zzhg(float[] fArray, int n) {
        this.zzsv = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzet();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzsv, n2, this.zzsv, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzhg)) {
            return super.equals(object);
        }
        zzhg zzhg2 = (zzhg)object;
        if (this.size != zzhg2.size) {
            return false;
        }
        float[] fArray = zzhg2.zzsv;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzsv[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzsv[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzet();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzt(n));
        }
        if (this.size < this.zzsv.length) {
            System.arraycopy(this.zzsv, n, this.zzsv, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzsv, 0, fArray, 0, n);
            System.arraycopy(this.zzsv, n, fArray, n + 1, this.size - n);
            this.zzsv = fArray;
        }
        this.zzsv[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzet();
        zzhm.checkNotNull(collection);
        if (!(collection instanceof zzhg)) {
            return super.addAll(collection);
        }
        zzhg zzhg2 = (zzhg)collection;
        if (zzhg2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzhg2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzhg2.size;
        if (n > this.zzsv.length) {
            this.zzsv = Arrays.copyOf(this.zzsv, n);
        }
        System.arraycopy(zzhg2.zzsv, 0, this.zzsv, this.size, zzhg2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzet();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzsv[i]))) continue;
            System.arraycopy(this.zzsv, i + 1, this.zzsv, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzs(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzt(n));
        }
    }

    private final String zzt(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzhg zzhg2 = this;
        zzhg2.zzet();
        zzhg2.zzs(n);
        float f3 = zzhg2.zzsv[n];
        zzhg2.zzsv[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzhg zzhg2 = this;
        zzhg2.zzet();
        zzhg2.zzs(n);
        float f = zzhg2.zzsv[n];
        if (n < zzhg2.size - 1) {
            System.arraycopy(zzhg2.zzsv, n + 1, zzhg2.zzsv, n, zzhg2.size - n - 1);
        }
        --zzhg2.size;
        ++zzhg2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzhn zzu(int n) {
        int n2 = n;
        zzhg zzhg2 = this;
        if (n2 < zzhg2.size) {
            throw new IllegalArgumentException();
        }
        return new zzhg(Arrays.copyOf(zzhg2.zzsv, n2), zzhg2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzhg zzhg2 = this;
        zzhg2.zzs(n);
        return Float.valueOf(zzhg2.zzsv[n]);
    }

    static {
        zzsu.zzes();
    }
}

