/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_remote_config;

import com.google.android.gms.internal.firebase_remote_config.zzfr;
import com.google.android.gms.internal.firebase_remote_config.zzhm;
import com.google.android.gms.internal.firebase_remote_config.zzhn;
import com.google.android.gms.internal.firebase_remote_config.zzjc;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzie
extends zzfr<Long>
implements zzhn<Long>,
zzjc,
RandomAccess {
    private static final zzie zzvf = new zzie(new long[0], 0);
    private long[] zzvg;
    private int size;

    zzie() {
        this(new long[10], 0);
    }

    private zzie(long[] lArray, int n) {
        this.zzvg = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzet();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzvg, n2, this.zzvg, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzie)) {
            return super.equals(object);
        }
        zzie zzie2 = (zzie)object;
        if (this.size != zzie2.size) {
            return false;
        }
        long[] lArray = zzie2.zzvg;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzvg[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzhm.zzo(this.zzvg[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzs(n);
        return this.zzvg[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzp(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzet();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzt(n));
        }
        if (this.size < this.zzvg.length) {
            System.arraycopy(this.zzvg, n, this.zzvg, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzvg, 0, lArray, 0, n);
            System.arraycopy(this.zzvg, n, lArray, n + 1, this.size - n);
            this.zzvg = lArray;
        }
        this.zzvg[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzet();
        zzhm.checkNotNull(collection);
        if (!(collection instanceof zzie)) {
            return super.addAll(collection);
        }
        zzie zzie2 = (zzie)collection;
        if (zzie2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzie2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzie2.size;
        if (n > this.zzvg.length) {
            this.zzvg = Arrays.copyOf(this.zzvg, n);
        }
        System.arraycopy(zzie2.zzvg, 0, this.zzvg, this.size, zzie2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzet();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzvg[i])) continue;
            System.arraycopy(this.zzvg, i + 1, this.zzvg, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzs(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzt(n));
        }
    }

    private final String zzt(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzie zzie2 = this;
        zzie2.zzet();
        zzie2.zzs(n);
        long l3 = zzie2.zzvg[n];
        zzie2.zzvg[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzie zzie2 = this;
        zzie2.zzet();
        zzie2.zzs(n);
        long l = zzie2.zzvg[n];
        if (n < zzie2.size - 1) {
            System.arraycopy(zzie2.zzvg, n + 1, zzie2.zzvg, n, zzie2.size - n - 1);
        }
        --zzie2.size;
        ++zzie2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzhn zzu(int n) {
        int n2 = n;
        zzie zzie2 = this;
        if (n2 < zzie2.size) {
            throw new IllegalArgumentException();
        }
        return new zzie(Arrays.copyOf(zzie2.zzvg, n2), zzie2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzvf.zzes();
    }
}

