/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.annotation.XmlRes;
import com.google.android.gms.internal.firebase_remote_config.zzag;
import com.google.android.gms.internal.firebase_remote_config.zzei;
import com.google.android.gms.internal.firebase_remote_config.zzen;
import com.google.android.gms.internal.firebase_remote_config.zzes;
import com.google.android.gms.internal.firebase_remote_config.zzet;
import com.google.android.gms.internal.firebase_remote_config.zzev;
import com.google.android.gms.internal.firebase_remote_config.zzew;
import com.google.android.gms.internal.firebase_remote_config.zzfa;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.abt.AbtException;
import com.google.firebase.abt.FirebaseABTesting;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.RemoteConfigComponent;
import com.google.firebase.remoteconfig.zza;
import com.google.firebase.remoteconfig.zzb;
import com.google.firebase.remoteconfig.zzc;
import com.google.firebase.remoteconfig.zzd;
import com.google.firebase.remoteconfig.zze;
import com.google.firebase.remoteconfig.zzf;
import com.google.firebase.remoteconfig.zzg;
import com.google.firebase.remoteconfig.zzh;
import com.google.firebase.remoteconfig.zzi;
import com.google.firebase.remoteconfig.zzj;
import com.google.firebase.remoteconfig.zzk;
import com.google.firebase.remoteconfig.zzl;
import com.google.firebase.remoteconfig.zzm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private final Context zzja;
    private final FirebaseApp zzjb;
    @Nullable
    private final FirebaseABTesting zzjc;
    private final Executor executor;
    private final zzei zzjd;
    private final zzei zzje;
    private final zzei zzjf;
    private final zzes zzjg;
    private final zzew zzjh;
    private final zzev zzji;

    public static FirebaseRemoteConfig getInstance() {
        return FirebaseRemoteConfig.getInstance(FirebaseApp.getInstance());
    }

    public static FirebaseRemoteConfig getInstance(FirebaseApp firebaseApp) {
        return ((RemoteConfigComponent)firebaseApp.get(RemoteConfigComponent.class)).get("firebase");
    }

    FirebaseRemoteConfig(Context context, FirebaseApp firebaseApp, @Nullable FirebaseABTesting firebaseABTesting, Executor executor, zzei zzei2, zzei zzei3, zzei zzei4, zzes zzes2, zzew zzew2, zzev zzev2) {
        this.zzja = context;
        this.zzjb = firebaseApp;
        this.zzjc = firebaseABTesting;
        this.executor = executor;
        this.zzjd = zzei2;
        this.zzje = zzei3;
        this.zzjf = zzei4;
        this.zzjg = zzes2;
        this.zzjh = zzew2;
        this.zzji = zzev2;
    }

    public Task<FirebaseRemoteConfigInfo> ensureInitialized() {
        Task<zzen> task = this.zzje.zzcp();
        Task<zzen> task2 = this.zzjf.zzcp();
        Task<zzen> task3 = this.zzjd.zzcp();
        Task task4 = Tasks.call((Executor)this.executor, (Callable)new zza(this));
        return Tasks.whenAllComplete((Task[])new Task[]{task, task2, task3, task4}).continueWith(this.executor, (Continuation)new zzc(task4));
    }

    public Task<Boolean> fetchAndActivate() {
        return this.fetch().onSuccessTask(this.executor, (SuccessContinuation)new zzg(this));
    }

    @Deprecated
    @WorkerThread
    public boolean activateFetched() {
        zzen zzen2 = this.zzjd.zzco();
        if (zzen2 == null) {
            return false;
        }
        zzen zzen3 = this.zzje.zzco();
        if (!FirebaseRemoteConfig.zza(zzen2, zzen3)) {
            return false;
        }
        this.zzje.zzb(zzen2).addOnSuccessListener(this.executor, (OnSuccessListener)new zzf(this));
        return true;
    }

    public Task<Boolean> activate() {
        Task<zzen> task = this.zzjd.zzcp();
        Task<zzen> task2 = this.zzje.zzcp();
        return Tasks.whenAllComplete((Task[])new Task[]{task, task2}).continueWithTask(this.executor, (Continuation)new zzi(this, task, task2));
    }

    public Task<Void> fetch() {
        Task<zzet> task = this.zzjg.zza(this.zzji.isDeveloperModeEnabled());
        task.addOnCompleteListener(this.executor, (OnCompleteListener)new zzh(this));
        return task.onSuccessTask(zzk.zzjk);
    }

    public Task<Void> fetch(long l) {
        Task<zzet> task = this.zzjg.zza(this.zzji.isDeveloperModeEnabled(), l);
        task.addOnCompleteListener(this.executor, (OnCompleteListener)new zzj(this));
        return task.onSuccessTask(zzm.zzjk);
    }

    public String getString(String string) {
        return this.zzjh.getString(string);
    }

    public boolean getBoolean(String string) {
        return this.zzjh.getBoolean(string);
    }

    @Deprecated
    public byte[] getByteArray(String string) {
        return this.zzjh.getByteArray(string);
    }

    public double getDouble(String string) {
        return this.zzjh.getDouble(string);
    }

    public long getLong(String string) {
        return this.zzjh.getLong(string);
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.zzjh.getValue(string);
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.zzjh.getKeysByPrefix(string);
    }

    public Map<String, FirebaseRemoteConfigValue> getAll() {
        return this.zzjh.getAll();
    }

    public FirebaseRemoteConfigInfo getInfo() {
        return this.zzji.getInfo();
    }

    @Deprecated
    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.zzji.zzb(firebaseRemoteConfigSettings);
        if (firebaseRemoteConfigSettings.isDeveloperModeEnabled()) {
            Logger.getLogger(zzag.class.getName()).setLevel(Level.CONFIG);
        }
    }

    public Task<Void> setConfigSettingsAsync(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        return Tasks.call((Executor)this.executor, (Callable)new zzl(this, firebaseRemoteConfigSettings));
    }

    public void setDefaults(Map<String, Object> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().toString());
        }
        this.zzb(hashMap);
    }

    public Task<Void> setDefaultsAsync(Map<String, Object> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().toString());
        }
        return this.zzc(hashMap);
    }

    public void setDefaults(@XmlRes int n) {
        Map<String, String> map = zzfa.zza(this.zzja, n);
        this.zzb(map);
    }

    public Task<Void> setDefaultsAsync(@XmlRes int n) {
        Map<String, String> map = zzfa.zza(this.zzja, n);
        return this.zzc(map);
    }

    public Task<Void> reset() {
        return Tasks.call((Executor)this.executor, (Callable)new zzb(this));
    }

    final void zzcm() {
        this.zzje.zzcp();
        this.zzjf.zzcp();
        this.zzjd.zzcp();
    }

    private final boolean zza(Task<zzen> task) {
        if (task.isSuccessful()) {
            this.zzjd.clear();
            if (task.getResult() != null) {
                this.zza(((zzen)task.getResult()).zzcs());
            } else {
                Log.e((String)"FirebaseRemoteConfig", (String)"Activated configs are null.");
            }
            return true;
        }
        return false;
    }

    private final void zzb(Map<String, String> map) {
        try {
            zzen zzen2 = zzen.zzct().zzd(map).zzcv();
            this.zzjf.zzb(zzen2);
            return;
        }
        catch (JSONException jSONException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"The provided defaults map could not be processed.", (Throwable)jSONException);
            return;
        }
    }

    private final Task<Void> zzc(Map<String, String> map) {
        zzen zzen2;
        try {
            zzen2 = zzen.zzct().zzd(map).zzcv();
        }
        catch (JSONException jSONException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"The provided defaults map could not be processed.", (Throwable)jSONException);
            return Tasks.forResult(null);
        }
        zzen zzen3 = zzen2;
        return this.zzjf.zza(zzen3, true).onSuccessTask(zze.zzjk);
    }

    @VisibleForTesting
    private final void zza(@NonNull JSONArray jSONArray) {
        if (this.zzjc == null) {
            return;
        }
        try {
            JSONArray jSONArray2 = jSONArray;
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < jSONArray2.length(); ++i) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                JSONObject jSONObject = jSONArray2.getJSONObject(i);
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    hashMap.put(string, jSONObject.getString(string));
                }
                arrayList.add(hashMap);
            }
            ArrayList arrayList2 = arrayList;
            this.zzjc.replaceAllExperiments(arrayList2);
            return;
        }
        catch (JSONException jSONException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Could not parse ABT experiments from the JSON response.", (Throwable)jSONException);
            return;
        }
        catch (AbtException abtException) {
            Log.w((String)"FirebaseRemoteConfig", (String)"Could not update ABT experiments.", (Throwable)abtException);
            return;
        }
    }

    private static boolean zza(zzen zzen2, @Nullable zzen zzen3) {
        return zzen3 == null || !zzen2.zzcr().equals(zzen3.zzcr());
    }

    final /* synthetic */ Void zzcn() throws Exception {
        this.zzje.clear();
        this.zzjd.clear();
        this.zzjf.clear();
        this.zzji.clear();
        return null;
    }

    final /* synthetic */ Void zza(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) throws Exception {
        this.zzji.setConfigSettings(firebaseRemoteConfigSettings);
        if (firebaseRemoteConfigSettings.isDeveloperModeEnabled()) {
            Logger.getLogger(zzag.class.getName()).setLevel(Level.CONFIG);
        }
        return null;
    }

    final /* synthetic */ Task zza(Task task, Task task2, Task task3) throws Exception {
        zzen zzen2;
        if (!task.isSuccessful() || task.getResult() == null) {
            return Tasks.forResult((Object)false);
        }
        zzen zzen3 = (zzen)task.getResult();
        if (task2.isSuccessful() && !FirebaseRemoteConfig.zza(zzen3, zzen2 = (zzen)task2.getResult())) {
            return Tasks.forResult((Object)false);
        }
        zzen zzen4 = zzen3;
        return this.zzje.zza(zzen4, true).continueWith(this.executor, (Continuation)new zzd(this));
    }

    final /* synthetic */ void zza(zzen zzen2) {
        this.zzjd.clear();
        this.zza(zzen2.zzcs());
    }

    final /* synthetic */ void zzb(Task task) {
        Task task2 = task;
        FirebaseRemoteConfig firebaseRemoteConfig = this;
        if (task2.isSuccessful()) {
            firebaseRemoteConfig.zzji.zzm(-1);
            zzen zzen2 = ((zzet)task2.getResult()).zzcx();
            if (zzen2 != null) {
                firebaseRemoteConfig.zzji.zzf(zzen2.zzcr());
            }
            Log.i((String)"FirebaseRemoteConfig", (String)"Fetch succeeded!");
            return;
        }
        Exception exception = task2.getException();
        if (exception == null) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Fetch was cancelled... This should never covfefe");
            return;
        }
        if (exception instanceof FirebaseRemoteConfigFetchThrottledException) {
            firebaseRemoteConfig.zzji.zzm(2);
            Log.w((String)"FirebaseRemoteConfig", (String)"Fetch was throttled!", (Throwable)exception);
            return;
        }
        firebaseRemoteConfig.zzji.zzm(1);
        Log.e((String)"FirebaseRemoteConfig", (String)"Fetch failed!", (Throwable)exception);
    }

    final /* synthetic */ boolean zzc(Task task) {
        return this.zza((Task<zzen>)task);
    }
}

