/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.firebase_remote_config.zzab;
import com.google.android.gms.internal.firebase_remote_config.zzas;
import com.google.android.gms.internal.firebase_remote_config.zzbf;
import com.google.android.gms.internal.firebase_remote_config.zzby;
import com.google.android.gms.internal.firebase_remote_config.zzcx;
import com.google.android.gms.internal.firebase_remote_config.zzcy;
import com.google.android.gms.internal.firebase_remote_config.zzd;
import com.google.android.gms.internal.firebase_remote_config.zzde;
import com.google.android.gms.internal.firebase_remote_config.zzei;
import com.google.android.gms.internal.firebase_remote_config.zzes;
import com.google.android.gms.internal.firebase_remote_config.zzev;
import com.google.android.gms.internal.firebase_remote_config.zzew;
import com.google.android.gms.internal.firebase_remote_config.zzex;
import com.google.android.gms.internal.firebase_remote_config.zzfd;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.abt.FirebaseABTesting;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.zzo;
import com.google.firebase.remoteconfig.zzp;
import com.google.firebase.remoteconfig.zzq;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

@KeepForSdk
public class RemoteConfigComponent {
    private static final ExecutorService zzju = Executors.newCachedThreadPool();
    private static final Clock zzjv = DefaultClock.getInstance();
    private static final Random zzjw = new Random();
    @GuardedBy(value="this")
    private final Map<String, FirebaseRemoteConfig> zzjx = new HashMap<String, FirebaseRemoteConfig>();
    private final Context zzja;
    private final FirebaseApp zzjb;
    private final FirebaseInstanceId zzjy;
    private final FirebaseABTesting zzjc;
    @Nullable
    private final AnalyticsConnector zzjz;
    private final String appId;
    @GuardedBy(value="this")
    private Map<String, String> zzka = new HashMap<String, String>();
    @GuardedBy(value="this")
    private String zzg = "https://firebaseremoteconfig.googleapis.com/";

    RemoteConfigComponent(Context context, FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, FirebaseABTesting firebaseABTesting, @Nullable AnalyticsConnector analyticsConnector) {
        this(context, zzju, firebaseApp, firebaseInstanceId, firebaseABTesting, analyticsConnector, new zzfd(context, firebaseApp.getOptions().getApplicationId()));
    }

    @VisibleForTesting
    private RemoteConfigComponent(Context context, Executor executor, FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, FirebaseABTesting firebaseABTesting, @Nullable AnalyticsConnector analyticsConnector, zzfd zzfd2) {
        this.zzja = context;
        this.zzjb = firebaseApp;
        this.zzjy = firebaseInstanceId;
        this.zzjc = firebaseABTesting;
        this.zzjz = analyticsConnector;
        this.appId = firebaseApp.getOptions().getApplicationId();
        Tasks.call((Executor)executor, (Callable)new zzo(this));
        zzfd zzfd3 = zzfd2;
        zzfd3.getClass();
        Tasks.call((Executor)executor, (Callable)zzq.zza(zzfd3));
    }

    @KeepForSdk
    public synchronized FirebaseRemoteConfig get(String string) {
        zzei zzei2 = this.zzd(string, "fetch");
        zzei zzei3 = this.zzd(string, "activate");
        zzei zzei4 = this.zzd(string, "defaults");
        Object object = string;
        Object object2 = this.appId;
        Object object3 = this.zzja;
        Object object4 = String.format("%s_%s_%s_%s", "frc", object2, object, "settings");
        SharedPreferences sharedPreferences = object3.getSharedPreferences((String)object4, 0);
        zzev zzev2 = new zzev(sharedPreferences);
        object4 = zzev2;
        object = zzei2;
        object2 = string;
        object3 = this;
        zzes zzes2 = new zzes(((RemoteConfigComponent)object3).zzja, ((RemoteConfigComponent)object3).zzjb.getOptions().getApplicationId(), ((RemoteConfigComponent)object3).zzjy, ((RemoteConfigComponent)object3).zzjz, (String)object2, zzju, zzjv, zzjw, (zzei)object, super.zza(((RemoteConfigComponent)object3).zzjb.getOptions().getApiKey(), (zzev)object4), (zzev)object4);
        object2 = zzei4;
        object3 = zzei3;
        return this.zza(this.zzjb, string, this.zzjc, zzju, zzei2, zzei3, zzei4, zzes2, new zzew((zzei)object3, (zzei)object2), zzev2);
    }

    @VisibleForTesting
    private final synchronized FirebaseRemoteConfig zza(FirebaseApp firebaseApp, String string, FirebaseABTesting firebaseABTesting, Executor executor, zzei zzei2, zzei zzei3, zzei zzei4, zzes zzes2, zzew zzew2, zzev zzev2) {
        if (!this.zzjx.containsKey(string)) {
            FirebaseRemoteConfig firebaseRemoteConfig = new FirebaseRemoteConfig(this.zzja, firebaseApp, (FirebaseABTesting)(string.equals("firebase") ? firebaseABTesting : null), executor, zzei2, zzei3, zzei4, zzes2, zzew2, zzev2);
            firebaseRemoteConfig.zzcm();
            this.zzjx.put(string, firebaseRemoteConfig);
        }
        return this.zzjx.get(string);
    }

    private final zzei zzd(String string, String string2) {
        return RemoteConfigComponent.zza(this.zzja, this.appId, string, string2);
    }

    public static zzei zza(Context context, String string, String string2, String string3) {
        String string4 = String.format("%s_%s_%s_%s.json", "frc", string, string2, string3);
        return zzei.zza(zzju, zzex.zzb(context, string4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final zzcy zza(String string, zzev zzev2) {
        zzde zzde2 = new zzde(string);
        RemoteConfigComponent remoteConfigComponent = this;
        synchronized (remoteConfigComponent) {
            return ((zzcx)((zzd.zza)new zzcx(new zzas(), zzbf.zzbq(), new zzp(this, zzev2))).zzc(this.zzg)).zza(zzde2).zzce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void zza(zzev zzev2, zzab zzab2) throws IOException {
        int n = (int)TimeUnit.SECONDS.toMillis(zzev2.getFetchTimeoutInSeconds());
        zzab2.zza(n);
        zzab2.zzb((int)TimeUnit.SECONDS.toMillis(5L));
        RemoteConfigComponent remoteConfigComponent = this;
        synchronized (remoteConfigComponent) {
            for (Map.Entry<String, String> entry : this.zzka.entrySet()) {
                ((zzby)zzab2.zzx()).zzb(entry.getKey(), entry.getValue());
            }
            return;
        }
    }
}

