/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.internal.ConfigCacheClient;
import com.google.firebase.remoteconfig.internal.ConfigContainer;
import com.google.firebase.remoteconfig.internal.FirebaseRemoteConfigValueImpl;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigGetParameterHandler {
    @VisibleForTesting(otherwise=3)
    public static final Charset FRC_BYTE_ARRAY_ENCODING = Charset.forName("UTF-8");
    static final Pattern TRUE_REGEX = Pattern.compile("^(1|true|t|yes|y|on)$", 2);
    static final Pattern FALSE_REGEX = Pattern.compile("^(0|false|f|no|n|off|)$", 2);
    private final ConfigCacheClient activatedConfigsCache;
    private final ConfigCacheClient defaultConfigsCache;

    public ConfigGetParameterHandler(ConfigCacheClient activatedConfigsCache, ConfigCacheClient defaultConfigsCache) {
        this.activatedConfigsCache = activatedConfigsCache;
        this.defaultConfigsCache = defaultConfigsCache;
    }

    public String getString(String key) {
        String activatedString = ConfigGetParameterHandler.getStringFromCache(this.activatedConfigsCache, key);
        if (activatedString != null) {
            return activatedString;
        }
        String defaultsString = ConfigGetParameterHandler.getStringFromCache(this.defaultConfigsCache, key);
        if (defaultsString != null) {
            return defaultsString;
        }
        ConfigGetParameterHandler.logParameterValueDoesNotExist(key, "String");
        return "";
    }

    public boolean getBoolean(String key) {
        String defaultsString;
        String activatedString = ConfigGetParameterHandler.getStringFromCache(this.activatedConfigsCache, key);
        if (activatedString != null) {
            if (TRUE_REGEX.matcher(activatedString).matches()) {
                return true;
            }
            if (FALSE_REGEX.matcher(activatedString).matches()) {
                return false;
            }
        }
        if ((defaultsString = ConfigGetParameterHandler.getStringFromCache(this.defaultConfigsCache, key)) != null) {
            if (TRUE_REGEX.matcher(defaultsString).matches()) {
                return true;
            }
            if (FALSE_REGEX.matcher(defaultsString).matches()) {
                return false;
            }
        }
        ConfigGetParameterHandler.logParameterValueDoesNotExist(key, "Boolean");
        return false;
    }

    public byte[] getByteArray(String key) {
        String activatedString = ConfigGetParameterHandler.getStringFromCache(this.activatedConfigsCache, key);
        if (activatedString != null) {
            return activatedString.getBytes(FRC_BYTE_ARRAY_ENCODING);
        }
        String defaultsString = ConfigGetParameterHandler.getStringFromCache(this.defaultConfigsCache, key);
        if (defaultsString != null) {
            return defaultsString.getBytes(FRC_BYTE_ARRAY_ENCODING);
        }
        ConfigGetParameterHandler.logParameterValueDoesNotExist(key, "ByteArray");
        return FirebaseRemoteConfig.DEFAULT_VALUE_FOR_BYTE_ARRAY;
    }

    public double getDouble(String key) {
        Double activatedDouble = ConfigGetParameterHandler.getDoubleFromCache(this.activatedConfigsCache, key);
        if (activatedDouble != null) {
            return activatedDouble;
        }
        Double defaultsDouble = ConfigGetParameterHandler.getDoubleFromCache(this.defaultConfigsCache, key);
        if (defaultsDouble != null) {
            return defaultsDouble;
        }
        ConfigGetParameterHandler.logParameterValueDoesNotExist(key, "Double");
        return 0.0;
    }

    public long getLong(String key) {
        Long activatedLong = ConfigGetParameterHandler.getLongFromCache(this.activatedConfigsCache, key);
        if (activatedLong != null) {
            return activatedLong;
        }
        Long defaultsLong = ConfigGetParameterHandler.getLongFromCache(this.defaultConfigsCache, key);
        if (defaultsLong != null) {
            return defaultsLong;
        }
        ConfigGetParameterHandler.logParameterValueDoesNotExist(key, "Long");
        return 0L;
    }

    public FirebaseRemoteConfigValue getValue(String key) {
        String activatedString = ConfigGetParameterHandler.getStringFromCache(this.activatedConfigsCache, key);
        if (activatedString != null) {
            return new FirebaseRemoteConfigValueImpl(activatedString, 2);
        }
        String defaultsString = ConfigGetParameterHandler.getStringFromCache(this.defaultConfigsCache, key);
        if (defaultsString != null) {
            return new FirebaseRemoteConfigValueImpl(defaultsString, 1);
        }
        ConfigGetParameterHandler.logParameterValueDoesNotExist(key, "FirebaseRemoteConfigValue");
        return new FirebaseRemoteConfigValueImpl("", 0);
    }

    public Set<String> getKeysByPrefix(String prefix) {
        ConfigContainer defaultsConfigs;
        if (prefix == null) {
            prefix = "";
        }
        TreeSet<String> keysWithPrefix = new TreeSet<String>();
        ConfigContainer activatedConfigs = ConfigGetParameterHandler.getConfigsFromCache(this.activatedConfigsCache);
        if (activatedConfigs != null) {
            keysWithPrefix.addAll(ConfigGetParameterHandler.getKeysByPrefix(prefix, activatedConfigs));
        }
        if ((defaultsConfigs = ConfigGetParameterHandler.getConfigsFromCache(this.defaultConfigsCache)) != null) {
            keysWithPrefix.addAll(ConfigGetParameterHandler.getKeysByPrefix(prefix, defaultsConfigs));
        }
        return keysWithPrefix;
    }

    private static TreeSet<String> getKeysByPrefix(String prefix, ConfigContainer configs) {
        TreeSet<String> keysWithPrefix = new TreeSet<String>();
        Iterator stringIterator = configs.getConfigs().keys();
        while (stringIterator.hasNext()) {
            String currentKey = (String)stringIterator.next();
            if (!currentKey.startsWith(prefix)) continue;
            keysWithPrefix.add(currentKey);
        }
        return keysWithPrefix;
    }

    public Map<String, FirebaseRemoteConfigValue> getAll() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(ConfigGetParameterHandler.getKeySetFromCache(this.activatedConfigsCache));
        keySet.addAll(ConfigGetParameterHandler.getKeySetFromCache(this.defaultConfigsCache));
        HashMap<String, FirebaseRemoteConfigValue> allConfigs = new HashMap<String, FirebaseRemoteConfigValue>();
        for (String key : keySet) {
            allConfigs.put(key, this.getValue(key));
        }
        return allConfigs;
    }

    @Nullable
    private static String getStringFromCache(ConfigCacheClient cacheClient, String key) {
        ConfigContainer cachedContainer = ConfigGetParameterHandler.getConfigsFromCache(cacheClient);
        if (cachedContainer == null) {
            return null;
        }
        try {
            return cachedContainer.getConfigs().getString(key);
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    private static Double getDoubleFromCache(ConfigCacheClient cacheClient, String key) {
        ConfigContainer cachedContainer = ConfigGetParameterHandler.getConfigsFromCache(cacheClient);
        if (cachedContainer == null) {
            return null;
        }
        try {
            return cachedContainer.getConfigs().getDouble(key);
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    private static Long getLongFromCache(ConfigCacheClient cacheClient, String key) {
        ConfigContainer cachedContainer = ConfigGetParameterHandler.getConfigsFromCache(cacheClient);
        if (cachedContainer == null) {
            return null;
        }
        try {
            return cachedContainer.getConfigs().getLong(key);
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    private static Set<String> getKeySetFromCache(ConfigCacheClient cacheClient) {
        HashSet<String> keySet = new HashSet<String>();
        ConfigContainer configContainer = ConfigGetParameterHandler.getConfigsFromCache(cacheClient);
        if (configContainer == null) {
            return keySet;
        }
        JSONObject configs = configContainer.getConfigs();
        Iterator keyIterator = configs.keys();
        while (keyIterator.hasNext()) {
            keySet.add((String)keyIterator.next());
        }
        return keySet;
    }

    @Nullable
    private static ConfigContainer getConfigsFromCache(ConfigCacheClient cacheClient) {
        return cacheClient.getBlocking();
    }

    private static void logParameterValueDoesNotExist(String key, String valueType) {
        Log.w((String)"FirebaseRemoteConfig", (String)String.format("No value of type '%s' exists for parameter key '%s'.", valueType, key));
    }
}

