/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.XmlRes;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.abt.AbtException;
import com.google.firebase.abt.FirebaseABTesting;
import com.google.firebase.concurrent.FirebaseExecutors;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.RemoteConfigComponent;
import com.google.firebase.remoteconfig.internal.ConfigCacheClient;
import com.google.firebase.remoteconfig.internal.ConfigContainer;
import com.google.firebase.remoteconfig.internal.ConfigFetchHandler;
import com.google.firebase.remoteconfig.internal.ConfigGetParameterHandler;
import com.google.firebase.remoteconfig.internal.ConfigMetadataClient;
import com.google.firebase.remoteconfig.internal.DefaultsXmlParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    public static final String TAG = "FirebaseRemoteConfig";
    private final Context context;
    private final FirebaseApp firebaseApp;
    @Nullable
    private final FirebaseABTesting firebaseAbt;
    private final Executor executor;
    private final ConfigCacheClient fetchedConfigsCache;
    private final ConfigCacheClient activatedConfigsCache;
    private final ConfigCacheClient defaultConfigsCache;
    private final ConfigFetchHandler fetchHandler;
    private final ConfigGetParameterHandler getHandler;
    private final ConfigMetadataClient frcMetadata;
    private final FirebaseInstallationsApi firebaseInstallations;

    @NonNull
    public static FirebaseRemoteConfig getInstance() {
        return FirebaseRemoteConfig.getInstance(FirebaseApp.getInstance());
    }

    @NonNull
    public static FirebaseRemoteConfig getInstance(@NonNull FirebaseApp app) {
        return ((RemoteConfigComponent)app.get(RemoteConfigComponent.class)).getDefault();
    }

    FirebaseRemoteConfig(Context context, FirebaseApp firebaseApp, FirebaseInstallationsApi firebaseInstallations, @Nullable FirebaseABTesting firebaseAbt, Executor executor, ConfigCacheClient fetchedConfigsCache, ConfigCacheClient activatedConfigsCache, ConfigCacheClient defaultConfigsCache, ConfigFetchHandler fetchHandler, ConfigGetParameterHandler getHandler, ConfigMetadataClient frcMetadata) {
        this.context = context;
        this.firebaseApp = firebaseApp;
        this.firebaseInstallations = firebaseInstallations;
        this.firebaseAbt = firebaseAbt;
        this.executor = executor;
        this.fetchedConfigsCache = fetchedConfigsCache;
        this.activatedConfigsCache = activatedConfigsCache;
        this.defaultConfigsCache = defaultConfigsCache;
        this.fetchHandler = fetchHandler;
        this.getHandler = getHandler;
        this.frcMetadata = frcMetadata;
    }

    @NonNull
    public Task<FirebaseRemoteConfigInfo> ensureInitialized() {
        Task<ConfigContainer> activatedConfigsTask = this.activatedConfigsCache.get();
        Task<ConfigContainer> defaultsConfigsTask = this.defaultConfigsCache.get();
        Task<ConfigContainer> fetchedConfigsTask = this.fetchedConfigsCache.get();
        Task metadataTask = Tasks.call((Executor)this.executor, this::getInfo);
        Task installationIdTask = this.firebaseInstallations.getId();
        Task installationTokenTask = this.firebaseInstallations.getToken(false);
        return Tasks.whenAllComplete((Task[])new Task[]{activatedConfigsTask, defaultsConfigsTask, fetchedConfigsTask, metadataTask, installationIdTask, installationTokenTask}).continueWith(this.executor, unusedListOfCompletedTasks -> (FirebaseRemoteConfigInfo)metadataTask.getResult());
    }

    @NonNull
    public Task<Boolean> fetchAndActivate() {
        return this.fetch().onSuccessTask(this.executor, unusedVoid -> this.activate());
    }

    @NonNull
    public Task<Boolean> activate() {
        Task<ConfigContainer> fetchedConfigsTask = this.fetchedConfigsCache.get();
        Task<ConfigContainer> activatedConfigsTask = this.activatedConfigsCache.get();
        return Tasks.whenAllComplete((Task[])new Task[]{fetchedConfigsTask, activatedConfigsTask}).continueWithTask(this.executor, unusedListOfCompletedTasks -> {
            ConfigContainer activatedContainer;
            if (!fetchedConfigsTask.isSuccessful() || fetchedConfigsTask.getResult() == null) {
                return Tasks.forResult((Object)false);
            }
            ConfigContainer fetchedContainer = (ConfigContainer)fetchedConfigsTask.getResult();
            if (activatedConfigsTask.isSuccessful() && !FirebaseRemoteConfig.isFetchedFresh(fetchedContainer, activatedContainer = (ConfigContainer)activatedConfigsTask.getResult())) {
                return Tasks.forResult((Object)false);
            }
            return this.activatedConfigsCache.put(fetchedContainer).continueWith(this.executor, this::processActivatePutTask);
        });
    }

    @NonNull
    public Task<Void> fetch() {
        Task<ConfigFetchHandler.FetchResponse> fetchTask = this.fetchHandler.fetch();
        return fetchTask.onSuccessTask(FirebaseExecutors.directExecutor(), unusedFetchResponse -> Tasks.forResult(null));
    }

    @NonNull
    public Task<Void> fetch(long minimumFetchIntervalInSeconds) {
        Task<ConfigFetchHandler.FetchResponse> fetchTask = this.fetchHandler.fetch(minimumFetchIntervalInSeconds);
        return fetchTask.onSuccessTask(FirebaseExecutors.directExecutor(), unusedFetchResponse -> Tasks.forResult(null));
    }

    @NonNull
    public String getString(@NonNull String key) {
        return this.getHandler.getString(key);
    }

    public boolean getBoolean(@NonNull String key) {
        return this.getHandler.getBoolean(key);
    }

    public double getDouble(@NonNull String key) {
        return this.getHandler.getDouble(key);
    }

    public long getLong(@NonNull String key) {
        return this.getHandler.getLong(key);
    }

    @NonNull
    public FirebaseRemoteConfigValue getValue(@NonNull String key) {
        return this.getHandler.getValue(key);
    }

    @NonNull
    public Set<String> getKeysByPrefix(@NonNull String prefix) {
        return this.getHandler.getKeysByPrefix(prefix);
    }

    @NonNull
    public Map<String, FirebaseRemoteConfigValue> getAll() {
        return this.getHandler.getAll();
    }

    @NonNull
    public FirebaseRemoteConfigInfo getInfo() {
        return this.frcMetadata.getInfo();
    }

    @NonNull
    public Task<Void> setConfigSettingsAsync(@NonNull FirebaseRemoteConfigSettings settings) {
        return Tasks.call((Executor)this.executor, () -> {
            this.frcMetadata.setConfigSettings(settings);
            return null;
        });
    }

    @NonNull
    public Task<Void> setDefaultsAsync(@NonNull Map<String, Object> defaults) {
        HashMap<String, String> defaultsStringMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> defaultsEntry : defaults.entrySet()) {
            Object value = defaultsEntry.getValue();
            if (value instanceof byte[]) {
                defaultsStringMap.put(defaultsEntry.getKey(), new String((byte[])value));
                continue;
            }
            defaultsStringMap.put(defaultsEntry.getKey(), value.toString());
        }
        return this.setDefaultsWithStringsMapAsync(defaultsStringMap);
    }

    @NonNull
    public Task<Void> setDefaultsAsync(@XmlRes int resourceId) {
        Map<String, String> xmlDefaults = DefaultsXmlParser.getDefaultsFromXml(this.context, resourceId);
        return this.setDefaultsWithStringsMapAsync(xmlDefaults);
    }

    @NonNull
    public Task<Void> reset() {
        return Tasks.call((Executor)this.executor, () -> {
            this.activatedConfigsCache.clear();
            this.fetchedConfigsCache.clear();
            this.defaultConfigsCache.clear();
            this.frcMetadata.clear();
            return null;
        });
    }

    void startLoadingConfigsFromDisk() {
        this.activatedConfigsCache.get();
        this.defaultConfigsCache.get();
        this.fetchedConfigsCache.get();
    }

    private boolean processActivatePutTask(Task<ConfigContainer> putTask) {
        if (putTask.isSuccessful()) {
            this.fetchedConfigsCache.clear();
            if (putTask.getResult() != null) {
                this.updateAbtWithActivatedExperiments(((ConfigContainer)putTask.getResult()).getAbtExperiments());
            } else {
                Log.e((String)TAG, (String)"Activated configs written to disk are null.");
            }
            return true;
        }
        return false;
    }

    private Task<Void> setDefaultsWithStringsMapAsync(Map<String, String> defaultsStringMap) {
        ConfigContainer defaultConfigs = null;
        try {
            defaultConfigs = ConfigContainer.newBuilder().replaceConfigsWith(defaultsStringMap).build();
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"The provided defaults map could not be processed.", (Throwable)e);
            return Tasks.forResult(null);
        }
        Task<ConfigContainer> putTask = this.defaultConfigsCache.put(defaultConfigs);
        return putTask.onSuccessTask(FirebaseExecutors.directExecutor(), unusedContainer -> Tasks.forResult(null));
    }

    @VisibleForTesting
    void updateAbtWithActivatedExperiments(@NonNull JSONArray abtExperiments) {
        if (this.firebaseAbt == null) {
            return;
        }
        try {
            List<Map<String, String>> experimentInfoMaps = FirebaseRemoteConfig.toExperimentInfoMaps(abtExperiments);
            this.firebaseAbt.replaceAllExperiments(experimentInfoMaps);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Could not parse ABT experiments from the JSON response.", (Throwable)e);
        }
        catch (AbtException e) {
            Log.w((String)TAG, (String)"Could not update ABT experiments.", (Throwable)e);
        }
    }

    @VisibleForTesting
    static List<Map<String, String>> toExperimentInfoMaps(JSONArray abtExperimentsJson) throws JSONException {
        ArrayList<Map<String, String>> experimentInfoMaps = new ArrayList<Map<String, String>>();
        for (int index = 0; index < abtExperimentsJson.length(); ++index) {
            HashMap<String, String> experimentInfo = new HashMap<String, String>();
            JSONObject abtExperimentJson = abtExperimentsJson.getJSONObject(index);
            Iterator experimentJsonKeyIterator = abtExperimentJson.keys();
            while (experimentJsonKeyIterator.hasNext()) {
                String key = (String)experimentJsonKeyIterator.next();
                experimentInfo.put(key, abtExperimentJson.getString(key));
            }
            experimentInfoMaps.add(experimentInfo);
        }
        return experimentInfoMaps;
    }

    private static boolean isFetchedFresh(ConfigContainer fetched, @Nullable ConfigContainer activated) {
        return activated == null || !fetched.getFetchTime().equals(activated.getFetchTime());
    }
}

