/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;

public class FirebaseRemoteConfigInfoImpl
implements FirebaseRemoteConfigInfo {
    private final long lastSuccessfulFetchTimeInMillis;
    private final int lastFetchStatus;
    private final FirebaseRemoteConfigSettings configSettings;

    private FirebaseRemoteConfigInfoImpl(long lastSuccessfulFetchTimeInMillis, int lastFetchStatus, FirebaseRemoteConfigSettings configSettings) {
        this.lastSuccessfulFetchTimeInMillis = lastSuccessfulFetchTimeInMillis;
        this.lastFetchStatus = lastFetchStatus;
        this.configSettings = configSettings;
    }

    @Override
    public long getFetchTimeMillis() {
        return this.lastSuccessfulFetchTimeInMillis;
    }

    @Override
    public int getLastFetchStatus() {
        return this.lastFetchStatus;
    }

    @Override
    public FirebaseRemoteConfigSettings getConfigSettings() {
        return this.configSettings;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long builderLastSuccessfulFetchTimeInMillis;
        private int builderLastFetchStatus;
        private FirebaseRemoteConfigSettings builderConfigSettings;

        private Builder() {
        }

        public Builder withLastSuccessfulFetchTimeInMillis(long fetchTimeInMillis) {
            this.builderLastSuccessfulFetchTimeInMillis = fetchTimeInMillis;
            return this;
        }

        Builder withLastFetchStatus(int lastFetchStatus) {
            this.builderLastFetchStatus = lastFetchStatus;
            return this;
        }

        Builder withConfigSettings(FirebaseRemoteConfigSettings configSettings) {
            this.builderConfigSettings = configSettings;
            return this;
        }

        public FirebaseRemoteConfigInfoImpl build() {
            return new FirebaseRemoteConfigInfoImpl(this.builderLastSuccessfulFetchTimeInMillis, this.builderLastFetchStatus, this.builderConfigSettings);
        }
    }
}

