/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;

public class CustomSignals {
    final Map<String, String> customSignals;

    CustomSignals(@NonNull Builder builder) {
        this.customSignals = builder.customSignals;
    }

    public static class Builder {
        private Map<String, String> customSignals = new HashMap<String, String>();

        @NonNull
        public Builder put(@NonNull String key, @Nullable String value) {
            this.customSignals.put(key, value);
            return this;
        }

        @NonNull
        public Builder put(@NonNull String key, long value) {
            this.customSignals.put(key, Long.toString(value));
            return this;
        }

        @NonNull
        public Builder put(@NonNull String key, double value) {
            this.customSignals.put(key, Double.toString(value));
            return this;
        }

        @NonNull
        public CustomSignals build() {
            return new CustomSignals(this);
        }
    }
}

