/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import com.google.firebase.FirebaseApp;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.remoteconfig.ConfigUpdateListener;
import com.google.firebase.remoteconfig.ConfigUpdateListenerRegistration;
import com.google.firebase.remoteconfig.internal.ConfigCacheClient;
import com.google.firebase.remoteconfig.internal.ConfigFetchHandler;
import com.google.firebase.remoteconfig.internal.ConfigRealtimeHttpClient;
import com.google.firebase.remoteconfig.internal.ConfigSharedPrefsClient;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;

public class ConfigRealtimeHandler {
    @GuardedBy(value="this")
    private final Set<ConfigUpdateListener> listeners = new LinkedHashSet<ConfigUpdateListener>();
    @GuardedBy(value="this")
    private final ConfigRealtimeHttpClient configRealtimeHttpClient;
    private final ConfigFetchHandler configFetchHandler;
    private final FirebaseApp firebaseApp;
    private final FirebaseInstallationsApi firebaseInstallations;
    private final ConfigCacheClient activatedCacheClient;
    private final Context context;
    private final String namespace;
    private final ConfigSharedPrefsClient sharedPrefsClient;
    private final ScheduledExecutorService scheduledExecutorService;

    public ConfigRealtimeHandler(FirebaseApp firebaseApp, FirebaseInstallationsApi firebaseInstallations, ConfigFetchHandler configFetchHandler, ConfigCacheClient activatedCacheClient, Context context, String namespace, ConfigSharedPrefsClient sharedPrefsClient, ScheduledExecutorService scheduledExecutorService) {
        this.configRealtimeHttpClient = new ConfigRealtimeHttpClient(firebaseApp, firebaseInstallations, configFetchHandler, activatedCacheClient, context, namespace, this.listeners, sharedPrefsClient, scheduledExecutorService);
        this.firebaseApp = firebaseApp;
        this.configFetchHandler = configFetchHandler;
        this.firebaseInstallations = firebaseInstallations;
        this.activatedCacheClient = activatedCacheClient;
        this.context = context;
        this.namespace = namespace;
        this.sharedPrefsClient = sharedPrefsClient;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    private synchronized void beginRealtime() {
        if (!this.listeners.isEmpty()) {
            this.configRealtimeHttpClient.startHttpConnection();
        }
    }

    @NonNull
    public synchronized ConfigUpdateListenerRegistration addRealtimeConfigUpdateListener(@NonNull ConfigUpdateListener configUpdateListener) {
        this.listeners.add(configUpdateListener);
        this.beginRealtime();
        return new ConfigUpdateListenerRegistrationInternal(configUpdateListener);
    }

    public synchronized void setBackgroundState(boolean isInBackground) {
        this.configRealtimeHttpClient.setIsInBackground(isInBackground);
        if (!isInBackground) {
            this.beginRealtime();
        }
    }

    private synchronized void removeRealtimeConfigUpdateListener(ConfigUpdateListener listener) {
        this.listeners.remove(listener);
    }

    public class ConfigUpdateListenerRegistrationInternal
    implements ConfigUpdateListenerRegistration {
        private final ConfigUpdateListener listener;

        public ConfigUpdateListenerRegistrationInternal(ConfigUpdateListener listener) {
            this.listener = listener;
        }

        @Override
        public void remove() {
            ConfigRealtimeHandler.this.removeRealtimeConfigUpdateListener(this.listener);
        }
    }
}

