/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.internal.ConfigFetchHandler;
import com.google.firebase.remoteconfig.internal.FirebaseRemoteConfigInfoImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigSharedPrefsClient {
    @VisibleForTesting
    public static final long LAST_FETCH_TIME_IN_MILLIS_NO_FETCH_YET = -1L;
    static final Date LAST_FETCH_TIME_NO_FETCH_YET = new Date(-1L);
    static final int NO_FAILED_REALTIME_STREAMS = 0;
    @VisibleForTesting
    static final int NO_FAILED_FETCHES = 0;
    private static final long NO_BACKOFF_TIME_IN_MILLIS = -1L;
    @VisibleForTesting
    static final Date NO_BACKOFF_TIME = new Date(-1L);
    private static final String FETCH_TIMEOUT_IN_SECONDS_KEY = "fetch_timeout_in_seconds";
    private static final String MINIMUM_FETCH_INTERVAL_IN_SECONDS_KEY = "minimum_fetch_interval_in_seconds";
    private static final String LAST_FETCH_STATUS_KEY = "last_fetch_status";
    private static final String LAST_SUCCESSFUL_FETCH_TIME_IN_MILLIS_KEY = "last_fetch_time_in_millis";
    private static final String LAST_FETCH_ETAG_KEY = "last_fetch_etag";
    private static final String BACKOFF_END_TIME_IN_MILLIS_KEY = "backoff_end_time_in_millis";
    private static final String NUM_FAILED_FETCHES_KEY = "num_failed_fetches";
    private static final String LAST_TEMPLATE_VERSION = "last_template_version";
    private static final String NUM_FAILED_REALTIME_STREAMS_KEY = "num_failed_realtime_streams";
    private static final String REALTIME_BACKOFF_END_TIME_IN_MILLIS_KEY = "realtime_backoff_end_time_in_millis";
    private static final int CUSTOM_SIGNALS_MAX_KEY_LENGTH = 250;
    private static final int CUSTOM_SIGNALS_MAX_STRING_VALUE_LENGTH = 500;
    private static final int CUSTOM_SIGNALS_MAX_COUNT = 100;
    private final SharedPreferences frcSharedPrefs;
    private final Object frcInfoLock;
    private final Object backoffMetadataLock;
    private final Object realtimeBackoffMetadataLock;
    private final Object customSignalsLock;

    public ConfigSharedPrefsClient(SharedPreferences frcSharedPrefs) {
        this.frcSharedPrefs = frcSharedPrefs;
        this.frcInfoLock = new Object();
        this.backoffMetadataLock = new Object();
        this.realtimeBackoffMetadataLock = new Object();
        this.customSignalsLock = new Object();
    }

    public long getFetchTimeoutInSeconds() {
        return this.frcSharedPrefs.getLong(FETCH_TIMEOUT_IN_SECONDS_KEY, 60L);
    }

    public long getMinimumFetchIntervalInSeconds() {
        return this.frcSharedPrefs.getLong(MINIMUM_FETCH_INTERVAL_IN_SECONDS_KEY, ConfigFetchHandler.DEFAULT_MINIMUM_FETCH_INTERVAL_IN_SECONDS);
    }

    int getLastFetchStatus() {
        return this.frcSharedPrefs.getInt(LAST_FETCH_STATUS_KEY, 0);
    }

    Date getLastSuccessfulFetchTime() {
        return new Date(this.frcSharedPrefs.getLong(LAST_SUCCESSFUL_FETCH_TIME_IN_MILLIS_KEY, -1L));
    }

    @Nullable
    String getLastFetchETag() {
        return this.frcSharedPrefs.getString(LAST_FETCH_ETAG_KEY, null);
    }

    long getLastTemplateVersion() {
        return this.frcSharedPrefs.getLong(LAST_TEMPLATE_VERSION, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigInfo getInfo() {
        Object object = this.frcInfoLock;
        synchronized (object) {
            long lastSuccessfulFetchTimeInMillis = this.frcSharedPrefs.getLong(LAST_SUCCESSFUL_FETCH_TIME_IN_MILLIS_KEY, -1L);
            int lastFetchStatus = this.frcSharedPrefs.getInt(LAST_FETCH_STATUS_KEY, 0);
            FirebaseRemoteConfigSettings settings = new FirebaseRemoteConfigSettings.Builder().setFetchTimeoutInSeconds(this.frcSharedPrefs.getLong(FETCH_TIMEOUT_IN_SECONDS_KEY, 60L)).setMinimumFetchIntervalInSeconds(this.frcSharedPrefs.getLong(MINIMUM_FETCH_INTERVAL_IN_SECONDS_KEY, ConfigFetchHandler.DEFAULT_MINIMUM_FETCH_INTERVAL_IN_SECONDS)).build();
            return FirebaseRemoteConfigInfoImpl.newBuilder().withLastFetchStatus(lastFetchStatus).withLastSuccessfulFetchTimeInMillis(lastSuccessfulFetchTimeInMillis).withConfigSettings(settings).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void clear() {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcSharedPrefs.edit().clear().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void setConfigSettings(FirebaseRemoteConfigSettings settings) {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcSharedPrefs.edit().putLong(FETCH_TIMEOUT_IN_SECONDS_KEY, settings.getFetchTimeoutInSeconds()).putLong(MINIMUM_FETCH_INTERVAL_IN_SECONDS_KEY, settings.getMinimumFetchIntervalInSeconds()).commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigSettingsWithoutWaitingOnDiskWrite(FirebaseRemoteConfigSettings settings) {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcSharedPrefs.edit().putLong(FETCH_TIMEOUT_IN_SECONDS_KEY, settings.getFetchTimeoutInSeconds()).putLong(MINIMUM_FETCH_INTERVAL_IN_SECONDS_KEY, settings.getMinimumFetchIntervalInSeconds()).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastFetchAsSuccessfulAt(Date fetchTime) {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcSharedPrefs.edit().putInt(LAST_FETCH_STATUS_KEY, -1).putLong(LAST_SUCCESSFUL_FETCH_TIME_IN_MILLIS_KEY, fetchTime.getTime()).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastFetchAsFailed() {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcSharedPrefs.edit().putInt(LAST_FETCH_STATUS_KEY, 1).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastFetchAsThrottled() {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcSharedPrefs.edit().putInt(LAST_FETCH_STATUS_KEY, 2).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastFetchETag(String eTag) {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcSharedPrefs.edit().putString(LAST_FETCH_ETAG_KEY, eTag).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastTemplateVersion(long templateVersion) {
        Object object = this.frcInfoLock;
        synchronized (object) {
            this.frcSharedPrefs.edit().putLong(LAST_TEMPLATE_VERSION, templateVersion).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackoffMetadata getBackoffMetadata() {
        Object object = this.backoffMetadataLock;
        synchronized (object) {
            return new BackoffMetadata(this.frcSharedPrefs.getInt(NUM_FAILED_FETCHES_KEY, 0), new Date(this.frcSharedPrefs.getLong(BACKOFF_END_TIME_IN_MILLIS_KEY, -1L)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBackoffMetadata(int numFailedFetches, Date backoffEndTime) {
        Object object = this.backoffMetadataLock;
        synchronized (object) {
            this.frcSharedPrefs.edit().putInt(NUM_FAILED_FETCHES_KEY, numFailedFetches).putLong(BACKOFF_END_TIME_IN_MILLIS_KEY, backoffEndTime.getTime()).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomSignals(Map<String, String> newCustomSignals) {
        Object object = this.customSignalsLock;
        synchronized (object) {
            Map<String, String> existingCustomSignals = this.getCustomSignals();
            boolean modified = false;
            for (Map.Entry<String, String> entry : newCustomSignals.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key.length() > 250 || value != null && value.length() > 500) {
                    Log.w((String)"FirebaseRemoteConfig", (String)String.format("Invalid custom signal: Custom signal keys must be %d characters or less, and values must be %d characters or less.", 250, 500));
                    return;
                }
                if (value != null) {
                    modified |= !Objects.equals(existingCustomSignals.put(key, value), value);
                    continue;
                }
                modified |= existingCustomSignals.remove(key) != null;
            }
            if (!modified) {
                return;
            }
            if (existingCustomSignals.size() > 100) {
                Log.w((String)"FirebaseRemoteConfig", (String)String.format("Invalid custom signal: Too many custom signals provided. The maximum allowed is %d.", 100));
                return;
            }
            this.frcSharedPrefs.edit().putString("customSignals", new JSONObject(existingCustomSignals).toString()).commit();
            Log.d((String)"FirebaseRemoteConfig", (String)("Keys of updated custom signals: " + this.getCustomSignals().keySet()));
        }
    }

    public Map<String, String> getCustomSignals() {
        String jsonString = this.frcSharedPrefs.getString("customSignals", "{}");
        try {
            JSONObject existingCustomSignalsJson = new JSONObject(jsonString);
            HashMap<String, String> custom_signals = new HashMap<String, String>();
            Iterator keys = existingCustomSignalsJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = existingCustomSignalsJson.optString(key);
                custom_signals.put(key, value);
            }
            return custom_signals;
        }
        catch (JSONException e) {
            return new HashMap<String, String>();
        }
    }

    void resetBackoff() {
        this.setBackoffMetadata(0, NO_BACKOFF_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public RealtimeBackoffMetadata getRealtimeBackoffMetadata() {
        Object object = this.realtimeBackoffMetadataLock;
        synchronized (object) {
            return new RealtimeBackoffMetadata(this.frcSharedPrefs.getInt(NUM_FAILED_REALTIME_STREAMS_KEY, 0), new Date(this.frcSharedPrefs.getLong(REALTIME_BACKOFF_END_TIME_IN_MILLIS_KEY, -1L)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRealtimeBackoffMetadata(int numFailedStreams, Date backoffEndTime) {
        Object object = this.realtimeBackoffMetadataLock;
        synchronized (object) {
            this.frcSharedPrefs.edit().putInt(NUM_FAILED_REALTIME_STREAMS_KEY, numFailedStreams).putLong(REALTIME_BACKOFF_END_TIME_IN_MILLIS_KEY, backoffEndTime.getTime()).apply();
        }
    }

    void resetRealtimeBackoff() {
        this.setRealtimeBackoffMetadata(0, NO_BACKOFF_TIME);
    }

    static class BackoffMetadata {
        private int numFailedFetches;
        private Date backoffEndTime;

        BackoffMetadata(int numFailedFetches, Date backoffEndTime) {
            this.numFailedFetches = numFailedFetches;
            this.backoffEndTime = backoffEndTime;
        }

        int getNumFailedFetches() {
            return this.numFailedFetches;
        }

        Date getBackoffEndTime() {
            return this.backoffEndTime;
        }
    }

    @VisibleForTesting
    public static class RealtimeBackoffMetadata {
        private int numFailedStreams;
        private Date backoffEndTime;

        @VisibleForTesting
        public RealtimeBackoffMetadata(int numFailedStreams, Date backoffEndTime) {
            this.numFailedStreams = numFailedStreams;
            this.backoffEndTime = backoffEndTime;
        }

        int getNumFailedStreams() {
            return this.numFailedStreams;
        }

        Date getBackoffEndTime() {
            return this.backoffEndTime;
        }
    }
}

