/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.config.internal.zzb;
import com.google.android.gms.internal.zzalv;
import com.google.android.gms.internal.zzalw;
import com.google.android.gms.internal.zzalx;
import com.google.android.gms.internal.zzaly;
import com.google.android.gms.internal.zzalz;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzamb;
import com.google.android.gms.internal.zzaou;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig bbj;
    private zzalx bbk;
    private zzalx bbl;
    private zzalx bbm;
    private zzama bbn;
    private final Context mContext;
    private final ReadWriteLock bbo = new ReentrantReadWriteLock(true);

    FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzalx zzalx2, zzalx zzalx3, zzalx zzalx4, zzama zzama2) {
        this.mContext = context;
        this.bbn = zzama2 != null ? zzama2 : new zzama();
        this.bbn.zzcn(this.zzer(this.mContext));
        if (zzalx2 != null) {
            this.bbk = zzalx2;
        }
        if (zzalx3 != null) {
            this.bbl = zzalx3;
        }
        if (zzalx4 != null) {
            this.bbm = zzalx4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (bbj == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            return FirebaseRemoteConfig.zzeq(context);
        }
        return bbj;
    }

    public static FirebaseRemoteConfig zzeq(Context context) {
        if (bbj == null) {
            zzamb.zze zze2 = FirebaseRemoteConfig.zzes(context);
            if (zze2 == null) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                }
                bbj = new FirebaseRemoteConfig(context);
            } else {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                }
                zzalx zzalx2 = FirebaseRemoteConfig.zza(zze2.bbL);
                zzalx zzalx3 = FirebaseRemoteConfig.zza(zze2.bbM);
                zzalx zzalx4 = FirebaseRemoteConfig.zza(zze2.bbN);
                zzama zzama2 = FirebaseRemoteConfig.zza(zze2.bbO);
                if (zzama2 != null) {
                    zzama2.zzcd(FirebaseRemoteConfig.zza(zze2.bbP));
                }
                bbj = new FirebaseRemoteConfig(context, zzalx2, zzalx3, zzalx4, zzama2);
            }
        }
        return bbj;
    }

    private long zzer(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf(context.getPackageName());
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zzamb.zze zzes(Context context) {
        if (context == null) {
            return null;
        }
        zzamb.zze zze2 = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            zzaou zzaou2 = zzaou.zzaz((byte[])FirebaseRemoteConfig.zzl(fileInputStream));
            zze2 = new zzamb.zze();
            zzamb.zze cfr_ignored_0 = (zzamb.zze)zze2.zzb(zzaou2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            Object var4_7 = null;
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            Object var4_8 = null;
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zze2;
    }

    private static Map<String, zzalv> zza(zzamb.zzf[] zzfArray) {
        HashMap<String, zzalv> hashMap = new HashMap<String, zzalv>();
        if (zzfArray == null) {
            return hashMap;
        }
        for (zzamb.zzf zzf2 : zzfArray) {
            String string = zzf2.zl;
            int n = zzf2.resourceId;
            long l = zzf2.bbR;
            hashMap.put(string, new zzalv(n, l));
        }
        return hashMap;
    }

    private static zzama zza(zzamb.zzc zzc2) {
        if (zzc2 == null) {
            return null;
        }
        zzama zzama2 = new zzama();
        zzama2.zzadv(zzc2.bbH);
        zzama2.zzcv(zzc2.bbI);
        return zzama2;
    }

    private static zzalx zza(zzamb.zza zza2) {
        zzamb.zzd[] zzdArray;
        if (zza2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        for (zzamb.zzd zzd2 : zzdArray = zza2.bbE) {
            String string = zzd2.zl;
            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
            for (zzamb.zzb zzb2 : zzd2.bbK) {
                hashMap2.put(zzb2.zzcb, zzb2.bbG);
            }
            hashMap.put(string, hashMap2);
        }
        return new zzalx(hashMap, zza2.timestamp);
    }

    private static byte[] zzl(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FirebaseRemoteConfig.zzb(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static long zzb(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateFetched() {
        this.bbo.writeLock().lock();
        try {
            if (this.bbk == null) {
                boolean bl = false;
                return false;
            }
            if (this.bbl != null && this.bbl.getTimestamp() >= this.bbk.getTimestamp()) {
                boolean bl = false;
                return false;
            }
            long l = this.bbk.getTimestamp();
            this.bbl = this.bbk;
            this.bbl.setTimestamp(System.currentTimeMillis());
            this.bbk = new zzalx(null, l);
            this.zzcxg();
            boolean bl = true;
            return true;
        }
        finally {
            this.bbo.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.bbo.readLock().lock();
        try {
            if (this.bbn != null && this.bbn.zzcxm() != null && this.bbn.zzcxm().get(string) != null && n == ((zzalv)(object = this.bbn.zzcxm().get(string))).zzcxh() && this.bbn.zzcxn() == ((zzalv)object).zzcxi()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.bbo.readLock().unlock();
        }
        object = new HashMap();
        try {
            Resources resources = this.mContext.getResources();
            XmlResourceParser xmlResourceParser = resources.getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzalv zzalv2 = new zzalv(n, this.bbn.zzcxn());
            this.bbn.zza(string, zzalv2);
            this.zzc((Map<String, Object>)object, string, false);
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzalz.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzalz.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzalz.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzalz.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzalz.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzalz.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.bbo.writeLock().lock();
        try {
            if (bl2) {
                if (this.bbm == null || !this.bbm.zzsl(string)) {
                    return;
                }
                this.bbm.zzk(null, string);
                this.bbm.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.bbm == null) {
                    this.bbm = new zzalx(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis());
                }
                this.bbm.zzk(hashMap, string);
                this.bbm.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.bbn.zzsm(string);
            }
            this.zzcxg();
        }
        finally {
            this.bbo.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.bbo.writeLock().lock();
        try {
            boolean bl = this.bbn.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.bbn.zzcv(bl2);
            if (bl != bl2) {
                this.zzcxg();
            }
        }
        finally {
            this.bbo.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.bbo.readLock().lock();
        try {
            if (this.bbl != null && this.bbl.zzbt(string, string2)) {
                byte[] byArray = this.bbl.zzbu(string, string2);
                return byArray;
            }
            if (this.bbm != null && this.bbm.zzbt(string, string2)) {
                byte[] byArray = this.bbm.zzbu(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.bbo.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_STRING;
        }
        this.bbo.readLock().lock();
        try {
            if (this.bbl != null && this.bbl.zzbt(string, string2)) {
                String string3 = new String(this.bbl.zzbu(string, string2), zzalz.UTF_8);
                return string3;
            }
            if (this.bbm != null && this.bbm.zzbt(string, string2)) {
                String string4 = new String(this.bbm.zzbu(string, string2), zzalz.UTF_8);
                return string4;
            }
            String string5 = DEFAULT_VALUE_FOR_STRING;
            return string5;
        }
        finally {
            this.bbo.readLock().unlock();
        }
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.bbo.readLock().lock();
        try {
            String string3;
            if (this.bbl != null && this.bbl.zzbt(string, string2)) {
                string3 = new String(this.bbl.zzbu(string, string2), zzalz.UTF_8);
                if (zzalz.Bn.matcher(string3).matches()) {
                    boolean bl = true;
                    return true;
                }
                if (zzalz.Bo.matcher(string3).matches()) {
                    boolean bl = false;
                    return false;
                }
            }
            if (this.bbm != null && this.bbm.zzbt(string, string2)) {
                string3 = new String(this.bbm.zzbu(string, string2), zzalz.UTF_8);
                if (zzalz.Bn.matcher(string3).matches()) {
                    boolean bl = true;
                    return true;
                }
                if (zzalz.Bo.matcher(string3).matches()) {
                    boolean bl = false;
                    return false;
                }
            }
            boolean bl = false;
            return false;
        }
        finally {
            this.bbo.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzalz(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.bbo.readLock().lock();
        try {
            if (this.bbl != null && this.bbl.zzbt(string, string2)) {
                zzalz zzalz2 = new zzalz(this.bbl.zzbu(string, string2), 2);
                return zzalz2;
            }
            if (this.bbm != null && this.bbm.zzbt(string, string2)) {
                zzalz zzalz3 = new zzalz(this.bbm.zzbu(string, string2), 1);
                return zzalz3;
            }
            zzalz zzalz4 = new zzalz(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzalz4;
        }
        finally {
            this.bbo.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigInfo getInfo() {
        zzaly zzaly2 = new zzaly();
        this.bbo.readLock().lock();
        try {
            long l = this.bbk == null ? -1L : this.bbk.getTimestamp();
            zzaly2.zzcm(l);
            zzaly2.zzadv(this.bbn.getLastFetchStatus());
            zzaly2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.bbn.isDeveloperModeEnabled()).build());
        }
        finally {
            this.bbo.readLock().unlock();
        }
        return zzaly2;
    }

    private void zzcxg() {
        this.bbo.readLock().lock();
        try {
            zzalw zzalw2 = new zzalw(this.mContext, this.bbk, this.bbl, this.bbm, this.bbn);
            if (Build.VERSION.SDK_INT >= 11) {
                AsyncTask.SERIAL_EXECUTOR.execute(zzalw2);
            } else {
                new zza().execute(zzalw2);
            }
        }
        finally {
            this.bbo.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> fetch(long l) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.bbo.writeLock().lock();
        try {
            zzrw.zza.zza zza2 = new zzrw.zza.zza();
            zza2.zzah(l);
            if (this.bbn.isDeveloperModeEnabled()) {
                zza2.zzah("_rcn_developer", "true");
            }
            PendingResult<zzrw.zzb> pendingResult = new zzb(this.mContext).zza(zza2.zzawe());
            pendingResult.setResultCallback((ResultCallback)new ResultCallback<zzrw.zzb>(){

                public void zza(@NonNull zzrw.zzb zzb2) {
                    FirebaseRemoteConfig.this.zza((TaskCompletionSource<Void>)taskCompletionSource, zzb2);
                }

                public /* synthetic */ void onResult(@NonNull Result result) {
                    this.zza((zzrw.zzb)result);
                }
            });
        }
        finally {
            this.bbo.writeLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    void zza(TaskCompletionSource<Void> taskCompletionSource, zzrw.zzb zzb2) {
        if (zzb2 == null || zzb2.getStatus() == null) {
            this.bbn.zzadv(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.zzcxg();
            return;
        }
        int n = zzb2.getStatus().getStatusCode();
        switch (n) {
            case 6500: 
            case 6501: 
            case 6503: 
            case 6504: {
                this.bbn.zzadv(1);
                taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                this.zzcxg();
                break;
            }
            case 6502: 
            case 6507: {
                this.bbn.zzadv(2);
                taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzb2.getThrottleEndTimeMillis())));
                this.zzcxg();
                break;
            }
            case -6508: 
            case -6506: {
                this.bbn.zzadv(-1);
                if (this.bbk != null && !this.bbk.zzcxk()) {
                    Map<String, Set<String>> map = zzb2.zzawf();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                        for (String string2 : map.get(string)) {
                            hashMap2.put(string2, zzb2.zza(string2, null, string));
                        }
                        hashMap.put(string, hashMap2);
                    }
                    this.bbk = new zzalx(hashMap, this.bbk.getTimestamp());
                }
                taskCompletionSource.setResult(null);
                this.zzcxg();
                break;
            }
            case -6505: {
                Map<String, Set<String>> map = zzb2.zzawf();
                HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                for (String string : map.keySet()) {
                    HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                    for (String string3 : map.get(string)) {
                        hashMap3.put(string3, zzb2.zza(string3, null, string));
                    }
                    hashMap.put(string, hashMap3);
                }
                this.bbk = new zzalx(hashMap, System.currentTimeMillis());
                this.bbn.zzadv(-1);
                taskCompletionSource.setResult(null);
                this.zzcxg();
                break;
            }
            default: {
                if (zzb2.getStatus().isSuccess()) {
                    Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                }
                this.bbn.zzadv(1);
                taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                this.zzcxg();
            }
        }
    }

    static class zza
    implements Executor {
        zza() {
        }

        @Override
        public void execute(Runnable runnable) {
            new Thread(runnable).start();
        }
    }
}

