/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.config.internal.zzd;
import com.google.android.gms.internal.zzanv;
import com.google.android.gms.internal.zzanw;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzany;
import com.google.android.gms.internal.zzanz;
import com.google.android.gms.internal.zzaoa;
import com.google.android.gms.internal.zzaob;
import com.google.android.gms.internal.zzars;
import com.google.android.gms.internal.zztb;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigFetchThrottledException;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigInfo;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FirebaseRemoteConfig {
    public static final String DEFAULT_VALUE_FOR_STRING = "";
    public static final long DEFAULT_VALUE_FOR_LONG = 0L;
    public static final double DEFAULT_VALUE_FOR_DOUBLE = 0.0;
    public static final boolean DEFAULT_VALUE_FOR_BOOLEAN = false;
    public static final byte[] DEFAULT_VALUE_FOR_BYTE_ARRAY = new byte[0];
    public static final int VALUE_SOURCE_STATIC = 0;
    public static final int VALUE_SOURCE_DEFAULT = 1;
    public static final int VALUE_SOURCE_REMOTE = 2;
    public static final int LAST_FETCH_STATUS_SUCCESS = -1;
    public static final int LAST_FETCH_STATUS_NO_FETCH_YET = 0;
    public static final int LAST_FETCH_STATUS_FAILURE = 1;
    public static final int LAST_FETCH_STATUS_THROTTLED = 2;
    private static FirebaseRemoteConfig blh;
    private zzanx bli;
    private zzanx blj;
    private zzanx blk;
    private zzaoa bll;
    private final Context mContext;
    private final ReadWriteLock blm = new ReentrantReadWriteLock(true);

    FirebaseRemoteConfig(Context context) {
        this(context, null, null, null, null);
    }

    private FirebaseRemoteConfig(Context context, zzanx zzanx2, zzanx zzanx3, zzanx zzanx4, zzaoa zzaoa2) {
        this.mContext = context;
        this.bll = zzaoa2 != null ? zzaoa2 : new zzaoa();
        this.bll.zzcq(this.zzex(this.mContext));
        if (zzanx2 != null) {
            this.bli = zzanx2;
        }
        if (zzanx3 != null) {
            this.blj = zzanx3;
        }
        if (zzanx4 != null) {
            this.blk = zzanx4;
        }
    }

    public static FirebaseRemoteConfig getInstance() {
        if (blh == null) {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp == null) {
                throw new IllegalStateException("FirebaseApp has not been initialized.");
            }
            Context context = firebaseApp.getApplicationContext();
            return FirebaseRemoteConfig.zzew(context);
        }
        return blh;
    }

    public static FirebaseRemoteConfig zzew(Context context) {
        if (blh == null) {
            zzaob.zze zze2 = FirebaseRemoteConfig.zzey(context);
            if (zze2 == null) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"No persisted config was found. Initializing from scratch.");
                }
                blh = new FirebaseRemoteConfig(context);
            } else {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Initializing from persisted config.");
                }
                zzanx zzanx2 = FirebaseRemoteConfig.zza(zze2.blJ);
                zzanx zzanx3 = FirebaseRemoteConfig.zza(zze2.blK);
                zzanx zzanx4 = FirebaseRemoteConfig.zza(zze2.blL);
                zzaoa zzaoa2 = FirebaseRemoteConfig.zza(zze2.blM);
                if (zzaoa2 != null) {
                    zzaoa2.zzch(FirebaseRemoteConfig.zza(zze2.blN));
                }
                blh = new FirebaseRemoteConfig(context, zzanx2, zzanx3, zzanx4, zzaoa2);
            }
        }
        return blh;
    }

    private long zzex(Context context) {
        long l = 0L;
        try {
            l = this.mContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf(context.getPackageName());
            Log.e((String)"FirebaseRemoteConfig", (String)new StringBuilder(25 + String.valueOf(string).length()).append("Package [").append(string).append("] was not found!").toString());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zzaob.zze zzey(Context context) {
        if (context == null) {
            return null;
        }
        zzaob.zze zze2 = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("persisted_config");
            zzars zzars2 = zzars.zzbd((byte[])FirebaseRemoteConfig.zzl(fileInputStream));
            zze2 = new zzaob.zze();
            zzaob.zze cfr_ignored_0 = (zzaob.zze)zze2.zzb(zzars2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"Persisted config file was not found.", (Throwable)fileNotFoundException);
            }
            Object var4_7 = null;
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Cannot initialize from persisted config.", (Throwable)iOException);
            Object var4_8 = null;
            return null;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.e((String)"FirebaseRemoteConfig", (String)"Failed to close persisted config file.", (Throwable)iOException);
            }
        }
        return zze2;
    }

    private static Map<String, zzanv> zza(zzaob.zzf[] zzfArray) {
        HashMap<String, zzanv> hashMap = new HashMap<String, zzanv>();
        if (zzfArray == null) {
            return hashMap;
        }
        for (zzaob.zzf zzf2 : zzfArray) {
            String string = zzf2.EY;
            int n = zzf2.resourceId;
            long l = zzf2.blP;
            hashMap.put(string, new zzanv(n, l));
        }
        return hashMap;
    }

    private static zzaoa zza(zzaob.zzc zzc2) {
        if (zzc2 == null) {
            return null;
        }
        zzaoa zzaoa2 = new zzaoa();
        zzaoa2.zzagf(zzc2.blF);
        zzaoa2.zzdd(zzc2.blG);
        return zzaoa2;
    }

    private static zzanx zza(zzaob.zza zza2) {
        zzaob.zzd[] zzdArray;
        if (zza2 == null) {
            return null;
        }
        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
        for (zzaob.zzd zzd2 : zzdArray = zza2.blC) {
            String string = zzd2.EY;
            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
            for (zzaob.zzb zzb2 : zzd2.blI) {
                hashMap2.put(zzb2.zzcb, zzb2.blE);
            }
            hashMap.put(string, hashMap2);
        }
        return new zzanx(hashMap, zza2.timestamp);
    }

    private static byte[] zzl(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FirebaseRemoteConfig.zzb(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static long zzb(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateFetched() {
        this.blm.writeLock().lock();
        try {
            if (this.bli == null) {
                boolean bl = false;
                return false;
            }
            if (this.blj != null && this.blj.getTimestamp() >= this.bli.getTimestamp()) {
                boolean bl = false;
                return false;
            }
            long l = this.bli.getTimestamp();
            this.blj = this.bli;
            this.blj.setTimestamp(System.currentTimeMillis());
            this.bli = new zzanx(null, l);
            this.S();
            boolean bl = true;
            return true;
        }
        finally {
            this.blm.writeLock().unlock();
        }
    }

    public void setDefaults(int n) {
        this.setDefaults(n, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaults(int n, String string) {
        Object object;
        if (string == null) {
            if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                Log.d((String)"FirebaseRemoteConfig", (String)"namespace cannot be null for setDefaults.");
            }
            return;
        }
        this.blm.readLock().lock();
        try {
            if (this.bll != null && this.bll.Y() != null && this.bll.Y().get(string) != null && n == ((zzanv)(object = this.bll.Y().get(string))).T() && this.bll.Z() == ((zzanv)object).U()) {
                if (Log.isLoggable((String)"FirebaseRemoteConfig", (int)3)) {
                    Log.d((String)"FirebaseRemoteConfig", (String)"Skipped setting defaults from resource file as this resource file was already applied.");
                }
                return;
            }
        }
        finally {
            this.blm.readLock().unlock();
        }
        object = new HashMap();
        try {
            Resources resources = this.mContext.getResources();
            XmlResourceParser xmlResourceParser = resources.getXml(n);
            int n2 = xmlResourceParser.getEventType();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            while (n2 != 1) {
                if (n2 == 2) {
                    string2 = xmlResourceParser.getName();
                } else if (n2 == 3) {
                    if ("entry".equals(xmlResourceParser.getName()) && string3 != null && string4 != null) {
                        object.put(string3, string4);
                        string3 = null;
                        string4 = null;
                    }
                    string2 = null;
                } else if (n2 == 4) {
                    if ("key".equals(string2)) {
                        string3 = xmlResourceParser.getText();
                    } else if ("value".equals(string2)) {
                        string4 = xmlResourceParser.getText();
                    }
                }
                n2 = xmlResourceParser.next();
            }
            zzanv zzanv2 = new zzanv(n, this.bll.Z());
            this.bll.zza(string, zzanv2);
            this.zzc((Map<String, Object>)object, string, false);
        }
        catch (Exception exception) {
            Log.e((String)"FirebaseRemoteConfig", (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)exception);
        }
    }

    public void setDefaults(Map<String, Object> map) {
        this.setDefaults(map, "configns:firebase");
    }

    public void setDefaults(Map<String, Object> map, String string) {
        this.zzc(map, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(Map<String, Object> map, String string, boolean bl) {
        if (string == null) {
            return;
        }
        boolean bl2 = map == null || map.isEmpty();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        if (!bl2) {
            for (String string2 : map.keySet()) {
                Object object = map.get(string2);
                if (object instanceof String) {
                    hashMap.put(string2, ((String)object).getBytes(zzanz.UTF_8));
                    continue;
                }
                if (object instanceof Long) {
                    hashMap.put(string2, ((Long)object).toString().getBytes(zzanz.UTF_8));
                    continue;
                }
                if (object instanceof Integer) {
                    hashMap.put(string2, ((Integer)object).toString().getBytes(zzanz.UTF_8));
                    continue;
                }
                if (object instanceof Double) {
                    hashMap.put(string2, ((Double)object).toString().getBytes(zzanz.UTF_8));
                    continue;
                }
                if (object instanceof Float) {
                    hashMap.put(string2, ((Float)object).toString().getBytes(zzanz.UTF_8));
                    continue;
                }
                if (object instanceof byte[]) {
                    hashMap.put(string2, (byte[])object);
                    continue;
                }
                if (object instanceof Boolean) {
                    hashMap.put(string2, ((Boolean)object).toString().getBytes(zzanz.UTF_8));
                    continue;
                }
                throw new IllegalArgumentException("The type of a default value needs to beone of String, Long, Double, Boolean, or byte[].");
            }
        }
        this.blm.writeLock().lock();
        try {
            if (bl2) {
                if (this.blk == null || !this.blk.zzuc(string)) {
                    return;
                }
                this.blk.zzk(null, string);
                this.blk.setTimestamp(System.currentTimeMillis());
            } else {
                if (this.blk == null) {
                    this.blk = new zzanx(new HashMap<String, Map<String, byte[]>>(), System.currentTimeMillis());
                }
                this.blk.zzk(hashMap, string);
                this.blk.setTimestamp(System.currentTimeMillis());
            }
            if (bl) {
                this.bll.zzud(string);
            }
            this.S();
        }
        finally {
            this.blm.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigSettings(FirebaseRemoteConfigSettings firebaseRemoteConfigSettings) {
        this.blm.writeLock().lock();
        try {
            boolean bl = this.bll.isDeveloperModeEnabled();
            boolean bl2 = firebaseRemoteConfigSettings == null ? false : firebaseRemoteConfigSettings.isDeveloperModeEnabled();
            this.bll.zzdd(bl2);
            if (bl != bl2) {
                this.S();
            }
        }
        finally {
            this.blm.writeLock().unlock();
        }
    }

    public long getLong(String string) {
        return this.getLong(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public long getLong(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        this.blm.readLock().lock();
        try {
            if (this.blj != null && this.blj.zzbv(string, string2)) {
                byte[] byArray = this.blj.zzbw(string, string2);
                return byArray;
            }
            if (this.blk != null && this.blk.zzbv(string, string2)) {
                byte[] byArray = this.blk.zzbw(string, string2);
                return byArray;
            }
            byte[] byArray = DEFAULT_VALUE_FOR_BYTE_ARRAY;
            return byArray;
        }
        finally {
            this.blm.readLock().unlock();
        }
    }

    public String getString(String string) {
        return this.getString(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string, String string2) {
        if (string2 == null) {
            return DEFAULT_VALUE_FOR_STRING;
        }
        this.blm.readLock().lock();
        try {
            if (this.blj != null && this.blj.zzbv(string, string2)) {
                String string3 = new String(this.blj.zzbw(string, string2), zzanz.UTF_8);
                return string3;
            }
            if (this.blk != null && this.blk.zzbv(string, string2)) {
                String string4 = new String(this.blk.zzbw(string, string2), zzanz.UTF_8);
                return string4;
            }
            String string5 = DEFAULT_VALUE_FOR_STRING;
            return string5;
        }
        finally {
            this.blm.readLock().unlock();
        }
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        this.blm.readLock().lock();
        try {
            String string3;
            if (this.blj != null && this.blj.zzbv(string, string2)) {
                string3 = new String(this.blj.zzbw(string, string2), zzanz.UTF_8);
                if (zzanz.GW.matcher(string3).matches()) {
                    boolean bl = true;
                    return true;
                }
                if (zzanz.GX.matcher(string3).matches()) {
                    boolean bl = false;
                    return false;
                }
            }
            if (this.blk != null && this.blk.zzbv(string, string2)) {
                string3 = new String(this.blk.zzbw(string, string2), zzanz.UTF_8);
                if (zzanz.GW.matcher(string3).matches()) {
                    boolean bl = true;
                    return true;
                }
                if (zzanz.GX.matcher(string3).matches()) {
                    boolean bl = false;
                    return false;
                }
            }
            boolean bl = false;
            return false;
        }
        finally {
            this.blm.readLock().unlock();
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, "configns:firebase");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FirebaseRemoteConfigValue getValue(String string) {
        return this.getValue(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigValue getValue(String string, String string2) {
        if (string2 == null) {
            return new zzanz(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
        }
        this.blm.readLock().lock();
        try {
            if (this.blj != null && this.blj.zzbv(string, string2)) {
                zzanz zzanz2 = new zzanz(this.blj.zzbw(string, string2), 2);
                return zzanz2;
            }
            if (this.blk != null && this.blk.zzbv(string, string2)) {
                zzanz zzanz3 = new zzanz(this.blk.zzbw(string, string2), 1);
                return zzanz3;
            }
            zzanz zzanz4 = new zzanz(DEFAULT_VALUE_FOR_BYTE_ARRAY, 0);
            return zzanz4;
        }
        finally {
            this.blm.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirebaseRemoteConfigInfo getInfo() {
        zzany zzany2 = new zzany();
        this.blm.readLock().lock();
        try {
            long l = this.bli == null ? -1L : this.bli.getTimestamp();
            zzany2.zzcp(l);
            zzany2.zzagf(this.bll.getLastFetchStatus());
            zzany2.setConfigSettings(new FirebaseRemoteConfigSettings.Builder().setDeveloperModeEnabled(this.bll.isDeveloperModeEnabled()).build());
        }
        finally {
            this.blm.readLock().unlock();
        }
        return zzany2;
    }

    public Set<String> getKeysByPrefix(String string) {
        return this.getKeysByPrefix(string, "configns:firebase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getKeysByPrefix(String string, String string2) {
        this.blm.readLock().lock();
        try {
            if (this.blj == null) {
                TreeSet<String> treeSet = new TreeSet<String>();
                return treeSet;
            }
            Set<String> set = this.blj.zzbx(string, string2);
            return set;
        }
        finally {
            this.blm.readLock().unlock();
        }
    }

    private void S() {
        this.blm.readLock().lock();
        try {
            zzanw zzanw2 = new zzanw(this.mContext, this.bli, this.blj, this.blk, this.bll);
            if (Build.VERSION.SDK_INT >= 11) {
                AsyncTask.SERIAL_EXECUTOR.execute(zzanw2);
            } else {
                new zza().execute(zzanw2);
            }
        }
        finally {
            this.blm.readLock().unlock();
        }
    }

    public Task<Void> fetch() {
        return this.fetch(43200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> fetch(long l) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.blm.readLock().lock();
        try {
            zztb.zza.zza zza2 = new zztb.zza.zza();
            zza2.zzaj(l);
            if (this.bll.isDeveloperModeEnabled()) {
                zza2.zzag("_rcn_developer", "true");
            }
            zza2.zzhj(10200);
            PendingResult<zztb.zzb> pendingResult = new zzd(this.mContext).zza(zza2.zzazi());
            pendingResult.setResultCallback((ResultCallback)new ResultCallback<zztb.zzb>(){

                public void zza(@NonNull zztb.zzb zzb2) {
                    FirebaseRemoteConfig.this.zza((TaskCompletionSource<Void>)taskCompletionSource, zzb2);
                }

                public /* synthetic */ void onResult(@NonNull Result result) {
                    this.zza((zztb.zzb)result);
                }
            });
        }
        finally {
            this.blm.readLock().unlock();
        }
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    void zza(TaskCompletionSource<Void> taskCompletionSource, zztb.zzb zzb2) {
        if (zzb2 == null || zzb2.getStatus() == null) {
            this.bll.zzagf(1);
            taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
            this.S();
            return;
        }
        int n = zzb2.getStatus().getStatusCode();
        this.blm.writeLock().lock();
        try {
            switch (n) {
                case 6500: 
                case 6501: 
                case 6503: 
                case 6504: {
                    this.bll.zzagf(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.S();
                    return;
                }
                case 6502: 
                case 6507: {
                    this.bll.zzagf(2);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchThrottledException(zzb2.getThrottleEndTimeMillis())));
                    this.S();
                    return;
                }
                case -6508: 
                case -6506: {
                    this.bll.zzagf(-1);
                    if (this.bli != null && !this.bli.W()) {
                        Map<String, Set<String>> map = zzb2.zzazj();
                        HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                        for (String string : map.keySet()) {
                            HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
                            for (String string2 : map.get(string)) {
                                hashMap2.put(string2, zzb2.zza(string2, null, string));
                            }
                            hashMap.put(string, hashMap2);
                        }
                        this.bli = new zzanx(hashMap, this.bli.getTimestamp());
                    }
                    taskCompletionSource.setResult(null);
                    this.S();
                    return;
                }
                case -6505: {
                    Map<String, Set<String>> map = zzb2.zzazj();
                    HashMap<String, Map<String, byte[]>> hashMap = new HashMap<String, Map<String, byte[]>>();
                    for (String string : map.keySet()) {
                        HashMap<String, byte[]> hashMap3 = new HashMap<String, byte[]>();
                        for (String string3 : map.get(string)) {
                            hashMap3.put(string3, zzb2.zza(string3, null, string));
                        }
                        hashMap.put(string, hashMap3);
                    }
                    this.bli = new zzanx(hashMap, System.currentTimeMillis());
                    this.bll.zzagf(-1);
                    taskCompletionSource.setResult(null);
                    this.S();
                    return;
                }
                default: {
                    if (zzb2.getStatus().isSuccess()) {
                        Log.w((String)"FirebaseRemoteConfig", (String)new StringBuilder(45).append("Unknown (successful) status code: ").append(n).toString());
                    }
                    this.bll.zzagf(1);
                    taskCompletionSource.setException((Exception)((Object)new FirebaseRemoteConfigFetchException()));
                    this.S();
                    return;
                }
            }
        }
        finally {
            this.blm.writeLock().unlock();
        }
    }

    static class zza
    implements Executor {
        zza() {
        }

        @Override
        public void execute(Runnable runnable) {
            new Thread(runnable).start();
        }
    }
}

