/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.util.Log;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzbkn;
import com.google.android.gms.internal.zzbko;
import com.google.android.gms.internal.zzbkp;
import com.google.android.gms.internal.zzbkr;
import com.google.android.gms.internal.zzbks;
import com.google.android.gms.internal.zzbkt;
import com.google.android.gms.internal.zzbku;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.zzc;

public class FirebaseCrash {
    private static final String LOG_TAG = FirebaseCrash.class.getSimpleName();
    private boolean zzbqB;
    private zzbkr zzbWW;
    private zzbkn zzbWX;
    private static volatile FirebaseCrash zzbWY;

    FirebaseCrash(FirebaseApp firebaseApp, boolean bl) {
        this.zzbqB = bl;
        Context context = firebaseApp.getApplicationContext();
        if (context == null) {
            Log.w((String)LOG_TAG, (String)"Application context is missing, disabling api");
            this.zzbqB = false;
        }
        if (this.zzbqB) {
            try {
                String string = firebaseApp.getOptions().getApiKey();
                String string2 = firebaseApp.getOptions().getApplicationId();
                zzbkp zzbkp2 = new zzbkp(string2, string);
                zzbks.zzUT().zzao(context);
                this.zzbWW = zzbks.zzUT().zzUU();
                this.zzbWW.zza(zze.zzA((Object)context), zzbkp2);
                this.zzbWX = new zzbkn(context);
                this.zzUP();
                String string3 = String.valueOf(zzbks.zzUT().toString());
                Log.i((String)LOG_TAG, (String)(string3.length() != 0 ? "FirebaseCrash reporting initialized ".concat(string3) : new String("FirebaseCrash reporting initialized ")));
            }
            catch (Exception exception) {
                String string = String.valueOf(exception.getMessage());
                Log.e((String)LOG_TAG, (String)(string.length() != 0 ? "Failed to initialize crash reporting: ".concat(string) : new String("Failed to initialize crash reporting: ")));
                this.zzbqB = false;
            }
        } else {
            Log.i((String)LOG_TAG, (String)"Crash reporting is disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirebaseCrash zzUL() {
        if (zzbWY != null) return zzbWY;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (zzbWY != null) return zzbWY;
            zzbWY = FirebaseCrash.getInstance(FirebaseApp.getInstance());
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzbWY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Keep
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        zzbku.initialize(firebaseApp.getApplicationContext());
        boolean bl = (Boolean)zzbku.zzbXh.get();
        FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, bl);
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (zzbWY == null) {
                zzbWY = firebaseCrash;
                try {
                    zzbWY.zzUM();
                }
                catch (zzbko zzbko2) {
                    Log.d((String)LOG_TAG, (String)"Cannot register Firebase Analytics listener since Firebase Crash Reporting is not enabled");
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return firebaseCrash;
        }
    }

    private void zzUM() throws zzbko {
        if (!this.isEnabled()) {
            throw new zzbko("Firebase Crash Reporting is disabled.");
        }
        this.zzbWX.zzUR();
    }

    private zzbkr zzUN() {
        return this.zzbWW;
    }

    private boolean isEnabled() {
        return this.zzbqB;
    }

    public static void log(String string) {
        try {
            FirebaseCrash.zzUL().zziC(string);
        }
        catch (zzbko zzbko2) {
            Log.v((String)LOG_TAG, (String)zzbko2.getMessage());
        }
    }

    public static void logcat(int n, String string, String string2) {
        try {
            FirebaseCrash.zzUL().zze(n, string, string2);
        }
        catch (zzbko zzbko2) {
            Log.v((String)LOG_TAG, (String)zzbko2.getMessage());
        }
    }

    public static void zza(String string, long l, Bundle bundle) {
        try {
            FirebaseCrash.zzUL().zzb(string, l, bundle);
        }
        catch (zzbko zzbko2) {
            Log.v((String)LOG_TAG, (String)zzbko2.getMessage());
        }
    }

    public static void report(Throwable throwable) {
        try {
            FirebaseCrash.zzUL().zzh(throwable);
        }
        catch (zzbko zzbko2) {
            Log.v((String)LOG_TAG, (String)zzbko2.getMessage());
        }
    }

    public void zze(int n, String string, String string2) throws zzbko {
        if (string2 != null) {
            if (string == null) {
                string = "";
            }
            Log.println((int)n, (String)string, (String)string2);
            this.zziC(string2);
        }
    }

    public void zziC(String string) throws zzbko {
        if (!this.isEnabled()) {
            throw new zzbko("Firebase Crash Reporting is disabled.");
        }
        zzbkr zzbkr2 = this.zzUN();
        if (zzbkr2 != null && string != null) {
            try {
                zzbkr2.log(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"log remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzb(String string, long l, Bundle bundle) throws zzbko {
        if (!this.isEnabled()) {
            throw new zzbko("Firebase Crash Reporting is disabled.");
        }
        zzbkr zzbkr2 = this.zzUN();
        if (zzbkr2 != null && string != null) {
            try {
                zzbkr2.zzb(string, l, bundle);
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"log remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzh(Throwable throwable) throws zzbko {
        if (!this.isEnabled()) {
            throw new zzbko("Firebase Crash Reporting is disabled.");
        }
        zzbkr zzbkr2 = this.zzUN();
        if (zzbkr2 != null && throwable != null) {
            this.zzbWX.zza(false, System.currentTimeMillis());
            try {
                zzbkr2.zziD(this.zzUQ());
                zzbkr2.zzN(zze.zzA((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzi(Throwable throwable) throws zzbko {
        if (!this.isEnabled()) {
            throw new zzbko("Firebase Crash Reporting is disabled.");
        }
        zzbkr zzbkr2 = this.zzUN();
        if (zzbkr2 != null && throwable != null) {
            try {
                this.zzbWX.zza(true, System.currentTimeMillis());
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                zzbkr2.zziD(this.zzUQ());
                zzbkr2.zzO(zze.zzA((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    private static boolean zzUO() {
        long l;
        long l2 = Looper.getMainLooper().getThread().getId();
        return l2 == (l = Thread.currentThread().getId());
    }

    private void zzUP() {
        if (!FirebaseCrash.zzUO()) {
            throw new RuntimeException("FirebaseCrash reporting may only be initialized on the main thread (preferably in your app's Application.onCreate)");
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        zzbkt zzbkt2 = new zzbkt(uncaughtExceptionHandler, this);
        Thread.setDefaultUncaughtExceptionHandler(zzbkt2);
    }

    private String zzUQ() {
        return zzc.zzaab().getId();
    }
}

