/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.internal.zzdxm;
import com.google.android.gms.internal.zzdxn;
import com.google.android.gms.internal.zzdxo;
import com.google.android.gms.internal.zzdxp;
import com.google.android.gms.internal.zzdxs;
import com.google.android.gms.internal.zzdxy;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.zzd;
import com.google.firebase.crash.zze;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@UsedByReflection(value="FirebaseApp")
public class FirebaseCrash {
    private static volatile FirebaseCrash zzmdr;
    private final Context mContext;
    private final ExecutorService zzmds;
    private final FirebaseApp zzlyy;
    private final zzb zzmdt;
    private final CountDownLatch zzmdu = new CountDownLatch(1);
    private zzdxy zzmdv;

    private FirebaseCrash(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executorService) {
        this.zzlyy = firebaseApp;
        this.zzmds = executorService;
        this.mContext = this.zzlyy.getApplicationContext();
        this.zzmdt = new zzb(null);
    }

    final void zza(@Nullable zzdxs zzdxs2) {
        if (zzdxs2 == null) {
            this.zzmds.shutdownNow();
        } else {
            this.zzmdv = zzdxy.zzer(this.mContext);
            this.zzmdt.zzb(zzdxs2);
            FirebaseCrash firebaseCrash = this;
            if (firebaseCrash.zzmdv != null && !firebaseCrash.zzbqp()) {
                firebaseCrash.zzmdv.zza(firebaseCrash.mContext, firebaseCrash.zzmds, firebaseCrash.zzmdt);
                Log.d((String)"FirebaseCrash", (String)"Firebase Analytics Listener for Firebase Crash is initialized");
            }
        }
        this.zzmdu.countDown();
    }

    private final void zzbqn() {
        try {
            this.zzmdu.await(20000L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.e((String)"FirebaseCrash", (String)"Failed waiting for crash api to load.", (Throwable)interruptedException);
            return;
        }
    }

    private static FirebaseCrash zzbqo() {
        if (zzmdr != null) {
            return zzmdr;
        }
        return FirebaseCrash.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    @UsedByReflection(value="FirebaseApp")
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        if (zzmdr != null) return zzmdr;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            com.google.firebase.crash.zzc zzc2;
            if (zzmdr != null) return zzmdr;
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, threadPoolExecutor);
            com.google.firebase.crash.zzc zzc3 = zzc2 = new com.google.firebase.crash.zzc(firebaseApp, null);
            FirebaseCrash firebaseCrash2 = firebaseCrash;
            Thread.setDefaultUncaughtExceptionHandler(new zzc(firebaseCrash2, Thread.getDefaultUncaughtExceptionHandler()));
            com.google.firebase.crash.zzb zzb2 = new com.google.firebase.crash.zzb(firebaseCrash2);
            com.google.firebase.crash.zzc zzc4 = zzc3;
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<zzdxs> future = executorService.submit(new zzd(zzc4));
            executorService.submit(new zze(zzc4, future, 10000L, zzb2));
            executorService.shutdown();
            firebaseCrash2.zzmds.execute(new com.google.firebase.crash.zza(firebaseCrash2));
            zzmdr = firebaseCrash;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzmdr;
        }
    }

    public final boolean zzbqp() {
        return this.zzmds.isShutdown();
    }

    public static void log(String string) {
        FirebaseCrash.zzbqo().zzop(string);
    }

    public static void logcat(int n, String string, String string2) {
        String string3 = string2;
        String string4 = string;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbqo();
        if (string3 != null) {
            if (string4 == null) {
                string4 = "";
            }
            Log.println((int)n, (String)string4, (String)string3);
            firebaseCrash.zzop(string3);
        }
    }

    public static void report(Throwable throwable) {
        Throwable throwable2 = throwable;
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbqo();
        if (throwable2 == null || firebaseCrash.zzbqp()) {
            return;
        }
        firebaseCrash.zzmds.submit(new zzdxm(firebaseCrash.mContext, firebaseCrash.zzmdt, throwable2, firebaseCrash.zzmdv));
    }

    public static void setCrashCollectionEnabled(boolean bl) {
        FirebaseCrash firebaseCrash = FirebaseCrash.zzbqo();
        if (!firebaseCrash.zzbqp()) {
            firebaseCrash.zzmds.submit(new zzdxp(firebaseCrash.mContext, firebaseCrash.zzmdt, bl));
        }
    }

    public static boolean isCrashCollectionEnabled() {
        return FirebaseCrash.zzbqo().zzbqq();
    }

    private final boolean zzbqq() {
        if (this.zzbqp()) {
            return false;
        }
        this.zzbqn();
        zzdxs zzdxs2 = this.zzmdt.zzbqr();
        if (zzdxs2 != null) {
            try {
                return zzdxs2.zzbqq();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        return false;
    }

    private final void zzop(String string) {
        if (string == null || this.zzbqp()) {
            return;
        }
        this.zzmds.submit(new zzdxn(this.mContext, this.zzmdt, string));
    }

    @Nullable
    final Future<?> zzh(Throwable throwable) {
        if (throwable == null || this.zzbqp()) {
            return null;
        }
        return this.zzmds.submit(new zzdxo(this.mContext, this.zzmdt, throwable, this.zzmdv));
    }

    static /* synthetic */ void zza(FirebaseCrash firebaseCrash) {
        firebaseCrash.zzbqn();
    }

    final class zzc
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler zzmdz;
        private /* synthetic */ FirebaseCrash zzmdw;

        public zzc(@Nullable FirebaseCrash firebaseCrash, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.zzmdw = firebaseCrash;
            this.zzmdz = uncaughtExceptionHandler;
        }

        @Override
        public final void uncaughtException(Thread thread, Throwable throwable) {
            Log.e((String)"UncaughtException", (String)"", (Throwable)throwable);
            if (!this.zzmdw.zzbqp()) {
                try {
                    Future<?> future = this.zzmdw.zzh(throwable);
                    if (future != null) {
                        future.get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"UncaughtException", (String)"Ouch! My own exception handler threw an exception.", (Throwable)exception);
                }
            }
            if (this.zzmdz != null) {
                this.zzmdz.uncaughtException(thread, throwable);
            }
        }
    }

    static final class zzb
    implements zza {
        private final Object zzmdx = new Object();
        private zzdxs zzmdy;

        private zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public final zzdxs zzbqr() {
            Object object = this.zzmdx;
            synchronized (object) {
                return this.zzmdy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void zzb(@Nullable zzdxs zzdxs2) {
            Object object = this.zzmdx;
            synchronized (object) {
                this.zzmdy = zzdxs2;
                return;
            }
        }

        /* synthetic */ zzb(com.google.firebase.crash.zza zza2) {
            this();
        }
    }

    public static interface zza {
        @Nullable
        public zzdxs zzbqr();
    }
}

