/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.Keep;
import android.util.Log;
import com.google.android.gms.dynamic.zze;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crash.internal.FirebaseCrashOptions;
import com.google.firebase.crash.internal.config.flag.Flags;
import com.google.firebase.crash.internal.zza;
import com.google.firebase.crash.internal.zzb;
import com.google.firebase.crash.internal.zzd;
import com.google.firebase.crash.internal.zzg;
import com.google.firebase.crash.internal.zzh;
import com.google.firebase.iid.zzc;

public class FirebaseCrash {
    private static final String LOG_TAG = FirebaseCrash.class.getSimpleName();
    private boolean zzbcc;
    private zzd zzbGq;
    private zza zzbGr;
    private static volatile FirebaseCrash zzbGs;

    public FirebaseCrash(FirebaseApp firebaseApp, boolean bl) {
        this.zzbcc = bl;
        Context context = firebaseApp.getApplicationContext();
        if (context == null) {
            Log.w((String)LOG_TAG, (String)"Application context is missing, disabling api");
            this.zzbcc = false;
        }
        if (this.zzbcc) {
            try {
                String string = firebaseApp.getOptions().getApiKey();
                String string2 = firebaseApp.getOptions().getApplicationId();
                FirebaseCrashOptions firebaseCrashOptions = new FirebaseCrashOptions(string2, string);
                zzg.zzPc().zzah(context);
                this.zzbGq = zzg.zzPc().zzPd();
                this.zzbGq.zza(zze.zzD((Object)context), firebaseCrashOptions);
                this.zzbGr = new zza(context);
                this.zzOZ();
                String string3 = String.valueOf(zzg.zzPc().toString());
                Log.i((String)LOG_TAG, (String)(string3.length() != 0 ? "FirebaseCrash reporting initialized ".concat(string3) : new String("FirebaseCrash reporting initialized ")));
            }
            catch (Exception exception) {
                Log.e((String)LOG_TAG, (String)"Failed to initialize crash reporting", (Throwable)exception);
                this.zzbcc = false;
            }
        } else {
            Log.i((String)LOG_TAG, (String)"Crash reporting is disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FirebaseCrash zzOW() {
        if (zzbGs != null) return zzbGs;
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (zzbGs != null) return zzbGs;
            zzbGs = FirebaseCrash.getInstance(FirebaseApp.getInstance());
            // ** MonitorExit[var0] (shouldn't be in output)
            return zzbGs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    public static FirebaseCrash getInstance(FirebaseApp firebaseApp) {
        Flags.initialize(firebaseApp.getApplicationContext());
        boolean bl = (Boolean)Flags.zzbGz.get();
        FirebaseCrash firebaseCrash = new FirebaseCrash(firebaseApp, bl);
        Class<FirebaseCrash> clazz = FirebaseCrash.class;
        synchronized (FirebaseCrash.class) {
            if (zzbGs == null) {
                zzbGs = firebaseCrash;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return firebaseCrash;
        }
    }

    private zzd zzOX() {
        return this.zzbGq;
    }

    private boolean isEnabled() {
        return this.zzbcc;
    }

    public static void log(String string) {
        try {
            FirebaseCrash.zzOW().zzhJ(string);
        }
        catch (zzb zzb2) {
            Log.v((String)LOG_TAG, (String)zzb2.getMessage());
        }
    }

    public static void logcat(int n, String string, String string2) {
        try {
            FirebaseCrash.zzOW().zzf(n, string, string2);
        }
        catch (zzb zzb2) {
            Log.v((String)LOG_TAG, (String)zzb2.getMessage());
        }
    }

    public static void report(Throwable throwable) {
        try {
            FirebaseCrash.zzOW().zzf(throwable);
        }
        catch (zzb zzb2) {
            Log.v((String)LOG_TAG, (String)zzb2.getMessage());
        }
    }

    public void zzf(int n, String string, String string2) throws zzb {
        if (string2 != null) {
            if (string == null) {
                string = "";
            }
            Log.println((int)n, (String)string, (String)string2);
            this.zzhJ(string2);
        }
    }

    public void zzhJ(String string) throws zzb {
        if (!this.isEnabled()) {
            throw new zzb("Firebase Crash Reporting is disabled.");
        }
        zzd zzd2 = this.zzOX();
        if (zzd2 != null && string != null) {
            try {
                zzd2.log(string);
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"log remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzf(Throwable throwable) throws zzb {
        if (!this.isEnabled()) {
            throw new zzb("Firebase Crash Reporting is disabled.");
        }
        zzd zzd2 = this.zzOX();
        if (zzd2 != null && throwable != null) {
            this.zzbGr.zza(false, System.currentTimeMillis());
            try {
                zzd2.zzhK(this.zzPa());
                zzd2.zzF(zze.zzD((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    public void zzg(Throwable throwable) throws zzb {
        if (!this.isEnabled()) {
            throw new zzb("Firebase Crash Reporting is disabled.");
        }
        zzd zzd2 = this.zzOX();
        if (zzd2 != null && throwable != null) {
            try {
                this.zzbGr.zza(true, System.currentTimeMillis());
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                zzd2.zzhK(this.zzPa());
                zzd2.zzG(zze.zzD((Object)throwable));
            }
            catch (RemoteException remoteException) {
                Log.e((String)LOG_TAG, (String)"report remoting failed", (Throwable)remoteException);
            }
        }
    }

    public static boolean isSingletonInitialized() {
        return zzbGs != null;
    }

    private static boolean zzOY() {
        long l;
        long l2 = Looper.getMainLooper().getThread().getId();
        return l2 == (l = Thread.currentThread().getId());
    }

    private void zzOZ() {
        if (!FirebaseCrash.zzOY()) {
            throw new RuntimeException("FirebaseCrash reporting may only be initialized on the main thread (preferably in your app's Application.onCreate)");
        }
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        zzh zzh2 = new zzh(uncaughtExceptionHandler, this);
        Thread.setDefaultUncaughtExceptionHandler(zzh2);
    }

    private String zzPa() {
        return zzc.zzUl().getId();
    }
}

